/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.SetDataEvent;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.treekit.TreeThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    private static final TreeItem[] EMPTY_SELECTION = new TreeItem[0];
    private static final int MIN_ITEM_HEIGHT = 16;
    private static final int GRID_WIDTH = 1;
    private static final Rectangle TEXT_MARGIN = new Rectangle(3, 0, 8, 0);
    private int itemCount;
    private TreeItem[] items;
    final ItemHolder columnHolder;
    private TreeItem[] selection;
    private boolean linesVisible;
    private int[] columnOrder;
    private int itemImageCount = 0;
    private TreeColumn sortColumn;
    private int sortDirection = 0;
    private boolean headerVisible = false;
    private final ResizeListener resizeListener;
    private final ITreeAdapter treeAdapter;
    private int scrollLeft = 0;
    private int topItemIndex = 0;
    private boolean hasVScrollBar;
    private boolean hasHScrollBar;
    private ScrollBar verticalBar;
    private ScrollBar horizontalBar;
    private Point itemImageSize;
    private Rectangle bufferedCellPadding = null;
    private int bufferedCellSpacing = -1;
    private Rectangle bufferedCheckBoxMargin = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.TreeColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.columnHolder = new ItemHolder(clazz);
        this.treeAdapter = new InternalTreeAdapter();
        this.setTreeEmpty();
        this.createScrollBars();
        this.selection = EMPTY_SELECTION;
        this.resizeListener = new ResizeListener();
        this.addControlListener(this.resizeListener);
    }

    private TreeItem[] getCreatedItems() {
        TreeItem[] result;
        if (this.isVirtual()) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    ++count;
                }
                ++i;
            }
            result = new TreeItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TreeItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private void setTreeEmpty() {
        this.items = new TreeItem[4];
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = new CompositeItemHolder();
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                result = this.treeAdapter;
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.ICellToolTipAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = adapter == clazz3 ? this.treeAdapter : super.getAdapter(adapter);
            }
        }
        return result;
    }

    public void setFont(Font font) {
        super.setFont(font);
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].clearPreferredWidthBuffer();
            ++i;
        }
        this.updateScrollBars();
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int oldItemCount = this.itemCount;
        int newItemCount = Math.max(0, count);
        if (newItemCount != oldItemCount) {
            int index = oldItemCount - 1;
            while (index >= newItemCount) {
                TreeItem item = this.items[index];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                }
                --index;
            }
            int length = Math.max(4, (newItemCount + 3) / 4 * 4);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(newItemCount, this.itemCount));
            this.items = newItems;
            int i = oldItemCount;
            while (i < newItemCount) {
                new TreeItem(this, 0, i);
                ++i;
            }
            this.itemCount = newItemCount;
            this.updateScrollBars();
        }
        this.redraw();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        if (this.isVirtual()) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private TreeItem _getItem(int index) {
        if (this.isVirtual() && this.items[index] == null) {
            this.items[index] = new TreeItem(this, null, 0, index, false);
        }
        return this.items[index];
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        return this._getItem(index);
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return item.parent == this ? item.index : -1;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public void removeAll() {
        this.checkWidget();
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        this.selection = EMPTY_SELECTION;
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.getParent() != this) {
            return;
        }
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            parent.setExpanded(true);
            parent = parent.getParentItem();
        }
        if (item.flatIndex <= this.topItemIndex) {
            this.setTopItemIndex(item.flatIndex);
        } else {
            int itemsAreaHeight = this.getClientArea().height - this.getHeaderHeight();
            int rows = (int)Math.floor(itemsAreaHeight / this.getItemHeight());
            if (item.flatIndex >= this.topItemIndex + rows) {
                this.setTopItemIndex(item.flatIndex - rows + 1);
            }
        }
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.getParent() == this) {
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                parent.setExpanded(true);
                parent = parent.getParentItem();
            }
            int visibleItemsCount = this.collectVisibleItems(null).size();
            int itemsAreaHeight = this.getClientArea().height - this.getHeaderHeight();
            int rows = (int)Math.floor(itemsAreaHeight / this.getItemHeight());
            if (item.flatIndex <= this.topItemIndex || item.flatIndex + rows <= visibleItemsCount) {
                this.setTopItemIndex(item.flatIndex);
            } else {
                int index = Math.max(0, visibleItemsCount - rows);
                this.setTopItemIndex(index);
            }
        }
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        TreeItem result = null;
        if (this.getItemCount() > 0) {
            List visibleItems = this.collectVisibleItems(null);
            result = (TreeItem)visibleItems.get(this.topItemIndex);
        }
        return result;
    }

    private void setTopItemIndex(int index) {
        if (index != this.topItemIndex) {
            this.topItemIndex = index;
            this.checkAllData();
        }
    }

    int getTopIndex() {
        return this.topItemIndex;
    }

    public void showColumn(TreeColumn column) {
        int index;
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.getParent() == this && (index = this.indexOf(column)) >= 0 && index < this.getColumnCount()) {
            int leftColumnsWidth = 0;
            int columnWidth = column.getWidth();
            int clientWidth = this.getClientArea().width;
            int[] columnOrder = this.getColumnOrder();
            boolean found = false;
            int i = 0;
            while (i < columnOrder.length && !found) {
                boolean bl = found = index == columnOrder[i];
                if (!found) {
                    leftColumnsWidth += this.getColumn(columnOrder[i]).getWidth();
                }
                ++i;
            }
            if (this.scrollLeft > leftColumnsWidth) {
                this.scrollLeft = leftColumnsWidth;
            } else if (this.scrollLeft < leftColumnsWidth + columnWidth - clientWidth) {
                this.scrollLeft = leftColumnsWidth + columnWidth - clientWidth;
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selection.length == 0) {
            return;
        }
        this.showItem(this.selection[0]);
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.selection.length];
        System.arraycopy(this.selection, 0, result, 0, this.selection.length);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.length;
    }

    public void setSelection(TreeItem selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        this.setSelection(new TreeItem[]{selection});
    }

    public void setSelection(TreeItem[] selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        int length = selection.length;
        if ((this.style & 4) != 0) {
            if (length == 0 || length > 1) {
                this.deselectAll();
            } else {
                TreeItem item = selection[0];
                if (item != null) {
                    if (item.isDisposed()) {
                        SWT.error(5);
                    }
                    this.selection = new TreeItem[]{item};
                }
            }
        } else if (length == 0) {
            this.deselectAll();
        } else {
            TreeItem[] validSelection = new TreeItem[length];
            int validLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] != null) {
                    if (selection[i].isDisposed()) {
                        SWT.error(5);
                    }
                    validSelection[validLength] = selection[i];
                    ++validLength;
                }
                ++i;
            }
            if (validLength > 0) {
                this.selection = new TreeItem[validLength];
                System.arraycopy(validSelection, 0, this.selection, 0, validLength);
            }
        }
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            this.setSelection(item);
        } else {
            ArrayList<TreeItem> selItems = new ArrayList<TreeItem>(Arrays.asList(this.selection));
            if (!selItems.contains(item)) {
                selItems.add(item);
                this.selection = new TreeItem[selItems.size()];
                selItems.toArray(this.selection);
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            final ArrayList allItems = new ArrayList();
            WidgetTreeVisitor.accept(this, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    if (widget instanceof TreeItem) {
                        allItems.add(widget);
                    }
                    return true;
                }
            });
            this.selection = new TreeItem[allItems.size()];
            allItems.toArray(this.selection);
        }
    }

    public void deselect(TreeItem item) {
        ArrayList<TreeItem> selItems;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((selItems = new ArrayList<TreeItem>(Arrays.asList(this.selection))).contains(item)) {
            selItems.remove(item);
            this.selection = new TreeItem[selItems.size()];
            selItems.toArray(this.selection);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.selection = EMPTY_SELECTION;
    }

    public void setLinesVisible(boolean value) {
        this.checkWidget();
        if (this.linesVisible == value) {
            return;
        }
        this.linesVisible = value;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void clear(int index, boolean recursive) {
        TreeItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
            if (recursive) {
                item.clearAll(true, false);
            }
            this.checkData(item, index);
        }
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TreeItem result = null;
        int index = (point.y - this.getHeaderHeight()) / this.getItemHeight() + this.topItemIndex;
        List visibleItems = this.collectVisibleItems(null);
        if (index >= 0 && index < visibleItems.size()) {
            result = (TreeItem)visibleItems.get(index);
        }
        return result;
    }

    private List collectVisibleItems(TreeItem parent) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        TreeItem[] children = parent == null ? this.getItems() : parent.getItems();
        int i = 0;
        while (i < children.length) {
            TreeItem item = children[i];
            result.add(item);
            if (item.getExpanded()) {
                result.addAll(this.collectVisibleItems(item));
            }
            ++i;
        }
        return result;
    }

    public int getItemHeight() {
        this.checkWidget();
        Rectangle padding = this.getCellPadding();
        int textHeight = Graphics.getCharHeight(this.getFont());
        int itemImageHeight = this.getItemImageSize().y + padding.height;
        int result = Math.max(itemImageHeight, textHeight += Tree.TEXT_MARGIN.height + padding.height);
        if (this.hasCheckBoxes(0)) {
            result = Math.max(this.getCheckImageOuterSize().y, result);
        }
        ++result;
        result = Math.max(result, 16);
        return result;
    }

    public void clearAll(boolean recursive) {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.clear();
                if (recursive) {
                    item.clearAll(true, false);
                }
            }
            ++i;
        }
        if (this.itemCount != 0 && this.isVirtual()) {
            this.checkAllData();
        }
    }

    public void changed(Control[] changed) {
        this.clearItemsPreferredWidthBuffer();
        super.changed(changed);
    }

    private void clearItemsPreferredWidthBuffer() {
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.clearPreferredWidthBuffer();
            }
            ++i;
        }
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnHolder.size();
    }

    void createColumn(TreeColumn column, int index) {
        this.columnHolder.insert(column, index);
        if (this.columnOrder == null) {
            this.columnOrder = new int[]{index};
        } else {
            int length = this.columnOrder.length;
            int i = index;
            while (i < length) {
                int n = i++;
                this.columnOrder[n] = this.columnOrder[n] + 1;
            }
            int[] newColumnOrder = new int[length + 1];
            System.arraycopy(this.columnOrder, 0, newColumnOrder, 0, index);
            System.arraycopy(this.columnOrder, index, newColumnOrder, index + 1, length - index);
            this.columnOrder = newColumnOrder;
            this.columnOrder[index] = index;
        }
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.addColumn(column);
            }
            ++i;
        }
        this.updateScrollBars();
    }

    final void destroyColumn(TreeColumn column) {
        if (!this.isInDispose()) {
            int index = this.indexOf(column);
            if (column == this.sortColumn) {
                this.sortColumn = null;
            }
            this.columnHolder.remove(column);
            int length = this.columnOrder.length;
            int[] newColumnOrder = new int[length - 1];
            int count = 0;
            int i = 0;
            while (i < length) {
                if (this.columnOrder[i] != index) {
                    int newOrder = this.columnOrder[i];
                    if (index < newOrder) {
                        // empty if block
                    }
                    newColumnOrder[count] = --newOrder;
                    ++count;
                }
                ++i;
            }
            this.columnOrder = newColumnOrder;
            this.updateScrollBars();
        }
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int result = 0;
        if (this.headerVisible) {
            TreeThemeAdapter themeAdapter = this.getThemeAdapter();
            Font headerFont = themeAdapter.getHeaderFont(this);
            int textHeight = Graphics.getCharHeight(headerFont);
            int imageHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                int height;
                Image image = this.getColumn(i).getImage();
                int n = height = image == null ? 0 : image.getBounds().height;
                if (height > imageHeight) {
                    imageHeight = height;
                }
                ++i;
            }
            result = Math.max(textHeight, imageHeight);
            result += themeAdapter.getHeaderBorderBottomWidth(this);
            result += themeAdapter.getHeaderPadding((Control)this).height;
        }
        return result;
    }

    public void setHeaderVisible(boolean value) {
        this.checkWidget();
        if (this.headerVisible == value) {
            return;
        }
        this.headerVisible = value;
        this.updateScrollBars();
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.headerVisible;
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        return this.columnHolder.indexOf(column);
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnHolder.size()) {
            this.error(6);
        }
        return (TreeColumn)this.columnHolder.getItem(index);
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        return (TreeColumn[])this.columnHolder.getItems();
    }

    public void setColumnOrder(int[] order) {
        int columnCount;
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (order.length != (columnCount = this.getColumnCount())) {
            this.error(5);
        }
        if (columnCount > 0) {
            int[] oldOrder = new int[columnCount];
            System.arraycopy(this.columnOrder, 0, oldOrder, 0, this.columnOrder.length);
            boolean reorder = false;
            boolean[] seen = new boolean[columnCount];
            int i = 0;
            while (i < order.length) {
                int index = order[i];
                if (index < 0 || index >= columnCount) {
                    this.error(6);
                }
                if (seen[index]) {
                    this.error(5);
                }
                seen[index] = true;
                if (index != oldOrder[i]) {
                    reorder = true;
                }
                ++i;
            }
            if (reorder) {
                System.arraycopy(order, 0, this.columnOrder, 0, this.columnOrder.length);
                i = 0;
                while (i < seen.length) {
                    if (oldOrder[i] != this.columnOrder[i]) {
                        TreeColumn column = this.getColumn(this.columnOrder[i]);
                        int controlMoved = 10;
                        ControlEvent controlEvent = new ControlEvent(column, controlMoved);
                        controlEvent.processEvent();
                    }
                    ++i;
                }
            }
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int[] getColumnOrder() {
        int[] result;
        this.checkWidget();
        if (this.columnHolder.size() == 0) {
            result = new int[]{};
        } else {
            result = new int[this.columnOrder.length];
            System.arraycopy(this.columnOrder, 0, result, 0, this.columnOrder.length);
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        TreeEvent.addListener((Adaptable)this, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        TreeEvent.removeListener((Adaptable)this, listener);
    }

    void releaseWidget() {
        if (this.resizeListener != null) {
            this.removeControlListener(this.resizeListener);
        }
        super.releaseWidget();
    }

    void releaseChildren() {
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
        TreeColumn[] cols = (TreeColumn[])this.columnHolder.getItems();
        int c = 0;
        while (c < cols.length) {
            cols[c].dispose();
            this.columnHolder.remove(cols[c]);
            ++c;
        }
        super.releaseChildren();
    }

    void removeFromSelection(TreeItem item) {
        int index = -1;
        int i = 0;
        while (index == -1 && i < this.selection.length) {
            if (this.selection[i] == item) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            TreeItem[] newSelection = new TreeItem[this.selection.length - 1];
            System.arraycopy(this.selection, 0, newSelection, 0, index);
            if (index < this.selection.length - 1) {
                int length = this.selection.length - index - 1;
                System.arraycopy(this.selection, index + 1, newSelection, index, length);
            }
            this.selection = newSelection;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        TreeItem item;
        int i;
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.getColumnCount() > 0) {
            i = 0;
            while (i < this.getColumnCount()) {
                width += this.getColumn(i).getWidth();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.getItemCount()) {
                item = this.getItem(i);
                if (item.isCached()) {
                    int itemWidth = item.getPreferredWidth(0, false);
                    width = Math.max(width, itemWidth);
                    if (item.getExpanded()) {
                        int innerWidth = this.getMaxInnerWidth(item.getItems(), 1);
                        width = Math.max(width, innerWidth);
                    }
                }
                ++i;
            }
        }
        height += this.getHeaderHeight();
        height += this.getItemCount() * this.getItemHeight();
        i = 0;
        while (i < this.getItemCount()) {
            item = this.getItem(i);
            if (!item.isInDispose() && item.getExpanded()) {
                height += item.getInnerHeight();
            }
            ++i;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.verticalBar.getSize().x;
        }
        if ((this.style & 0x100) != 0) {
            height += this.horizontalBar.getSize().y;
        }
        return new Point(width, height);
    }

    private int getMaxInnerWidth(TreeItem[] items, int level) {
        int maxInnerWidth = 0;
        int i = 0;
        while (i < items.length) {
            if (items[i] != null && items[i].isCached()) {
                int indention = level * this.getIndentionWidth();
                int itemWidth = items[i].getPreferredWidth(0, false) + indention;
                maxInnerWidth = Math.max(maxInnerWidth, itemWidth);
                if (items[i].getExpanded()) {
                    int innerWidth = this.getMaxInnerWidth(items[i].getItems(), level + 1);
                    maxInnerWidth = Math.max(maxInnerWidth, innerWidth);
                }
            }
            ++i;
        }
        return maxInnerWidth;
    }

    int getCellLeft(int index) {
        return this.getColumnCount() == 0 ? 0 : this.getColumn(index).getLeft();
    }

    private int getCellWidth(int index) {
        return this.getColumnCount() == 0 && index == 0 ? this.getMaxInnerWidth(this.getItems(), 1) : this.getColumn(index).getWidth();
    }

    int getImageOffset(int index) {
        int result;
        int n = result = this.isTreeColumn(index) ? 0 : this.getCellPadding().x;
        if (this.hasCheckBoxes(index)) {
            result += this.getCheckImageOuterSize().x;
        }
        return result;
    }

    private int getTextOffset(int index) {
        int result = this.getImageOffset(index);
        result += this.getItemImageOuterWidth(index);
        if (this.isTreeColumn(index)) {
            result += Tree.TEXT_MARGIN.x;
        }
        return result;
    }

    int getTextWidth(int index) {
        int result = this.getCellWidth(index) - this.getTextOffset(index);
        if (this.isTreeColumn(index)) {
            result -= Tree.TEXT_MARGIN.width - Tree.TEXT_MARGIN.x;
        }
        return Math.max(0, result);
    }

    int getIndentionOffset(TreeItem item) {
        return this.getIndentionWidth() * (item.depth + 1);
    }

    int getVisualCellLeft(int index, TreeItem item) {
        int result = this.getCellLeft(index) - this.scrollLeft;
        if (this.isTreeColumn(index)) {
            result += this.getIndentionOffset(item);
        }
        if (this.hasCheckBoxes(index)) {
            result += this.getCheckImageOuterSize().x;
        }
        return result;
    }

    int getVisualCellWidth(int index, TreeItem item, boolean checkData) {
        int result;
        if (this.getColumnCount() == 0 && index == 0) {
            String text = item.getText(0, checkData);
            int textWidth = Graphics.stringExtent((Font)item.getFont((boolean)checkData), (String)text).x;
            result = this.getCellPadding().width + this.getItemImageOuterWidth(index) + textWidth + Tree.TEXT_MARGIN.width;
        } else {
            result = this.getColumn(index).getWidth();
            if (this.isTreeColumn(index)) {
                result -= this.getIndentionOffset(item);
            }
            if (this.hasCheckBoxes(index)) {
                result -= this.getCheckImageOuterSize().x;
            }
            result = Math.max(0, result);
        }
        return result;
    }

    int getVisualTextLeft(int index, TreeItem item) {
        return this.getVisualCellLeft(index, item) + this.getCellPadding().x + this.getItemImageOuterWidth(index);
    }

    int getVisualTextWidth(int index, TreeItem item) {
        int result = 0;
        if (index == 0 && this.getColumnCount() == 0) {
            result = Graphics.stringExtent((Font)item.getFont(), (String)item.getText((int)0)).x;
            result += Tree.TEXT_MARGIN.width;
        } else if (index >= 0 && index < this.getColumnCount()) {
            result = this.getTextWidth(index) - this.getIndentionOffset(item);
            result = Math.max(0, result);
        }
        return result;
    }

    int getPreferredCellWidth(TreeItem item, int columnIndex, boolean checkData) {
        int result = item.getPreferredWidthBuffer();
        if (!item.hasPreferredWidthBuffer()) {
            result = this.getTextOffset(columnIndex);
            Rectangle padding = this.getCellPadding();
            result += Graphics.stringExtent((Font)this.getFont(), (String)item.getText((int)columnIndex, (boolean)checkData)).x;
            result += padding.width - padding.x;
            if (this.isTreeColumn(columnIndex)) {
                result += Tree.TEXT_MARGIN.width - Tree.TEXT_MARGIN.x;
            }
            item.setPreferredWidthBuffer(result);
        }
        return result;
    }

    boolean isTreeColumn(int index) {
        return index == 0 && this.getColumnCount() == 0 || this.getColumnCount() > 0 && this.getColumnOrder()[0] == index;
    }

    private boolean hasCheckBoxes(int index) {
        return (this.style & 0x20) != 0 && this.isTreeColumn(index);
    }

    private boolean hasColumnImages(int columnIndex) {
        int count;
        int n = count = columnIndex == 0 ? this.itemImageCount : this.getColumn((int)columnIndex).itemImageCount;
        return count > 0;
    }

    void updateColumnImageCount(int columnIndex, Image oldImage, Image newImage) {
        int delta = 0;
        if (oldImage == null && newImage != null) {
            delta = 1;
        } else if (oldImage != null && newImage == null) {
            delta = -1;
        }
        if (delta != 0) {
            if (columnIndex == 0) {
                this.itemImageCount += delta;
            } else {
                TreeColumn column = this.getColumn(columnIndex);
                column.itemImageCount += delta;
            }
        }
    }

    void updateItemImageSize(Image image) {
        if (image != null && this.itemImageSize == null) {
            Rectangle imageBounds = image.getBounds();
            this.itemImageSize = new Point(imageBounds.width, imageBounds.height);
        }
    }

    Point getItemImageSize(int index) {
        Point result;
        if (this.hasColumnImages(index)) {
            result = this.getItemImageSize();
            if (this.getColumnCount() > 0) {
                int availWidth = this.getColumn(index).getWidth();
                availWidth -= this.getCellPadding().x;
                availWidth = Math.max(0, availWidth);
                result.x = Math.min(result.x, availWidth);
            }
        } else {
            result = new Point(0, 0);
        }
        return result;
    }

    private int getItemImageOuterWidth(int index) {
        int result = 0;
        if (this.hasColumnImages(index)) {
            result += this.getItemImageSize((int)index).x;
            result += this.getCellSpacing();
        }
        return result;
    }

    private Point getItemImageSize() {
        Point result = new Point(0, 0);
        if (this.itemImageSize != null) {
            result.x = this.itemImageSize.x;
            result.y = this.itemImageSize.y;
        }
        return result;
    }

    private Point getCheckImageSize() {
        return this.getThemeAdapter().getCheckBoxImageSize(this);
    }

    private TreeThemeAdapter getThemeAdapter() {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TreeThemeAdapter)this.getAdapter(clazz);
    }

    private Point getCheckImageOuterSize() {
        Point result = this.getCheckImageSize();
        Rectangle margin = this.getCheckBoxMargin();
        result.x += margin.width;
        result.y += margin.height;
        return result;
    }

    private Rectangle getCheckBoxMargin() {
        if (this.bufferedCheckBoxMargin == null) {
            this.bufferedCheckBoxMargin = this.getThemeAdapter().getCheckBoxMargin(this);
        }
        return this.bufferedCheckBoxMargin;
    }

    private int getIndentionWidth() {
        return this.getThemeAdapter().getIndentionWidth(this);
    }

    void checkAllData() {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(this){
                    int flatIndex;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.flatIndex = 0;
                    }

                    public boolean doVisit(Widget widget) {
                        boolean result = true;
                        if (widget instanceof TreeItem) {
                            TreeItem item = (TreeItem)widget;
                            result = item.getExpanded();
                            TreeItem parentItem = item.getParentItem();
                            int index = parentItem != null ? parentItem.indexOf(item) : 2.access$0(this.this$1).indexOf(item);
                            item.flatIndex = this.flatIndex++;
                            if (!item.isCached() && Tree.access$10(2.access$0(this.this$1), item)) {
                                2.access$0(this.this$1).checkData(item, index);
                            }
                        }
                        return result;
                    }
                };
                WidgetTreeVisitor.accept(Tree.this, visitor);
            }

            static /* synthetic */ Tree access$0(2 var0) {
                return var0.Tree.this;
            }
        });
    }

    private boolean isItemVisible(TreeItem item) {
        boolean result = false;
        int itemPosition = item.getItemTop();
        if (itemPosition >= 0 && itemPosition <= this.getSize().y) {
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                if (parentItem.getExpanded()) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    void updateFlatIndices() {
        int flatIndex = 0;
        TreeItem[] uItems = this.getItems();
        int i = 0;
        while (i < uItems.length) {
            TreeItem treeItem = uItems[i];
            treeItem.flatIndex = flatIndex++;
            flatIndex = this.updateFlatIndicesSub(treeItem, flatIndex);
            ++i;
        }
    }

    private int updateFlatIndicesSub(TreeItem item, int flatIndex) {
        int newFlatIndex = flatIndex;
        if (item.getExpanded()) {
            TreeItem[] subItems = item.getItems();
            int i = 0;
            while (i < subItems.length) {
                TreeItem subItem = subItems[i];
                subItem.flatIndex = newFlatIndex++;
                newFlatIndex = this.updateFlatIndicesSub(subItem, newFlatIndex);
                ++i;
            }
        }
        return newFlatIndex;
    }

    final void checkData(TreeItem item, int index) {
        if (this.isVirtual() && !item.isCached()) {
            item.markCached();
            SetDataEvent event = new SetDataEvent(this, item, index);
            event.processEvent();
            if (this.isDisposed() || item.isDisposed()) {
                SWT.error(24);
            }
        }
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((style & 0x10) == 0) {
            result |= 0x300;
        }
        return Tree.checkBits(result, 4, 2, 0, 0, 0, 0);
    }

    Rectangle getCellPadding() {
        if (this.bufferedCellPadding == null) {
            this.bufferedCellPadding = this.getThemeAdapter().getCellPadding(this);
        }
        return this.bufferedCellPadding;
    }

    int getCellSpacing() {
        if (this.bufferedCellSpacing < 0) {
            this.bufferedCellSpacing = this.getThemeAdapter().getCellSpacing(this);
        }
        return this.bufferedCellSpacing;
    }

    private void createScrollBars() {
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = new ScrollBar(this, 256);
            this.horizontalBar.setVisible(false);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = new ScrollBar(this, 512);
            this.verticalBar.setVisible(false);
        }
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean hasVScrollBar() {
        return this.hasVScrollBar;
    }

    boolean hasHScrollBar() {
        return this.hasHScrollBar;
    }

    int getVScrollBarWidth() {
        int result = 0;
        if (this.hasVScrollBar()) {
            result = this.verticalBar.getSize().x;
        }
        return result;
    }

    int getHScrollBarHeight() {
        int result = 0;
        if (this.hasHScrollBar()) {
            result = this.horizontalBar.getSize().y;
        }
        return result;
    }

    boolean needsVScrollBar() {
        int availableHeight = this.getClientArea().height;
        int height = this.getHeaderHeight();
        height += this.getItemCount() * this.getItemHeight();
        int i = 0;
        while (i < this.getItemCount()) {
            TreeItem item = this.getItem(i);
            if (item.getExpanded()) {
                height += item.getInnerHeight();
            }
            ++i;
        }
        return height > availableHeight;
    }

    boolean needsHScrollBar() {
        boolean result = false;
        int availableWidth = this.getClientArea().width;
        int columnCount = this.getColumnCount();
        if (columnCount > 0) {
            int totalWidth = 0;
            int i = 0;
            while (i < columnCount) {
                TreeColumn column = this.getColumn(i);
                totalWidth += column.getWidth();
                ++i;
            }
            result = totalWidth > availableWidth;
        } else {
            int maxWidth = 0;
            int i = 0;
            while (i < this.getItemCount()) {
                TreeItem item = this.getItem(i);
                if (item != null && !item.isInDispose() && item.isCached()) {
                    int itemWidth = item.getPreferredWidth(0, false);
                    maxWidth = Math.max(maxWidth, itemWidth);
                    if (item.getExpanded()) {
                        int innerWidth = this.getMaxInnerWidth(item.getItems(), 1);
                        maxWidth = Math.max(maxWidth, innerWidth);
                    }
                }
                ++i;
            }
            result = maxWidth > availableWidth;
        }
        return result;
    }

    void updateScrollBars() {
        if ((this.style & 0x10) == 0) {
            this.hasVScrollBar = false;
            this.hasHScrollBar = this.needsHScrollBar();
            if (this.needsVScrollBar()) {
                this.hasVScrollBar = true;
                this.hasHScrollBar = this.needsHScrollBar();
            }
            this.horizontalBar.setVisible(this.hasHScrollBar);
            this.verticalBar.setVisible(this.hasVScrollBar);
        }
    }

    void reskinChildren(int flags) {
        TreeColumn[] columns;
        TreeItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (item != null) {
                    item.reskinChildren(flags);
                }
                ++i;
            }
        }
        if ((columns = this.getColumns()) != null) {
            int i = 0;
            while (i < columns.length) {
                TreeColumn column = columns[i];
                if (!column.isDisposed()) {
                    column.reskinChildren(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean isVirtual() {
        return (this.style & 0x10000000) != 0;
    }

    void createItem(TreeItem item, int index) {
        if (this.itemCount == this.items.length) {
            boolean small = this.isVisible();
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        this.adjustItemIndices(index);
    }

    void destroyItem(TreeItem treeItem, int index) {
        --this.itemCount;
        if (this.itemCount == 0) {
            this.setTreeEmpty();
        } else {
            System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
            this.items[this.itemCount] = null;
        }
        this.adjustItemIndices(index);
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].index = i;
            }
            ++i;
        }
    }

    static /* synthetic */ boolean access$10(Tree tree, TreeItem treeItem) {
        return tree.isItemVisible(treeItem);
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            if (!(item instanceof TreeColumn)) {
                String msg = "Only TreeColumns may be added to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Tree.this.columnHolder.add(item);
        }

        public void insert(Item item, int index) {
            if (!(item instanceof TreeColumn)) {
                String msg = "Only TreeColumns may be inserted to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Tree.this.columnHolder.insert(item, index);
        }

        public void remove(Item item) {
            if (!(item instanceof TreeColumn)) {
                String msg = "Only TreeColumns may be removed from CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Tree.this.columnHolder.remove(item);
        }

        public Item[] getItems() {
            TreeItem[] items = Tree.this.getCreatedItems();
            Item[] columns = Tree.this.columnHolder.getItems();
            Item[] result = new Item[columns.length + items.length];
            System.arraycopy(columns, 0, result, 0, columns.length);
            System.arraycopy(items, 0, result, columns.length, items.length);
            return result;
        }
    }

    private final class InternalTreeAdapter
    implements ITreeAdapter,
    ICellToolTipAdapter {
        private String toolTipText;
        private ICellToolTipProvider provider;

        private InternalTreeAdapter() {
        }

        public void setScrollLeft(int left) {
            Tree.this.scrollLeft = left;
        }

        public int getScrollLeft() {
            return Tree.this.scrollLeft;
        }

        public boolean isCached(TreeItem item) {
            return item.isCached();
        }

        public void checkAllData(Tree tree) {
            tree.checkAllData();
        }

        public boolean hasHScrollBar() {
            return Tree.this.hasHScrollBar();
        }

        public boolean hasVScrollBar() {
            return Tree.this.hasVScrollBar();
        }

        public Point getItemImageSize(int index) {
            return Tree.this.getItemImageSize(index);
        }

        public int getCellLeft(int index) {
            return Tree.this.getCellLeft(index);
        }

        public int getCellWidth(int index) {
            return Tree.this.getCellWidth(index);
        }

        public int getTextOffset(int index) {
            return Tree.this.getTextOffset(index);
        }

        public int getTextMaxWidth(int index) {
            return Tree.this.getTextWidth(index);
        }

        public int getCheckWidth() {
            return ((Tree)Tree.this).getCheckImageSize().x;
        }

        public int getImageOffset(int index) {
            return Tree.this.getImageOffset(index);
        }

        public int getIndentionWidth() {
            return Tree.this.getIndentionWidth();
        }

        public int getCheckLeft() {
            return ((Tree)Tree.this).getCheckBoxMargin().x;
        }

        public Rectangle getTextMargin() {
            return TEXT_MARGIN;
        }

        public int getTopItemIndex() {
            return Tree.this.getTopIndex();
        }

        public void setTopItemIndex(int index) {
            Tree.this.setTopItemIndex(index);
        }

        public int getColumnLeft(TreeColumn column) {
            int index = Tree.this.indexOf(column);
            return Tree.this.getColumn(index).getLeft();
        }

        public ICellToolTipProvider getCellToolTipProvider() {
            return this.provider;
        }

        public void setCellToolTipProvider(ICellToolTipProvider provider) {
            this.provider = provider;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public void setToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
        }
    }

    private static final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent event) {
            Tree tree = (Tree)event.widget;
            if (tree.isVirtual()) {
                tree.checkAllData();
            }
            tree.updateScrollBars();
        }
    }
}

