/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.TypeVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CanonicalModelProcessor
extends AbstractProcessor {
    protected static MetadataMirrorFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCanonicalModelClass(Element element, PersistenceUnit persistenceUnit) throws IOException {
        Writer writer = null;
        try {
            ClassAccessor accessor = persistenceUnit.getClassAccessor(element);
            String qualifiedName = accessor.getAccessibleObjectName();
            String className = this.getName(qualifiedName);
            String classPackage = this.getPackage(qualifiedName);
            String qualifiedCanonicalName = persistenceUnit.getQualifiedCanonicalName(qualifiedName);
            String canonicalName = this.getName(qualifiedCanonicalName);
            String canonicalpackage = this.getPackage(qualifiedCanonicalName);
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(qualifiedCanonicalName, element);
            writer = file.openWriter();
            if (!canonicalpackage.equals("")) {
                writer.append("package " + canonicalpackage + ";\n\n");
            }
            ArrayList<String> attributes = new ArrayList<String>();
            HashMap<String, String> imports = new HashMap<String, String>();
            if (!classPackage.equals(canonicalpackage)) {
                imports.put(className, qualifiedName);
            }
            for (MappingAccessor mappingAccessor : accessor.getDescriptor().getAccessors()) {
                String attributeType;
                if (mappingAccessor.isTransient()) continue;
                MetadataAnnotatedElement annotatedElement = mappingAccessor.getAnnotatedElement();
                MetadataClass rawClass = annotatedElement.getRawClass(mappingAccessor.getDescriptor());
                String types = className;
                if (mappingAccessor.isBasic()) {
                    types = types + ", " + this.getUnqualifiedType(this.getBoxedType(annotatedElement), imports);
                    attributeType = AttributeType.SingularAttribute.name();
                    imports.put(attributeType, "javax.persistence.metamodel.SingularAttribute");
                } else {
                    if (rawClass.isList()) {
                        attributeType = AttributeType.ListAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.ListAttribute");
                    } else if (rawClass.isSet()) {
                        attributeType = AttributeType.SetAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.SetAttribute");
                    } else if (rawClass.isMap()) {
                        attributeType = AttributeType.MapAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.MapAttribute");
                    } else if (rawClass.isCollection()) {
                        attributeType = AttributeType.CollectionAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.CollectionAttribute");
                    } else {
                        attributeType = AttributeType.SingularAttribute.name();
                        imports.put(attributeType, "javax.persistence.metamodel.SingularAttribute");
                    }
                    if (mappingAccessor.isMapAccessor()) {
                        if (mappingAccessor.isMappedKeyMapAccessor()) {
                            MetadataClass mapKeyClass = ((MappedKeyMapAccessor)mappingAccessor).getMapKeyClass();
                            types = types + ", " + this.getUnqualifiedType(mapKeyClass.getName(), imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                        } else {
                            String mapKeyType = annotatedElement.isGenericCollectionType() ? (String)annotatedElement.getGenericType().get(1) : (mappingAccessor.getReferenceDescriptor().hasIdAccessor() ? ((IdAccessor)mappingAccessor.getReferenceDescriptor().getIdAccessors().get(0)).getAnnotatedElement().getType() : TypeVisitor.GENERIC_TYPE);
                            types = types + ", " + this.getUnqualifiedType(mapKeyType, imports) + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                        }
                    } else {
                        types = types + ", " + this.getUnqualifiedType(mappingAccessor.getReferenceClassName(), imports);
                    }
                }
                attributes.add("\tpublic static volatile " + attributeType + "<" + types + "> " + annotatedElement.getAttributeName() + ";\n");
            }
            String parent = this.writeImportStatements(imports, accessor, writer, persistenceUnit, canonicalpackage);
            writer.append("@Generated(\"EclipseLink - " + new Date() + "\")\n");
            writer.append("@StaticMetamodel(" + className + ".class)\n");
            int modifier = accessor.getAccessibleObject().getModifiers();
            writer.append(Modifier.toString(modifier) + " class " + canonicalName);
            if (parent == null) {
                writer.append(" { \n\n");
            } else {
                writer.append(" extends " + parent + " {\n\n");
            }
            for (String str : attributes) {
                writer.append(str);
            }
            writer.append("\n}");
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
                writer = null;
            }
        }
    }

    protected void generateCanonicalModelClasses(RoundEnvironment roundEnv, PersistenceUnit persistenceUnit) throws IOException {
        for (Element element : roundEnv.getRootElements()) {
            if (!persistenceUnit.containsElement(element)) continue;
            this.generateCanonicalModelClass(element, persistenceUnit);
        }
    }

    protected String getBoxedType(MetadataAnnotatedElement annotatedElement) {
        PrimitiveType primitiveType = (PrimitiveType)annotatedElement.getPrimitiveType();
        if (primitiveType != null) {
            return this.processingEnv.getTypeUtils().boxedClass(primitiveType).toString();
        }
        return annotatedElement.getType();
    }

    protected String getName(String qualifiedName) {
        if (qualifiedName.indexOf(".") > -1) {
            return qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        }
        return qualifiedName;
    }

    protected String getPackage(String qualifiedName) {
        if (qualifiedName.indexOf(".") > -1) {
            return qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
        }
        return "";
    }

    protected String getUnqualifiedType(String type, HashMap<String, String> imports) {
        if ((type = type.trim()).contains("void")) {
            return TypeVisitor.GENERIC_TYPE;
        }
        if (type.startsWith("java.lang")) {
            return type.substring(type.lastIndexOf(".") + 1);
        }
        if (type.indexOf("<") > -1) {
            String raw = type.substring(0, type.indexOf("<"));
            String generic = type.substring(type.indexOf("<") + 1, type.length() - 1);
            if (raw.contains("Map")) {
                String key = generic.substring(0, generic.indexOf(","));
                String value = generic.substring(generic.indexOf(",") + 1);
                return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(key, imports) + ", " + this.getUnqualifiedType(value, imports) + ">";
            }
            return this.getUnqualifiedType(raw, imports) + "<" + this.getUnqualifiedType(generic, imports) + ">";
        }
        if (type.indexOf(".") > -1) {
            String shortClassName = type.substring(type.lastIndexOf(".") + 1);
            if (imports.containsKey(shortClassName)) {
                if (imports.get(shortClassName).equals(type)) {
                    return type.substring(type.lastIndexOf(".") + 1);
                }
                return type;
            }
            if (shortClassName.indexOf("[") > 1) {
                imports.put(shortClassName, type.substring(0, type.indexOf("[")));
            } else {
                imports.put(shortClassName, type);
            }
            return shortClassName;
        }
        return type;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver() && !roundEnv.errorRaised()) {
            try {
                if (factory == null) {
                    MetadataLogger logger = new MetadataLogger((AbstractSession)new ServerSession(new Project(new DatabaseLogin())));
                    factory = new MetadataMirrorFactory(logger, Thread.currentThread().getContextClassLoader());
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Creating the metadata factory ...");
                }
                factory.setEnvironments(this.processingEnv, roundEnv);
                PersistenceUnitReader puReader = new PersistenceUnitReader(factory);
                for (PersistenceUnit persistenceUnit : puReader.getPersistenceUnits()) {
                    for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
                        persistenceUnit.addEntityAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
                        persistenceUnit.addEmbeddableAccessor(element);
                    }
                    for (Element element : roundEnv.getElementsAnnotatedWith(MappedSuperclass.class)) {
                        persistenceUnit.addMappedSuperclassAccessor(element);
                    }
                    persistenceUnit.preProcessForCanonicalModel();
                    this.generateCanonicalModelClasses(roundEnv, persistenceUnit);
                }
            }
            catch (Exception e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.toString());
                for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, stackTraceElement.toString());
                }
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    protected String writeImportStatements(HashMap<String, String> typeImports, ClassAccessor accessor, Writer writer, PersistenceUnit persistenceUnit, String childCanonicalpackage) throws IOException {
        String parentCanonicalName = null;
        ArrayList<String> imps = new ArrayList<String>();
        imps.addAll(typeImports.values());
        imps.add("javax.annotation.Generated");
        imps.add("javax.persistence.metamodel.StaticMetamodel");
        MetadataClass cls = (MetadataClass)accessor.getAnnotatedElement();
        MetadataClass parentCls = cls.getSuperclass();
        MetadataProject project = accessor.getProject();
        if (project.hasEntity(parentCls) || project.hasEmbeddable(parentCls) || project.hasMappedSuperclass(parentCls)) {
            String qualifiedParentCanonicalName = persistenceUnit.getQualifiedCanonicalName(parentCls.getName());
            parentCanonicalName = this.getName(qualifiedParentCanonicalName);
            String parentCanonicalPackage = this.getPackage(qualifiedParentCanonicalName);
            if (!parentCanonicalPackage.equals(childCanonicalpackage)) {
                imps.add(qualifiedParentCanonicalName);
            }
        }
        Collections.sort(imps);
        for (String typeImport : imps) {
            writer.append("import " + typeImport + ";\n");
        }
        writer.append("\n");
        return parentCanonicalName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AttributeType {
        CollectionAttribute,
        ListAttribute,
        MapAttribute,
        SetAttribute,
        SingularAttribute;

    }
}

