/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.CollectionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetContextClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DB2ZPlatform
extends DB2Platform {
    private static String DB2_CALLABLESTATEMENT_CLASS = "com.ibm.db2.jcc.DB2CallableStatement";
    private static String DB2_PREPAREDSTATEMENT_CLASS = "com.ibm.db2.jcc.DB2PreparedStatement";

    public DB2ZPlatform() {
        this.pingSQL = "SELECT COUNT(*) from SYSIBM.SYSDUMMY1 WHERE 1 = 0";
    }

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable<Class<?>, FieldTypeDefinition> res = super.buildFieldTypes();
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            res.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        }
        return res;
    }

    @Override
    public String getTableCreationSuffix() {
        if (this.getUseNationalCharacterVaryingTypeForString()) {
            return " CCSID UNICODE";
        }
        return super.getTableCreationSuffix();
    }

    @Override
    public String getProcedureArgument(String name, Object parameter, DatasourceCall.ParameterType parameterType, StoredProcedureCall call, AbstractSession session) {
        if (name != null && this.shouldPrintStoredProcedureArgumentNameInCall()) {
            return ":" + name;
        }
        return "?";
    }

    @Override
    public String getProcedureOptionList() {
        return " DISABLE DEBUG MODE ";
    }

    @Override
    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            if (this.getUseNationalCharacterVaryingTypeForString()) {
                this.timestampQuery = new ValueReadQuery();
                this.timestampQuery.setSQLString("SELECT CAST (CURRENT TIMESTAMP AS TIMESTAMP CCSID UNICODE) FROM SYSIBM.SYSDUMMY1");
                this.timestampQuery.setAllowNativeSQLQuery(true);
            } else {
                this.timestampQuery = super.getTimestampQuery();
            }
        }
        return this.timestampQuery;
    }

    @Override
    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.avgOperator());
        this.addOperator(this.sumOperator());
        this.addOperator(this.absOperator());
        this.addOperator(this.sqrtOperator());
        this.addOperator(this.trimOperator());
        this.addOperator(this.ltrimOperator());
        this.addOperator(this.rtrimOperator());
        this.addOperator(this.locateOperator());
        this.addOperator(this.locate2Operator());
        this.addOperator(this.equalOperator());
        this.addOperator(this.notEqualOperator());
        this.addOperator(this.lessThanOperator());
        this.addOperator(this.lessThanEqualOperator());
        this.addOperator(this.greaterThanOperator());
        this.addOperator(this.greaterThanEqualOperator());
        this.addOperator(this.isNullOperator());
        this.addOperator(this.isNotNullOperator());
        this.addOperator(this.modOperator());
        this.addOperator(this.betweenOperator());
        this.addOperator(this.notBetweenOperator());
        this.addOperator(this.inOperator());
        this.addOperator(this.likeEscapeOperator());
        this.addOperator(this.notLikeEscapeOperator());
        this.addOperator(this.ceilingOperator());
        this.addOperator(this.floorOperator());
        this.addOperator(this.expOperator());
        this.addOperator(this.lnOperator());
        this.addOperator(this.powerOperator());
        this.addOperator(this.signOperator());
    }

    protected ExpressionOperator avgOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.average().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator sumOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.sum().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator absOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.abs().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator concatOperator() {
        ExpressionOperator operatorS = super.concatOperator();
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        operatorS.copyTo(operator);
        return operator;
    }

    protected ExpressionOperator equalOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.equal().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator notEqualOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.notEqual().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator greaterThanOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.greaterThan().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator greaterThanEqualOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.greaterThanEqual().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator lessThanOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.lessThan().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator lessThanEqualOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.lessThanEqual().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator isNullOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.isNull().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator isNotNullOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.notNull().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator betweenOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.between().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator notBetweenOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAtLeast1BindingExpression();
        ExpressionOperator.notBetween().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator likeEscapeOperator() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                int i;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                if (this.argumentIndices == null) {
                    this.argumentIndices = new int[items.size()];
                    for (i = 0; i < this.argumentIndices.length; ++i) {
                        this.argumentIndices[i] = i;
                    }
                }
                for (i = 0; i < items.size(); ++i) {
                    if (i != items.size() - 1) continue;
                    int index = this.argumentIndices[i];
                    Expression item = items.get(index);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                for (int i = 0; i < items.size(); ++i) {
                    if (i != items.size() - 1) continue;
                    Expression item = items.get(i);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printJavaCollection(items, printer);
            }
        };
        ExpressionOperator.likeEscape().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator notLikeEscapeOperator() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printCollection(List<Expression> items, ExpressionSQLPrinter printer) {
                int i;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printCollection(items, printer);
                    return;
                }
                if (this.argumentIndices == null) {
                    this.argumentIndices = new int[items.size()];
                    for (i = 0; i < this.argumentIndices.length; ++i) {
                        this.argumentIndices[i] = i;
                    }
                }
                for (i = 0; i < items.size(); ++i) {
                    if (i != items.size() - 1) continue;
                    int index = this.argumentIndices[i];
                    Expression item = items.get(index);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printCollection(items, printer);
            }

            @Override
            public void printJavaCollection(List<Expression> items, ExpressionJavaPrinter printer) {
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaCollection(items, printer);
                    return;
                }
                for (int i = 0; i < items.size(); ++i) {
                    if (i != items.size() - 1) continue;
                    Expression item = items.get(i);
                    if (item.isParameterExpression()) {
                        ((ParameterExpression)item).setCanBind(false);
                        continue;
                    }
                    if (!item.isConstantExpression()) continue;
                    ((ConstantExpression)item).setCanBind(false);
                }
                super.printJavaCollection(items, printer);
            }
        };
        ExpressionOperator.notLikeEscape().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator locateOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.locate().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator locate2Operator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.locate2().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator modOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.mod().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator sqrtOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.sqrt().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator trimOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.trim().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator trim2() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.trim2().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator ltrimOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.leftTrim().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator ltrim2Operator() {
        ExpressionOperator operatorS = super.ltrim2Operator();
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        operatorS.copyTo(operator);
        return operator;
    }

    protected ExpressionOperator rtrimOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.rightTrim().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator rtrim2Operator() {
        ExpressionOperator operatorS = super.rtrim2Operator();
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        operatorS.copyTo(operator);
        return operator;
    }

    protected ExpressionOperator inOperator() {
        ExpressionOperator operator = new ExpressionOperator(){

            @Override
            public void printDuo(Expression first, Expression second, ExpressionSQLPrinter printer) {
                Object val;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printDuo(first, second, printer);
                    return;
                }
                if (!first.isValueExpression() || first.isConstantExpression() && !printer.getPlatform().shouldBindLiterals()) {
                    super.printDuo(first, second, printer);
                    return;
                }
                boolean firstBound = true;
                if (second instanceof CollectionExpression && (val = ((CollectionExpression)second).getValue()) instanceof Collection) {
                    firstBound = false;
                    Collection values = (Collection)val;
                    for (Object value : values) {
                        if (value instanceof Expression && !((Expression)value).isValueExpression()) {
                            firstBound = true;
                            break;
                        }
                        if (!(value instanceof Expression) || !((Expression)value).isConstantExpression() || printer.getPlatform().shouldBindLiterals()) continue;
                        firstBound = true;
                        break;
                    }
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(firstBound);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(firstBound);
                }
                super.printDuo(first, second, printer);
            }

            @Override
            public void printJavaDuo(Expression first, Expression second, ExpressionJavaPrinter printer) {
                Object val;
                if (!printer.getPlatform().shouldBindPartialParameters()) {
                    super.printJavaDuo(first, second, printer);
                    return;
                }
                if (!first.isValueExpression() || first.isConstantExpression() && !printer.getPlatform().shouldBindLiterals()) {
                    super.printJavaDuo(first, second, printer);
                    return;
                }
                boolean firstBound = true;
                if (second instanceof CollectionExpression && (val = ((CollectionExpression)second).getValue()) instanceof Collection) {
                    firstBound = false;
                    Collection values = (Collection)val;
                    for (Object value : values) {
                        if (value instanceof Expression && !((Expression)value).isValueExpression()) {
                            firstBound = true;
                            break;
                        }
                        if (!(value instanceof Expression) || !((Expression)value).isConstantExpression() || printer.getPlatform().shouldBindLiterals()) continue;
                        firstBound = true;
                        break;
                    }
                }
                if (first.isParameterExpression()) {
                    ((ParameterExpression)first).setCanBind(firstBound);
                } else if (first.isConstantExpression()) {
                    ((ConstantExpression)first).setCanBind(firstBound);
                }
                super.printJavaDuo(first, second, printer);
            }
        };
        ExpressionOperator.in().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator ceilingOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.ceil().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator floorOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.floor().copyTo(operator);
        return operator;
    }

    @Override
    protected ExpressionOperator roundOperator() {
        ExpressionOperator operatorS = super.roundOperator();
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        operatorS.copyTo(operator);
        return operator;
    }

    protected ExpressionOperator expOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.exp().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator lnOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.ln().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator powerOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.power().copyTo(operator);
        return operator;
    }

    protected ExpressionOperator signOperator() {
        ExpressionOperator operator = DB2ZPlatform.disableAllBindingExpression();
        ExpressionOperator.sign().copyTo(operator);
        return operator;
    }

    @Override
    public boolean isDB2Z() {
        return true;
    }

    @Override
    public String buildProcedureCallString(StoredProcedureCall call, AbstractSession session, AbstractRecord row) {
        StringWriter writer = new StringWriter();
        writer.write(call.getCallHeader(this));
        writer.write(call.getProcedureName());
        if (this.requiresProcedureCallBrackets()) {
            writer.write("(");
        } else {
            writer.write(" ");
        }
        int indexFirst = call.getFirstParameterIndexForCallString();
        int size = call.getParameters().size();
        for (int index = indexFirst; index < size; ++index) {
            String name = call.getProcedureArgumentNames().get(index);
            Object parameter = call.getParameters().get(index);
            DatasourceCall.ParameterType parameterType = call.getParameterTypes().get(index);
            if (call.hasOptionalArguments() && call.getOptionalArguments().contains(parameter) && row.get(parameter) == null) continue;
            writer.write(this.getProcedureArgument(name, parameter, parameterType, call, session));
            if (DatasourceCall.isOutputParameterType(parameterType) && this.requiresProcedureCallOuputToken()) {
                writer.write(" ");
                writer.write(this.getOutputProcedureToken());
            }
            if (index + 1 >= call.getParameters().size()) continue;
            writer.write(", ");
        }
        if (this.requiresProcedureCallBrackets()) {
            writer.write(")");
        }
        writer.write(this.getProcedureCallTail());
        return writer.toString();
    }

    @Override
    public void registerOutputParameter(CallableStatement statement, String name, int jdbcType) throws SQLException {
        block6: {
            try {
                String methodName = "registerJccOutParameterAtName";
                Class[] methodArgs = new Class[]{String.class, Integer.TYPE};
                Object[] parameters = new Object[]{name, jdbcType};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        ClassLoader cl = AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(DB2_CALLABLESTATEMENT_CLASS, true, cl));
                        Method method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, methodArgs, true));
                        Object o = statement.unwrap(clazz);
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(method, o, parameters));
                        break block6;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                ClassLoader cl = PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
                Class clazz = PrivilegedAccessHelper.getClassForName(DB2_CALLABLESTATEMENT_CLASS, true, cl);
                Method method = PrivilegedAccessHelper.getMethod(clazz, methodName, methodArgs, true);
                Object o = statement.unwrap(clazz);
                PrivilegedAccessHelper.invokeMethod(method, o, parameters);
            }
            catch (ReflectiveOperationException e) {
                AbstractSessionLog.getLog().logThrowable(6, null, e);
                super.registerOutputParameter(statement, name, jdbcType);
            }
        }
    }

    @Override
    public void registerOutputParameter(CallableStatement statement, String name, int jdbcType, String typeName) throws SQLException {
        block6: {
            try {
                String methodName = "registerJccOutParameterAtName";
                Class[] methodArgs = new Class[]{String.class, Integer.TYPE, String.class};
                Object[] parameters = new Object[]{name, jdbcType, typeName};
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        ClassLoader cl = AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(DB2_CALLABLESTATEMENT_CLASS, true, cl));
                        Method method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, methodArgs, true));
                        Object o = statement.unwrap(clazz);
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(method, o, parameters));
                        break block6;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                ClassLoader cl = PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
                Class clazz = PrivilegedAccessHelper.getClassForName(DB2_CALLABLESTATEMENT_CLASS, true, cl);
                Method method = PrivilegedAccessHelper.getMethod(clazz, methodName, methodArgs, true);
                Object o = statement.unwrap(clazz);
                PrivilegedAccessHelper.invokeMethod(method, o, parameters);
            }
            catch (ReflectiveOperationException e) {
                AbstractSessionLog.getLog().logThrowable(6, null, e);
                super.registerOutputParameter(statement, name, jdbcType, typeName);
            }
        }
    }

    @Override
    public void setParameterValueInDatabaseCall(Object parameter, CallableStatement statement, String name, AbstractSession session) throws SQLException {
        block73: {
            Timestamp ts;
            String methodName = null;
            Class[] methodArgs = null;
            Object[] parameters = null;
            if (parameter instanceof String) {
                if (this.usesStringBinding() && ((String)parameter).length() > this.getStringBindingSize()) {
                    CharArrayReader reader = new CharArrayReader(((String)parameter).toCharArray());
                    methodName = "setJccCharacterStreamAtName";
                    methodArgs = new Class[]{String.class, Reader.class, Integer.TYPE};
                    parameters = new Object[]{name, reader, ((String)parameter).length()};
                } else {
                    methodName = "setJccStringAtName";
                    methodArgs = new Class[]{String.class, String.class};
                    parameters = new Object[]{name, parameter};
                }
            } else if (parameter instanceof Number) {
                Number number = (Number)parameter;
                if (number instanceof Integer) {
                    methodName = "setJccIntAtName";
                    methodArgs = new Class[]{String.class, Integer.TYPE};
                    parameters = new Object[]{name, number.intValue()};
                } else if (number instanceof Long) {
                    methodName = "setJccLongAtName";
                    methodArgs = new Class[]{String.class, Long.TYPE};
                    parameters = new Object[]{name, number.longValue()};
                } else if (number instanceof BigDecimal) {
                    methodName = "setJccBigDecimalAtName";
                    methodArgs = new Class[]{String.class, BigDecimal.class};
                    parameters = new Object[]{name, number};
                } else if (number instanceof Double) {
                    methodName = "setJccDoubleAtName";
                    methodArgs = new Class[]{String.class, Double.TYPE};
                    parameters = new Object[]{name, number.doubleValue()};
                } else if (number instanceof Float) {
                    methodName = "setJccFloatAtName";
                    methodArgs = new Class[]{String.class, Float.TYPE};
                    parameters = new Object[]{name, Float.valueOf(number.floatValue())};
                } else if (number instanceof Short) {
                    methodName = "setJccShortAtName";
                    methodArgs = new Class[]{String.class, Short.TYPE};
                    parameters = new Object[]{name, number.shortValue()};
                } else if (number instanceof Byte) {
                    methodName = "setJccByteAtName";
                    methodArgs = new Class[]{String.class, Byte.TYPE};
                    parameters = new Object[]{name, number.byteValue()};
                } else if (number instanceof BigInteger) {
                    methodName = "setJccBigDecimalAtName";
                    methodArgs = new Class[]{String.class, BigDecimal.class};
                    parameters = new Object[]{name, new BigDecimal((BigInteger)number)};
                } else {
                    methodName = "setJccObjectAtName";
                    methodArgs = new Class[]{String.class, Object.class};
                    parameters = new Object[]{name, parameter};
                }
            } else if (parameter instanceof Date) {
                methodName = "setJccDateAtName";
                methodArgs = new Class[]{String.class, Date.class};
                parameters = new Object[]{name, parameter};
            } else if (parameter instanceof LocalDate) {
                methodName = "setJccDateAtName";
                methodArgs = new Class[]{String.class, Date.class};
                parameters = new Object[]{name, Date.valueOf((LocalDate)parameter)};
            } else if (parameter instanceof Timestamp) {
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, parameter};
            } else if (parameter instanceof LocalDateTime) {
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, Timestamp.valueOf((LocalDateTime)parameter)};
            } else if (parameter instanceof OffsetDateTime) {
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, Timestamp.from(((OffsetDateTime)parameter).toInstant())};
            } else if (parameter instanceof Time) {
                methodName = "setJccTimeAtName";
                methodArgs = new Class[]{String.class, Time.class};
                parameters = new Object[]{name, parameter};
            } else if (parameter instanceof LocalTime) {
                LocalTime lt = (LocalTime)parameter;
                ts = Timestamp.valueOf(LocalDateTime.of(LocalDate.ofEpochDay(0L), lt));
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, ts};
            } else if (parameter instanceof OffsetTime) {
                OffsetTime ot = (OffsetTime)parameter;
                ts = Timestamp.valueOf(LocalDateTime.of(LocalDate.ofEpochDay(0L), ot.toLocalTime()));
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, ts};
            } else if (parameter instanceof Boolean) {
                methodName = "setJccBooleanAtName";
                methodArgs = new Class[]{String.class, Boolean.TYPE};
                parameters = new Object[]{name, parameter};
            } else if (parameter == null) {
                methodName = "setJccNullAtName";
                methodArgs = new Class[]{String.class, Integer.TYPE};
                parameters = new Object[]{name, this.getJDBCType((Class)null)};
            } else if (parameter instanceof DatabaseField) {
                this.setNullFromDatabaseField((DatabaseField)parameter, statement, name);
            } else if (parameter instanceof byte[]) {
                if (this.usesStreamsForBinding()) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])parameter);
                    methodName = "setJccBinaryStreamAtName";
                    methodArgs = new Class[]{String.class, InputStream.class, Integer.TYPE};
                    parameters = new Object[]{name, inputStream, ((byte[])parameter).length};
                } else {
                    methodName = "setJccBytesAtName";
                    methodArgs = new Class[]{String.class, byte[].class};
                    parameters = new Object[]{name, parameter};
                }
            } else if (parameter instanceof Calendar) {
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, Helper.timestampFromDate(((Calendar)parameter).getTime())};
            } else if (parameter.getClass() == ClassConstants.UTILDATE) {
                methodName = "setJccTimestampAtName";
                methodArgs = new Class[]{String.class, Timestamp.class};
                parameters = new Object[]{name, Helper.timestampFromDate((java.util.Date)parameter)};
            } else if (parameter instanceof Character) {
                methodName = "setJccStringAtName";
                methodArgs = new Class[]{String.class, String.class};
                parameters = new Object[]{name, ((Character)parameter).toString()};
            } else if (parameter instanceof char[]) {
                methodName = "setJccStringAtName";
                methodArgs = new Class[]{String.class, String.class};
                parameters = new Object[]{name, new String((char[])parameter)};
            } else if (parameter instanceof Character[]) {
                methodName = "setJccStringAtName";
                methodArgs = new Class[]{String.class, String.class};
                parameters = new Object[]{name, this.convertObject(parameter, ClassConstants.STRING)};
            } else if (parameter instanceof Byte[]) {
                methodName = "setJccBytesAtName";
                methodArgs = new Class[]{String.class, byte[].class};
                parameters = new Object[]{name, this.convertObject(parameter, ClassConstants.APBYTE)};
            } else if (parameter instanceof SQLXML) {
                methodName = "setJccSQLXMLAtName";
                methodArgs = new Class[]{String.class, SQLXML.class};
                parameters = new Object[]{name, parameter};
            } else if (parameter instanceof BindCallCustomParameter) {
                ((BindCallCustomParameter)parameter).set((DatabasePlatform)this, statement, name, session);
            } else if (this.typeConverters != null && this.typeConverters.containsKey(parameter.getClass())) {
                StructConverter converter = (StructConverter)this.typeConverters.get(parameter.getClass());
                Struct struct = converter.convertToStruct(parameter, this.getConnection(session, statement.getConnection()));
                methodName = "setJccObjectAtName";
                methodArgs = new Class[]{String.class, Object.class};
                parameters = new Object[]{name, struct};
            } else {
                methodName = "setJccObjectAtName";
                methodArgs = new Class[]{String.class, Object.class};
                parameters = new Object[]{name, parameter};
            }
            if (methodName != null) {
                try {
                    Method method;
                    Class clazz;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            ClassLoader cl = AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(DB2_PREPAREDSTATEMENT_CLASS, true, cl));
                            method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, methodArgs, true));
                            Object o = statement.unwrap(clazz);
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, o, parameters));
                            break block73;
                        }
                        catch (PrivilegedActionException ex) {
                            if (ex.getCause() instanceof ClassNotFoundException) {
                                throw (ClassNotFoundException)ex.getCause();
                            }
                            throw (RuntimeException)ex.getCause();
                        }
                    }
                    ClassLoader cl = PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
                    clazz = PrivilegedAccessHelper.getClassForName(DB2_PREPAREDSTATEMENT_CLASS, true, cl);
                    method = PrivilegedAccessHelper.getMethod(clazz, methodName, methodArgs, true);
                    Object o = statement.unwrap(clazz);
                    PrivilegedAccessHelper.invokeMethod(method, o, parameters);
                }
                catch (ReflectiveOperationException e) {
                    AbstractSessionLog.getLog().logThrowable(6, null, e);
                    super.setParameterValueInDatabaseCall(parameter, statement, name, session);
                }
            }
        }
    }

    @Override
    protected void setNullFromDatabaseField(DatabaseField databaseField, CallableStatement statement, String name) throws SQLException {
        block8: {
            Object[] parameters;
            Class[] methodArgs;
            String methodName;
            if (databaseField instanceof ObjectRelationalDatabaseField) {
                ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)databaseField;
                methodName = "setJccNullAtName";
                methodArgs = new Class[]{String.class, Integer.TYPE, String.class};
                parameters = new Object[]{name, field.getSqlType(), field.getSqlTypeName()};
            } else {
                int jdbcType = this.getJDBCTypeForSetNull(databaseField);
                methodName = "setJccNullAtName";
                methodArgs = new Class[]{String.class, Integer.TYPE};
                parameters = new Object[]{name, jdbcType};
            }
            try {
                Class clazz;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        ClassLoader cl = AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(DB2_PREPAREDSTATEMENT_CLASS, true, cl));
                        Method method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, methodArgs, true));
                        Object o = statement.unwrap(clazz);
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(method, o, parameters));
                        break block8;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                ClassLoader cl = PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
                clazz = PrivilegedAccessHelper.getClassForName(DB2_PREPAREDSTATEMENT_CLASS, true, cl);
                Method method = PrivilegedAccessHelper.getMethod(clazz, methodName, methodArgs, true);
                Object o = statement.unwrap(clazz);
                PrivilegedAccessHelper.invokeMethod(method, o, parameters);
            }
            catch (ReflectiveOperationException e) {
                AbstractSessionLog.getLog().logThrowable(6, null, e);
                super.setNullFromDatabaseField(databaseField, statement, name);
            }
        }
    }

    @Override
    public Object getParameterValueFromDatabaseCall(CallableStatement statement, String name, AbstractSession session) throws SQLException {
        String methodName = "getJccObjectAtName";
        Class[] methodArgs = new Class[]{String.class};
        Object[] parameters = new Object[]{name};
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    ClassLoader cl = AccessController.doPrivileged(new PrivilegedGetContextClassLoader(Thread.currentThread()));
                    Class clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(DB2_CALLABLESTATEMENT_CLASS, true, cl));
                    Method method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, methodName, methodArgs, true));
                    Object o = statement.unwrap(clazz);
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, o, parameters));
                }
                catch (PrivilegedActionException ex) {
                    if (ex.getCause() instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)ex.getCause();
                    }
                    throw (RuntimeException)ex.getCause();
                }
            }
            ClassLoader cl = PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread());
            Class clazz = PrivilegedAccessHelper.getClassForName(DB2_CALLABLESTATEMENT_CLASS, true, cl);
            Method method = PrivilegedAccessHelper.getMethod(clazz, methodName, methodArgs, true);
            Object o = statement.unwrap(clazz);
            return PrivilegedAccessHelper.invokeMethod(method, o, parameters);
        }
        catch (ReflectiveOperationException e) {
            AbstractSessionLog.getLog().logThrowable(6, null, e);
            return super.getParameterValueFromDatabaseCall(statement, name, session);
        }
    }
}

