/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.persistence.internal.helper.XMLHelper;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.platform.xml.jaxp.JAXPNamespaceContext;
import org.eclipse.persistence.platform.xml.jaxp.JAXPParser;
import org.eclipse.persistence.platform.xml.jaxp.JAXPTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JAXPPlatform
implements XMLPlatform {
    private XPathFactory xPathFactory;
    private SchemaFactory schemaFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    private boolean disableSecureProcessing = false;

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        if (null == this.documentBuilderFactory) {
            this.documentBuilderFactory = XMLHelper.createDocumentBuilderFactory(this.isSecureProcessingDisabled());
        }
        return this.documentBuilderFactory;
    }

    public XPathFactory getXPathFactory() {
        if (null == this.xPathFactory) {
            this.xPathFactory = XMLHelper.createXPathFactory(this.isSecureProcessingDisabled());
        }
        return this.xPathFactory;
    }

    public SchemaFactory getSchemaFactory() {
        if (null == this.schemaFactory) {
            this.schemaFactory = XMLHelper.createSchemaFactory("http://www.w3.org/2001/XMLSchema", this.isSecureProcessingDisabled());
        }
        return this.schemaFactory;
    }

    @Override
    public NodeList selectNodesAdvanced(Node contextNode, String xPathString, XMLNamespaceResolver xmlNamespaceResolver) throws XMLPlatformException {
        try {
            XPath xPath = this.getXPathFactory().newXPath();
            if (null != xmlNamespaceResolver) {
                JAXPNamespaceContext namespaceContext = new JAXPNamespaceContext(xmlNamespaceResolver);
                xPath.setNamespaceContext(namespaceContext);
            }
            XPathExpression xPathExpression = xPath.compile(xPathString);
            return (NodeList)xPathExpression.evaluate(contextNode, XPathConstants.NODESET);
        }
        catch (XPathException e) {
            throw XMLPlatformException.xmlPlatformInvalidXPath(e);
        }
    }

    @Override
    public Node selectSingleNodeAdvanced(Node contextNode, String xPathString, XMLNamespaceResolver xmlNamespaceResolver) throws XMLPlatformException {
        try {
            XPath xPath = this.getXPathFactory().newXPath();
            if (null != xmlNamespaceResolver) {
                JAXPNamespaceContext namespaceContext = new JAXPNamespaceContext(xmlNamespaceResolver);
                xPath.setNamespaceContext(namespaceContext);
            }
            XPathExpression xPathExpression = xPath.compile(xPathString);
            return (Node)xPathExpression.evaluate(contextNode, XPathConstants.NODE);
        }
        catch (XPathException e) {
            throw XMLPlatformException.xmlPlatformInvalidXPath(e);
        }
    }

    @Override
    public boolean isWhitespaceNode(Text text) {
        String value = text.getNodeValue();
        if (null == value) {
            return false;
        }
        return value.trim().equals("");
    }

    @Override
    public XMLParser newXMLParser() {
        return new JAXPParser();
    }

    @Override
    public XMLParser newXMLParser(Map<String, Boolean> parserFeatures) {
        return new JAXPParser(parserFeatures);
    }

    @Override
    public XMLTransformer newXMLTransformer() {
        return new JAXPTransformer();
    }

    @Override
    public Document createDocument() throws XMLPlatformException {
        try {
            DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(e);
        }
    }

    @Override
    public Document createDocumentWithPublicIdentifier(String name, String publicIdentifier, String systemIdentifier) throws XMLPlatformException {
        try {
            if (null == publicIdentifier) {
                return this.createDocumentWithSystemIdentifier(name, systemIdentifier);
            }
            DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
            DOMImplementation domImpl = documentBuilder.getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType(name, publicIdentifier, systemIdentifier);
            Document document = domImpl.createDocument(null, name, docType);
            return document;
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(e);
        }
    }

    @Override
    public Document createDocumentWithSystemIdentifier(String name, String systemIdentifier) throws XMLPlatformException {
        try {
            Document document = null;
            if (null == systemIdentifier) {
                document = this.createDocument();
                Element rootElement = document.createElement(name);
                document.appendChild(rootElement);
                return document;
            }
            DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
            DOMImplementation domImpl = documentBuilder.getDOMImplementation();
            DocumentType docType = domImpl.createDocumentType(name, null, systemIdentifier);
            document = domImpl.createDocument(null, name, docType);
            return document;
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(e);
        }
    }

    @Override
    public String resolveNamespacePrefix(Node contextNode, String namespacePrefix) throws XMLPlatformException {
        Node parentNode;
        if (null == namespacePrefix ? null == contextNode.getPrefix() : namespacePrefix.equals(contextNode.getPrefix())) {
            return contextNode.getNamespaceURI();
        }
        if (contextNode.getNodeType() == 1) {
            Element contextElement = (Element)contextNode;
            Attr namespaceDeclaration = null;
            namespaceDeclaration = namespacePrefix != null ? contextElement.getAttributeNode("xmlns:" + namespacePrefix) : contextElement.getAttributeNode("xmlns");
            if (null != namespaceDeclaration) {
                return namespaceDeclaration.getValue();
            }
        }
        if ((parentNode = contextNode.getParentNode()) != null && parentNode.getNodeType() == 1) {
            return this.resolveNamespacePrefix(parentNode, namespacePrefix);
        }
        return null;
    }

    @Override
    public boolean validateDocument(Document document, URL xmlSchemaURL, ErrorHandler errorHandler) throws XMLPlatformException {
        Schema xmlSchema;
        try {
            xmlSchema = this.getSchemaFactory().newSchema(xmlSchemaURL);
        }
        catch (SAXException e) {
            throw XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(xmlSchemaURL, e);
        }
        try {
            Validator validator = xmlSchema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(new DOMSource(document));
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformValidationException(e);
        }
        return true;
    }

    @Override
    public boolean validate(Element elem, XMLDescriptor xmlDescriptor, ErrorHandler handler) throws XMLPlatformException {
        return true;
    }

    @Override
    public void namespaceQualifyFragment(Element next) {
        this.namespaceQualifyFragment(next, new ArrayList<String>());
    }

    private void namespaceQualifyFragment(Element next, List<String> declaredPrefixes) {
        Attr namespaceDeclaration;
        String elementUri = next.getNamespaceURI();
        String elementPrefix = next.getPrefix();
        if (elementPrefix != null && null == (namespaceDeclaration = next.getAttributeNode("xmlns:" + elementPrefix)) && !declaredPrefixes.contains(elementPrefix)) {
            next.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + elementPrefix, elementUri);
            declaredPrefixes.add(elementPrefix);
        }
        NamedNodeMap attributes = next.getAttributes();
        int attributesSize = attributes.getLength();
        for (int i = 0; i < attributesSize; ++i) {
            String value;
            int colonIndex;
            Attr nextAttribute = (Attr)attributes.item(i);
            String attributePrefix = nextAttribute.getPrefix();
            if (attributePrefix == null) continue;
            if ("http://www.w3.org/2000/xmlns/".equals(nextAttribute.getNamespaceURI())) {
                declaredPrefixes.add(nextAttribute.getLocalName());
                continue;
            }
            Attr namespaceDeclaration2 = next.getAttributeNode("xmlns:" + attributePrefix);
            if (null == namespaceDeclaration2 && !declaredPrefixes.contains(attributePrefix)) {
                String attributeUri = nextAttribute.getNamespaceURI();
                next.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attributePrefix, attributeUri);
                declaredPrefixes.add(attributePrefix);
            }
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(nextAttribute.getNamespaceURI()) || !"type".equals(nextAttribute.getLocalName()) || (colonIndex = (value = nextAttribute.getValue()).indexOf(58)) <= -1) continue;
            String prefix = value.substring(0, colonIndex);
            namespaceDeclaration2 = next.getAttributeNode("xmlns:" + prefix);
            if (null != namespaceDeclaration2 || declaredPrefixes.contains(prefix)) continue;
            String uri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(next, prefix);
            next.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
            declaredPrefixes.add(prefix);
        }
        NodeList children = next.getChildNodes();
        int numberOfNodes = children.getLength();
        for (int i = 0; i < numberOfNodes; ++i) {
            Node nextNode = children.item(i);
            if (nextNode.getNodeType() != 1) continue;
            Element child = (Element)nextNode;
            this.namespaceQualifyFragment(child, declaredPrefixes);
        }
    }

    @Override
    public void setDisableSecureProcessing(boolean disableSecureProcessing) {
        boolean shouldReset = this.disableSecureProcessing ^ disableSecureProcessing;
        this.disableSecureProcessing = disableSecureProcessing;
        if (shouldReset) {
            this.documentBuilderFactory = null;
            this.schemaFactory = null;
            this.xPathFactory = null;
        }
    }

    @Override
    public boolean isSecureProcessingDisabled() {
        return this.disableSecureProcessing;
    }
}

