/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import jakarta.transaction.Synchronization;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.transaction.AbstractTransactionController;

public abstract class AbstractSynchronizationListener
implements Synchronization {
    protected AbstractTransactionController controller;
    protected AbstractSession session;
    protected UnitOfWorkImpl unitOfWork;
    protected Object transaction;
    protected Object transactionKey;
    protected SequencingCallback sequencingCallback;
    protected Map<DatabaseSession, SequencingCallback> sequencingCallbackMap;

    public AbstractSynchronizationListener() {
    }

    protected AbstractSynchronizationListener(UnitOfWorkImpl unitOfWork, AbstractSession session, Object transaction, AbstractTransactionController controller) {
        this.session = session;
        this.unitOfWork = unitOfWork;
        this.transaction = transaction;
        this.controller = controller;
        this.transactionKey = controller.getTransactionKey(transaction);
    }

    public void beforeCompletion() {
        UnitOfWorkImpl uow = this.getUnitOfWork();
        if (this.unitOfWork == null) {
            return;
        }
        try {
            Object status = this.getTransactionController().getTransactionStatus();
            this.getTransactionController().logTxStateTrace(uow, "TX_beforeCompletion", status);
            this.session.startOperationProfile("Timer:TXBeforeCompletion");
            this.getSession().setWasJTSTransactionInternallyStarted(false);
            if (!uow.isActive()) {
                throw TransactionException.inactiveUnitOfWork(uow);
            }
            if (!this.getTransactionController().canIssueSQLToDatabase_impl(status)) {
                if (this.getSession().isInTransaction()) {
                    this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
                    if (this.getUnitOfWork().wasTransactionBegunPrematurely()) {
                        this.getUnitOfWork().setWasTransactionBegunPrematurely(false);
                    }
                    this.getSession().rollbackTransaction();
                }
                this.getSession().releaseJTSConnection();
                return;
            }
            if (this.getSession().isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            if (this.getTransactionController().isSequencingCallbackRequired()) {
                this.getTransactionController().currentlyProcessedListeners.put(this.getTransactionKey(), this);
            }
            uow.issueSQLbeforeCompletion();
            uow.setPendingMerge();
        }
        catch (RuntimeException exception) {
            if (!(exception instanceof EclipseLinkException) || !((EclipseLinkException)exception).hasBeenLogged()) {
                uow.logThrowable(6, "transaction", exception);
            }
            this.handleException(exception);
        }
        finally {
            if (this.getTransactionController().isSequencingCallbackRequired()) {
                this.getTransactionController().currentlyProcessedListeners.remove(this.getTransactionKey());
            }
            this.getSession().releaseJTSConnection();
            this.session.endOperationProfile("Timer:TXBeforeCompletion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(Object status) {
        UnitOfWorkImpl uow = this.getUnitOfWork();
        if (uow == null) {
            if (this.getTransactionController().isSequencingCallbackRequired() && this.getTransactionController().canMergeUnitOfWork_impl(status)) {
                this.callSequencingCallback();
            }
        } else {
            try {
                this.getTransactionController().logTxStateTrace(uow, "TX_afterCompletion", status);
                this.session.startOperationProfile("Timer:TXAfterCompletion");
                if (!uow.isActive()) {
                    throw TransactionException.inactiveUnitOfWork(uow);
                }
                if (this.getTransactionController().canMergeUnitOfWork_impl(status)) {
                    if (this.getTransactionController().isSequencingCallbackRequired()) {
                        this.callSequencingCallback();
                    }
                    if (uow.isMergePending()) {
                        uow.mergeClonesAfterCompletion();
                    }
                } else {
                    this.getSession().releaseJTSConnection();
                    uow.afterExternalTransactionRollback();
                }
                if (uow.shouldResumeUnitOfWorkOnTransactionCompletion() && this.getTransactionController().canMergeUnitOfWork_impl(status)) {
                    uow.synchronizeAndResume();
                    uow.setSynchronized(false);
                } else {
                    uow.release();
                    if (this.getSession().isClientSession() || this.getSession().isSessionBroker() && ((SessionBroker)this.getSession()).isClientSessionBroker()) {
                        this.getSession().release();
                    }
                }
            }
            catch (RuntimeException exception) {
                if (!(exception instanceof EclipseLinkException) || !((EclipseLinkException)exception).hasBeenLogged()) {
                    uow.logThrowable(6, "transaction", exception);
                }
                this.handleException(exception);
            }
            finally {
                this.getTransactionController().removeUnitOfWork(this.getTransactionKey());
                this.session.endOperationProfile("Timer:TXAfterCompletion");
                this.setUnitOfWork(null);
                this.setSession(null);
            }
        }
        if (this.getTransactionController().isSequencingCallbackRequired()) {
            this.getTransactionController().removeSequencingListener(this.getTransactionKey());
            this.sequencingCallback = null;
            this.sequencingCallbackMap = null;
        }
        this.setTransaction(null);
        this.setTransactionKey(null);
    }

    public void handleException(RuntimeException exception) {
        if (this.controller.getExceptionHandler() != null) {
            this.controller.getExceptionHandler().handleException(exception);
            return;
        }
        throw exception;
    }

    protected AbstractTransactionController getTransactionController() {
        return this.controller;
    }

    protected void setTransactionController(AbstractTransactionController newController) {
        this.controller = newController;
    }

    protected Object getTransaction() {
        return this.transaction;
    }

    protected void setTransaction(Object transaction) {
        this.transaction = transaction;
    }

    protected Object getTransactionKey() {
        return this.transactionKey;
    }

    protected void setTransactionKey(Object transactionKey) {
        this.transactionKey = transactionKey;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    protected UnitOfWorkImpl getUnitOfWork() {
        return this.unitOfWork;
    }

    protected void setUnitOfWork(UnitOfWorkImpl unitOfWork) {
        this.unitOfWork = unitOfWork;
    }

    protected void callSequencingCallback() {
        if (this.sequencingCallback != null) {
            this.sequencingCallback.afterCommit(null);
        } else if (this.sequencingCallbackMap != null) {
            Iterator<SequencingCallback> itCallback = this.sequencingCallbackMap.values().iterator();
            while (itCallback.hasNext()) {
                itCallback.next().afterCommit(null);
            }
        }
    }

    public SequencingCallback getSequencingCallback(DatabaseSession dbSession, SequencingCallbackFactory sequencingCallbackFactory) {
        if (this.getTransactionController().numSessionsRequiringSequencingCallback() == 1) {
            if (this.sequencingCallback == null) {
                this.sequencingCallback = sequencingCallbackFactory.createSequencingCallback();
            }
            return this.sequencingCallback;
        }
        if (this.getTransactionController().numSessionsRequiringSequencingCallback() > 1) {
            SequencingCallback callback = null;
            if (this.sequencingCallbackMap == null) {
                this.sequencingCallbackMap = new HashMap<DatabaseSession, SequencingCallback>(this.getTransactionController().numSessionsRequiringSequencingCallback());
            } else {
                callback = this.sequencingCallbackMap.get(dbSession);
            }
            if (callback == null) {
                callback = sequencingCallbackFactory.createSequencingCallback();
                this.sequencingCallbackMap.put(dbSession, callback);
            }
            return callback;
        }
        return null;
    }
}

