/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers.kryo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.AbstractSerializer;

public class KryoSerializer
extends AbstractSerializer {
    transient ThreadLocal kryo;
    transient Constructor kryoConstructor;
    transient Constructor outputConstructor;
    transient Constructor inputConstructor;
    transient Method writeMethod;
    transient Method readMethod;
    transient Method inputCloseMethod;
    transient Method outputCloseMethod;

    public KryoSerializer() {
        try {
            Class<?> kryoClass = Class.forName("com.esotericsoftware.kryo.Kryo");
            this.kryoConstructor = kryoClass.getConstructor(new Class[0]);
            Class<?> inputClass = Class.forName("com.esotericsoftware.kryo.io.Input");
            this.inputConstructor = inputClass.getConstructor(InputStream.class);
            Class<?> outputClass = Class.forName("com.esotericsoftware.kryo.io.Output");
            this.outputConstructor = outputClass.getConstructor(OutputStream.class);
            this.writeMethod = kryoClass.getMethod("writeClassAndObject", outputClass, Object.class);
            this.readMethod = kryoClass.getMethod("readClassAndObject", inputClass);
            this.inputCloseMethod = inputClass.getMethod("close", new Class[0]);
            this.outputCloseMethod = outputClass.getMethod("close", new Class[0]);
            this.kryo = new ThreadLocal();
        }
        catch (Exception exception) {
            throw ValidationException.reflectiveExceptionWhileCreatingClassInstance((String)"com.esotericsoftware.kryo.Kryo", (Exception)exception);
        }
    }

    public Class getType() {
        return byte[].class;
    }

    public Object getKryo() {
        Object value = this.kryo.get();
        if (value == null) {
            try {
                value = this.kryoConstructor.newInstance(new Object[0]);
                this.kryo.set(value);
            }
            catch (Exception exception) {
                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance((String)"com.esotericsoftware.kryo.Kryo", (Exception)exception);
            }
        }
        return value;
    }

    public Object serialize(Object object, Session session) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Object output = this.outputConstructor.newInstance(stream);
            this.writeMethod.invoke(this.getKryo(), output, object);
            this.outputCloseMethod.invoke(output, new Object[0]);
            return stream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object deserialize(Object bytes, Session session) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])bytes);
            Object input = this.inputConstructor.newInstance(stream);
            Object result = this.readMethod.invoke(this.getKryo(), input);
            this.inputCloseMethod.invoke(input, new Object[0]);
            return result;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

