/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.BaseDBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSBuilderHelper;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;

public class JDBCHelper
extends BaseDBWSBuilderHelper
implements DBWSBuilderHelper {
    public static final int TABLESINFO_CATALOG = 1;
    public static final int TABLESINFO_SCHEMA = 2;
    public static final int TABLESINFO_NAME = 3;
    public static final int TABLESINFO_TYPE = 4;
    public static final int COLUMNSINFO_COLUMN_NAME = 4;
    public static final int COLUMNSINFO_DATA_TYPE = 5;
    public static final int COLUMNSINFO_TYPE_NAME = 6;
    public static final int COLUMNSINFO_COLUMN_SIZE = 7;
    public static final int COLUMNSINFO_DECIMAL_DIGITS = 9;
    public static final int COLUMNSINFO_NULLABLE = 11;
    public static final int COLUMNSINFO_ORDINAL_POSITION = 17;
    public static final int PKSINFO_KEY_SEQ = 5;
    public static final int PKSINFO_PK_NAME = 6;
    public static final int INDEXINFO_NON_UNIQUE = 4;
    public static final int INDEXINFO_TYPE = 7;
    public static final int INDEXINFO_ORDINAL_POSITION = 8;
    public static final int PROCS_INFO_CATALOG = 1;
    public static final int PROCS_INFO_SCHEMA = 2;
    public static final int PROCS_INFO_NAME = 3;
    public static final int PROCS_INFO_TYPE = 8;
    public static final int PROC_COLS_INFO_CATALOG = 1;
    public static final int PROC_COLS_INFO_SCHEMA = 2;
    public static final int PROC_COLS_INFO_NAME = 3;
    public static final int PROC_COLS_INFO_COLNAME = 4;
    public static final int PROC_COLS_INFO_TYPE = 5;
    public static final int PROC_COLS_INFO_DATA_TYPE = 6;
    public static final int PROC_COLS_INFO_TYPE_NAME = 7;
    public static final int PROC_COLS_INFO_PRECISION = 8;
    public static final int PROC_COLS_INFO_LENGTH = 9;
    public static final int PROC_COLS_INFO_SCALE = 10;
    public static final int PROC_COLS_INFO_RADIX = 11;
    public static final int PROC_COLS_INFO_NULLABLE = 12;
    public static final int PROC_COLS_INFO_ORA_SEQUENCE = 14;
    public static final int PROC_COLS_INFO_ORA_OVERLOAD = 15;

    public JDBCHelper(DBWSBuilder dbwsBuilder) {
        super(dbwsBuilder);
    }

    @Override
    public boolean hasTables() {
        return this.dbTables.size() != 0;
    }

    @Override
    public void buildProcedureOperation(ProcedureOperationModel procedureOperationModel) {
        String name = procedureOperationModel.getName();
        boolean isMySQL = this.dbwsBuilder.getDatabasePlatform().getClass().getName().contains("MySQL");
        for (ProcedureType storedProcedure : procedureOperationModel.getDbStoredProcedures()) {
            StringBuilder sb = new StringBuilder();
            if (name == null || name.length() == 0) {
                if (storedProcedure.getOverload() > 0) {
                    sb.append(storedProcedure.getOverload());
                    sb.append('_');
                }
                if (storedProcedure.getCatalogName() != null && storedProcedure.getCatalogName().length() > 0) {
                    sb.append(storedProcedure.getCatalogName());
                    sb.append('_');
                }
                if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                    sb.append(storedProcedure.getSchema());
                    sb.append('_');
                }
                sb.append(storedProcedure.getProcedureName());
            } else {
                sb.append(name);
            }
            QueryOperation qo = new QueryOperation();
            qo.setName(sb.toString());
            Object qh = storedProcedure.isFunctionType() ? new StoredFunctionQueryHandler() : new StoredProcedureQueryHandler();
            sb = new StringBuilder();
            if (!isMySQL && storedProcedure.getCatalogName() != null && storedProcedure.getCatalogName().length() > 0) {
                sb.append(storedProcedure.getCatalogName());
                sb.append('.');
            }
            if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                sb.append(storedProcedure.getSchema());
                sb.append('.');
            }
            sb.append(storedProcedure.getProcedureName());
            ((StoredProcedureQueryHandler)qh).setName(sb.toString());
            this.dbwsBuilder.logMessage(Level.FINEST, "Building QueryOperation for " + sb.toString());
            List queries = this.dbwsBuilder.getOrProject().getQueries();
            if (queries.size() > 0) {
                for (DatabaseQuery q : queries) {
                    if (!q.getName().equals(qo.getName())) continue;
                    qh = new NamedQueryHandler();
                    ((NamedQueryHandler)qh).setName(qo.getName());
                }
            }
            qo.setQueryHandler((QueryHandler)qh);
            String returnType = procedureOperationModel.getReturnType();
            boolean isCollection = procedureOperationModel.isCollection();
            boolean isSimpleXMLFormat = procedureOperationModel.isSimpleXMLFormat();
            Object result = null;
            if (storedProcedure.isFunctionType()) {
                FunctionType storedFunction = (FunctionType)storedProcedure;
                ArgumentType rarg = storedFunction.getReturnArgument();
                if (rarg.getTypeName().contains("CURSOR")) {
                    result = new CollectionResult();
                    result.setType(Util.SXF_QNAME_CURSOR);
                } else {
                    result = new Result();
                    int rargJdbcType = Util.getJDBCTypeFromTypeName(rarg.getTypeName());
                    switch (rargJdbcType) {
                        case 1111: 
                        case 2002: 
                        case 2003: {
                            if (returnType != null) {
                                result.setType(Util.buildCustomQName(returnType, this.dbwsBuilder));
                                break;
                            }
                            result.setType(XMLConstants.ANY_QNAME);
                            break;
                        }
                        default: {
                            result.setType(Util.getXMLTypeFromJDBCType(rargJdbcType));
                        }
                    }
                }
            } else if (returnType != null) {
                result = new Result();
                result.setType(Util.buildCustomQName(returnType, this.dbwsBuilder));
            } else if (isCollection) {
                result = new CollectionResult();
                if (isSimpleXMLFormat) {
                    result.setType(Util.SXF_QNAME_CURSOR);
                }
            } else {
                result = new Result();
                result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            if (procedureOperationModel.getBinaryAttachment()) {
                Attachment attachment = new Attachment();
                attachment.setMimeType("application/octet-stream");
                result.setAttachment(attachment);
            }
            for (ArgumentType arg : storedProcedure.getArguments()) {
                String argName = arg.getArgumentName();
                if (argName == null) continue;
                ProcedureOutputArgument pa = null;
                Parameter parm = null;
                ArgumentTypeDirection direction = arg.getDirection();
                QName xmlType = null;
                switch (Util.getJDBCTypeFromTypeName(arg.getTypeName())) {
                    case 1111: 
                    case 2002: 
                    case 2003: {
                        String typeString = this.nct.generateSchemaAlias(arg.getTypeName());
                        xmlType = Util.buildCustomQName(typeString, this.dbwsBuilder);
                        break;
                    }
                    default: {
                        xmlType = Util.getXMLTypeFromJDBCType(Util.getJDBCTypeFromTypeName(arg.getTypeName()));
                    }
                }
                if (direction == ArgumentTypeDirection.IN) {
                    parm = new Parameter();
                    parm.setName(argName);
                    parm.setType(xmlType);
                    pa = new ProcedureArgument();
                    pa.setName(argName);
                    pa.setParameterName(argName);
                    if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getInArguments().add(pa);
                    }
                } else {
                    ProcedureOutputArgument pao = pa = new ProcedureOutputArgument();
                    pao.setName(argName);
                    pao.setParameterName(argName);
                    if (arg.getTypeName().contains("CURSOR") && returnType == null) {
                        pao.setResultType(Util.SXF_QNAME_CURSOR);
                        if (result == null) {
                            result = new CollectionResult();
                            result.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (returnType != null && !isSimpleXMLFormat) {
                            xmlType = Util.qNameFromString("{" + this.dbwsBuilder.getTargetNamespace() + "}" + returnType, this.dbwsBuilder.getSchema());
                        }
                        pao.setResultType(xmlType);
                        if (result == null) {
                            result = isCollection ? new CollectionResult() : new Result();
                            result.setType(xmlType);
                        }
                    }
                    if (direction == ArgumentTypeDirection.INOUT) {
                        parm = new Parameter();
                        parm.setName(argName);
                        parm.setType(xmlType);
                        result.setType(xmlType);
                        isSimpleXMLFormat = false;
                        if (qh instanceof StoredProcedureQueryHandler) {
                            ((StoredProcedureQueryHandler)qh).getInOutArguments().add(pao);
                        }
                    } else if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getOutArguments().add(pao);
                    }
                }
                if (parm == null) continue;
                qo.getParameters().add(parm);
            }
            this.handleSimpleXMLFormat(isSimpleXMLFormat, (Result)result, procedureOperationModel);
            qo.setResult(result);
            this.dbwsBuilder.getXrServiceModel().getOperations().put(qo.getName(), qo);
        }
        this.finishProcedureOperation();
    }

    @Override
    protected List<TableType> loadTables(List<String> catalogPatterns, List<String> schemaPatterns, List<String> tableNamePatterns) {
        ArrayList<TableType> tables = new ArrayList<TableType>();
        int len = catalogPatterns.size();
        for (int i = 0; i < len; ++i) {
            String catalogPattern = catalogPatterns.get(i);
            String schemaPattern = schemaPatterns.get(i);
            String tablePattern = tableNamePatterns.get(i);
            tables.addAll(this.loadTables(catalogPattern, schemaPattern, tablePattern));
        }
        return tables;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<TableType> loadTables(String originalCatalogPattern, String originalSchemaPattern, String originalTablePattern) {
        dbTables = null;
        schemaPattern = Util.escapePunctuation(originalSchemaPattern);
        tablePattern = Util.escapePunctuation(originalTablePattern);
        databaseMetaData = JDBCHelper.getDatabaseMetaData(this.dbwsBuilder.getConnection());
        supportsCatalogsInTableDefinitions = true;
        try {
            supportsCatalogsInTableDefinitions = databaseMetaData.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sqlException) {
            // empty catch block
        }
        catalogPattern = Util.escapePunctuation(supportsCatalogsInTableDefinitions != false ? originalCatalogPattern : "");
        tablesInfo = null;
        try {
            tablesInfo = databaseMetaData.getTables(catalogPattern, schemaPattern, tablePattern, null);
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving JDBC table metadata", sqlException);
        }
        if (tablesInfo == null) return dbTables;
        dbTables = new ArrayList<DbTable>();
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                if (!tablesInfo.next()) {
                    tablesInfo.close();
                    return dbTables;
                }
                actualTableCatalog = null;
                try {
                    actualTableCatalog = tablesInfo.getString(1);
                }
                catch (SQLException sqlException) {
                    // empty catch block
                }
                actualTableSchema = null;
                try {
                    actualTableSchema = tablesInfo.getString(2);
                }
                catch (SQLException sqlException) {
                    // empty catch block
                }
                actualTableName = tablesInfo.getString(3);
                tableType = null;
                try {
                    tableType = tablesInfo.getString(4);
                }
                catch (SQLException sqlException) {
                    // empty catch block
                }
                dbTable = new DbTable();
                dbTable.setCatalog(actualTableCatalog);
                dbTable.setSchema(actualTableSchema);
                dbTable.setTableName(actualTableName);
                if (tableType != null) {
                    dbTable.setType(tableType);
                }
                dbTables.add(dbTable);
                columnInfo = databaseMetaData.getColumns(actualTableCatalog, actualTableSchema, actualTableName, "%");
                while (columnInfo.next()) {
                    columnName = columnInfo.getString(4);
                    dbColumn = new DbColumn(columnName);
                    dbPrecision = -1;
                    try {
                        dbPrecision = columnInfo.getInt(7);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    dbScale = columnInfo.getInt(9);
                    if (columnInfo.getInt(11) == 1) {
                        dbColumn.unSetNotNull();
                    } else {
                        dbColumn.setNotNull();
                    }
                    dbColumn.setJDBCType(columnInfo.getInt(5));
                    dbColumn.setJDBCTypeName(columnInfo.getString(6));
                    dbColumn.setEnclosedType(Util.buildTypeForJDBCType(dbColumn.getJDBCType(), dbPrecision, dbScale));
                    dbTable.getColumns().add(dbColumn);
                }
                columnInfo.close();
                pksInfo = databaseMetaData.getPrimaryKeys(actualTableCatalog, actualTableSchema, actualTableName);
                if (pksInfo != null) {
                    while (pksInfo.next()) {
                        keySeq = pksInfo.getShort(5);
                        pkConstraintName = pksInfo.getString(6);
                        dbColumn = (DbColumn)dbTable.getColumns().get(keySeq - 1);
                        dbColumn.setPk();
                        dbColumn.setPkConstraintName(pkConstraintName);
                    }
                }
                pksInfo.close();
                try {
                    indexInfo = databaseMetaData.getIndexInfo(actualTableCatalog, actualTableSchema, actualTableName, true, false);
                    if (indexInfo != null) {
                        while (indexInfo.next()) {
                            nonUnique = indexInfo.getBoolean(4);
                            if (nonUnique || (type = indexInfo.getShort(7)) == 0) continue;
                            pos = indexInfo.getShort(8);
                            dbColumn = (DbColumn)dbTable.getColumns().get(pos - 1);
                            if (dbColumn.pk()) continue;
                            dbColumn.setUnique(true);
                        }
                    }
                    indexInfo.close();
                }
                catch (SQLException sqlException) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving JDBC table metadata", sqlException);
        }
        ** GOTO lbl-1000
    }

    @Override
    protected List<ProcedureType> loadProcedures(List<String> catalogPatterns, List<String> schemaPatterns, List<String> procedureNamePatterns) {
        ArrayList<ProcedureType> procedures = new ArrayList<ProcedureType>();
        int len = catalogPatterns.size();
        for (int i = 0; i < len; ++i) {
            String tablePattern;
            String schemaPattern;
            String catalogPattern = catalogPatterns.get(i);
            List<ProcedureType> procs = this.loadProcedures(catalogPattern, schemaPattern = schemaPatterns.get(i), tablePattern = procedureNamePatterns.get(i));
            if (procs == null) continue;
            procedures.addAll(this.loadProcedures(catalogPattern, schemaPattern, tablePattern));
        }
        return procedures;
    }

    protected List<ProcedureType> loadProcedures(String originalCatalogPattern, String originalSchemaPattern, String originalProcedurePattern) {
        ArrayList<Object> dbStoredProcedures = null;
        boolean catalogMatchDontCare = false;
        DatabasePlatform platform = this.dbwsBuilder.getDatabasePlatform();
        if (platform instanceof MySQLPlatform || platform instanceof DerbyPlatform || platform instanceof PostgreSQLPlatform) {
            catalogMatchDontCare = true;
        }
        String catalogPattern = Util.escapePunctuation(originalCatalogPattern);
        String schemaPattern = Util.escapePunctuation(originalSchemaPattern);
        String procedurePattern = Util.escapePunctuation(originalProcedurePattern);
        ResultSet procsInfo = null;
        try {
            DatabaseMetaData databaseMetaData = JDBCHelper.getDatabaseMetaData(this.dbwsBuilder.getConnection());
            procsInfo = databaseMetaData.getProcedures(catalogPattern, schemaPattern, procedurePattern);
            if (procsInfo != null) {
                ArrayList<FunctionType> tmpProcs = new ArrayList<FunctionType>();
                while (procsInfo.next()) {
                    String actualCatalogName = procsInfo.getString(1);
                    String actualSchemaName = procsInfo.getString(2);
                    String actualProcedureName = procsInfo.getString(3);
                    short procedureType = procsInfo.getShort(8);
                    Object dbStoredProcedure = procedureType == 2 ? new FunctionType(actualProcedureName) : new ProcedureType(actualProcedureName);
                    if (actualCatalogName != null && actualCatalogName.length() > 0) {
                        dbStoredProcedure.setCatalogName(actualCatalogName);
                    }
                    if (actualSchemaName != null && actualSchemaName.length() > 0) {
                        dbStoredProcedure.setSchema(actualSchemaName);
                    }
                    tmpProcs.add((FunctionType)dbStoredProcedure);
                }
                procsInfo.close();
                int numProcs = tmpProcs.size();
                if (numProcs > 0) {
                    dbStoredProcedures = new ArrayList<Object>(numProcs);
                    ResultSet procedureColumnsInfo = null;
                    procedureColumnsInfo = databaseMetaData.getProcedureColumns(catalogPattern, schemaPattern, procedurePattern, "%");
                    while (procedureColumnsInfo.next()) {
                        String actualCatalogName = procedureColumnsInfo.getString(1);
                        String actualSchemaName = procedureColumnsInfo.getString(2);
                        String actualProcedureName = procedureColumnsInfo.getString(3);
                        String argName = procedureColumnsInfo.getString(4);
                        if (argName == null) {
                            argName = "";
                        }
                        ArgumentType dbStoredArgument = new ArgumentType(argName);
                        short inOut = procedureColumnsInfo.getShort(5);
                        if (inOut == 2) {
                            dbStoredArgument.setDirection(ArgumentTypeDirection.INOUT);
                        } else if (inOut == 4) {
                            dbStoredArgument.setDirection(ArgumentTypeDirection.OUT);
                        } else if (inOut == 5) {
                            dbStoredArgument.setDirection(ArgumentTypeDirection.RETURN);
                        } else {
                            dbStoredArgument.setDirection(ArgumentTypeDirection.IN);
                        }
                        int jdbcType = procedureColumnsInfo.getInt(6);
                        int precision = procedureColumnsInfo.getInt(8);
                        int scale = procedureColumnsInfo.getInt(10);
                        dbStoredArgument.setEnclosedType(Util.buildTypeForJDBCType(jdbcType, precision, scale));
                        ProcedureType matchingProc = null;
                        for (int i = 0; i < tmpProcs.size(); ++i) {
                            ProcedureType procedureType = (ProcedureType)tmpProcs.get(i);
                            if (!JDBCHelper.matches(procedureType, actualCatalogName, actualSchemaName, actualProcedureName, false, catalogMatchDontCare)) continue;
                            matchingProc = procedureType;
                            dbStoredProcedures.add(matchingProc);
                            break;
                        }
                        if (matchingProc == null) {
                            for (ProcedureType procedureType : dbStoredProcedures) {
                                if (!JDBCHelper.matches(procedureType, actualCatalogName, actualSchemaName, actualProcedureName, false, catalogMatchDontCare)) continue;
                                matchingProc = procedureType;
                                break;
                            }
                        }
                        if (matchingProc == null) continue;
                        if (matchingProc.isFunctionType() && dbStoredArgument.getArgumentName().equalsIgnoreCase("")) {
                            ((FunctionType)matchingProc).setReturnArgument(dbStoredArgument);
                        } else {
                            matchingProc.getArguments().add(dbStoredArgument);
                        }
                        tmpProcs.remove(matchingProc);
                    }
                    procedureColumnsInfo.close();
                    if (!tmpProcs.isEmpty()) {
                        dbStoredProcedures.addAll(tmpProcs);
                    }
                }
            }
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving Stored Procedure metadata", sqlException);
        }
        if (dbStoredProcedures != null && !dbStoredProcedures.isEmpty()) {
            Collections.sort(dbStoredProcedures, new Comparator<ProcedureType>(){

                @Override
                public int compare(ProcedureType o1, ProcedureType o2) {
                    String name2;
                    String name1 = o1.getProcedureName();
                    if (!name1.equals(name2 = o2.getProcedureName())) {
                        return name1.compareTo(name2);
                    }
                    return o1.getOverload() - o2.getOverload();
                }
            });
        }
        return dbStoredProcedures;
    }

    static DatabaseMetaData getDatabaseMetaData(Connection connection) {
        if (connection == null) {
            throw new IllegalStateException("Connection is null - cannot retrieve JDBC metadata");
        }
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sqlException) {
            throw new IllegalStateException("failure retrieving JDBC metadata", sqlException);
        }
        return databaseMetaData;
    }

    public static boolean matches(ProcedureType proc, String catalog, String schema, String name, boolean isOracle, boolean catalogMatchDontCare) {
        boolean schemaMatch;
        boolean catalogMatch;
        boolean bl = proc.getCatalogName() == null ? (isOracle ? true : catalog == null) : (catalogMatch = proc.getCatalogName().equals(catalog));
        if (catalogMatchDontCare) {
            catalogMatch = true;
        }
        boolean bl2 = proc.getSchema() == null ? schema == null : (schemaMatch = proc.getSchema().equals(schema));
        boolean nameMatch = proc.getProcedureName() == null ? name == null : proc.getProcedureName().equals(name);
        return catalogMatch && schemaMatch && nameMatch;
    }

    @Override
    public void addToOROXProjectsForComplexTypes(List<CompositeDatabaseType> types, Project orProject, Project oxProject) {
    }

    @Override
    protected void buildQueryForProcedureType(ProcedureType procType, Project orProject, Project oxProject, ProcedureOperationModel opModel, boolean hasComplexArgs) {
    }
}

