/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Parameter;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.SessionBeanCall;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.LinkList;

public abstract class AbstractPersistenceResource
extends AbstractResource {
    protected Response getContexts(String version, HttpHeaders hh, URI baseURI) throws JAXBException {
        if (!AbstractPersistenceResource.isValidVersion(version)) {
            JPARSLogger.fine("unsupported_service_version_in_the_request", new Object[]{version});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Set<String> contexts = this.getPersistenceFactory().getPersistenceContextNames();
        Iterator<String> contextIterator = contexts.iterator();
        ArrayList<Link> links = new ArrayList<Link>();
        String mediaType = StreamingOutputMarshaller.mediaType(hh.getAcceptableMediaTypes()).toString();
        while (contextIterator.hasNext()) {
            String context = contextIterator.next();
            if (version != null) {
                links.add(new Link(context, mediaType, baseURI + version + "/" + context + "/metadata"));
                continue;
            }
            links.add(new Link(context, mediaType, baseURI + context + "/metadata"));
        }
        LinkList linkList = new LinkList();
        linkList.setList(links);
        String result = null;
        result = mediaType.equals("application/json") ? this.marshallMetadata(linkList.getList(), mediaType) : this.marshallMetadata(linkList, mediaType);
        return Response.ok((Object)new StreamingOutputMarshaller(null, (Object)result, hh.getAcceptableMediaTypes())).build();
    }

    protected Response callSessionBeanInternal(String version, HttpHeaders hh, UriInfo ui, InputStream is) throws JAXBException, ClassNotFoundException, NamingException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (!AbstractPersistenceResource.isValidVersion(version)) {
            JPARSLogger.fine("unsupported_service_version_in_the_request", new Object[]{version});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        SessionBeanCall call = null;
        InitialContext ctx = new InitialContext();
        call = this.unmarshallSessionBeanCall(is);
        String jndiName = call.getJndiName();
        Object ans = ctx.lookup(jndiName);
        if (ans == null) {
            JPARSLogger.fine("jpars_could_not_find_session_bean", new Object[]{jndiName});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        PersistenceContext context = null;
        if (call.getContext() != null && (context = this.getPersistenceFactory().get(call.getContext(), ui.getBaseUri(), version, null)) == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{call.getContext()});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Class[] parameters = new Class[call.getParameters().size()];
        Object[] args = new Object[call.getParameters().size()];
        int i = 0;
        for (Parameter param : call.getParameters()) {
            Class<?> parameterClass = null;
            Object parameterValue = null;
            if (context != null) {
                parameterClass = context.getClass(param.getTypeName());
            }
            if (parameterClass != null) {
                parameterValue = context.unmarshalEntity(param.getTypeName(), hh.getMediaType(), is);
            } else {
                parameterClass = Thread.currentThread().getContextClassLoader().loadClass(param.getTypeName());
                parameterValue = ConversionManager.getDefaultManager().convertObject((Object)param.getValue(), parameterClass);
            }
            parameters[i] = parameterClass;
            args[i] = parameterValue;
            ++i;
        }
        Method method = ans.getClass().getMethod(call.getMethodName(), parameters);
        Object returnValue = method.invoke(ans, args);
        return Response.ok((Object)new StreamingOutputMarshaller(null, returnValue, hh.getAcceptableMediaTypes())).build();
    }

    protected SessionBeanCall unmarshallSessionBeanCall(InputStream data) throws JAXBException {
        Class[] jaxbClasses = new Class[]{SessionBeanCall.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBUnmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        StreamSource ss = new StreamSource(data);
        return (SessionBeanCall)unmarshaller.unmarshal((Source)ss, SessionBeanCall.class).getValue();
    }
}

