/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectCreateException;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.provider.ISharedObjectInstantiator;
import org.eclipse.ecf.core.util.Trace;

public class SharedObjectFactory
implements ISharedObjectFactory {
    private static Hashtable sharedobjectdescriptions = new Hashtable();
    protected static ISharedObjectFactory instance = null;

    static {
        instance = new SharedObjectFactory();
    }

    protected SharedObjectFactory() {
    }

    public static ISharedObjectFactory getDefault() {
        return instance;
    }

    private static void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.sharedobject", (String)msg);
    }

    private static void dumpStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", SharedObjectFactory.class, (String)"dumpStack", (Throwable)e);
    }

    public SharedObjectTypeDescription addDescription(SharedObjectTypeDescription description) {
        SharedObjectFactory.trace("addDescription(" + description + ")");
        return this.addDescription0(description);
    }

    public List getDescriptions() {
        return this.getDescriptions0();
    }

    protected List getDescriptions0() {
        return new ArrayList(sharedobjectdescriptions.values());
    }

    protected SharedObjectTypeDescription addDescription0(SharedObjectTypeDescription n) {
        if (n == null) {
            return null;
        }
        return sharedobjectdescriptions.put(n.getName(), n);
    }

    public boolean containsDescription(SharedObjectTypeDescription scd) {
        return this.containsDescription0(scd);
    }

    protected boolean containsDescription0(SharedObjectTypeDescription scd) {
        if (scd == null) {
            return false;
        }
        return sharedobjectdescriptions.containsKey(scd.getName());
    }

    protected SharedObjectTypeDescription getDescription0(SharedObjectTypeDescription scd) {
        if (scd == null) {
            return null;
        }
        return (SharedObjectTypeDescription)sharedobjectdescriptions.get(scd.getName());
    }

    protected SharedObjectTypeDescription getDescription0(String name) {
        if (name == null) {
            return null;
        }
        return (SharedObjectTypeDescription)sharedobjectdescriptions.get(name);
    }

    public SharedObjectTypeDescription getDescriptionByName(String name) throws SharedObjectCreateException {
        SharedObjectFactory.trace("getDescriptionByName(" + name + ")");
        SharedObjectTypeDescription res = this.getDescription0(name);
        if (res == null) {
            throw new SharedObjectCreateException("SharedObjectDescription named " + name + " not found");
        }
        return res;
    }

    public ISharedObject createSharedObject(SharedObjectTypeDescription desc, Object[] args) throws SharedObjectCreateException {
        SharedObjectFactory.trace("createSharedObject(" + desc + "," + Trace.getArgumentsString((Object[])args) + ")");
        if (desc == null) {
            throw new SharedObjectCreateException("SharedObjectTypeDescription cannot be null");
        }
        SharedObjectTypeDescription cd = this.getDescription0(desc);
        if (cd == null) {
            throw new SharedObjectCreateException("SharedObjectDescription named " + desc.getName() + " not found");
        }
        ISharedObjectInstantiator instantiator = null;
        try {
            instantiator = cd.getInstantiator();
        }
        catch (Exception e) {
            SharedObjectCreateException newexcept = new SharedObjectCreateException("createSharedObject exception with description" + desc, e);
            SharedObjectFactory.dumpStack("Exception in createSharedObject", (Throwable)((Object)newexcept));
            throw newexcept;
        }
        if (instantiator == null) {
            throw new SharedObjectCreateException("Instantiator for SharedObjectDescription " + cd.getName() + " is null");
        }
        return instantiator.createInstance(desc, args);
    }

    public ISharedObject createSharedObject(String descriptionName) throws SharedObjectCreateException {
        return this.createSharedObject(this.getDescriptionByName(descriptionName), null);
    }

    public ISharedObject createSharedObject(String descriptionName, Object[] args) throws SharedObjectCreateException {
        return this.createSharedObject(this.getDescriptionByName(descriptionName), args);
    }

    public SharedObjectTypeDescription removeDescription(SharedObjectTypeDescription scd) {
        SharedObjectFactory.trace("removeDescription(" + scd + ")");
        return this.removeDescription0(scd);
    }

    protected SharedObjectTypeDescription removeDescription0(SharedObjectTypeDescription n) {
        if (n == null) {
            return null;
        }
        return (SharedObjectTypeDescription)sharedobjectdescriptions.remove(n.getName());
    }
}

