/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.zookeeper.core.AdvertisedService;
import org.eclipse.ecf.provider.zookeeper.core.DefaultDiscoveryConfig;
import org.eclipse.ecf.provider.zookeeper.core.internal.Advertiser;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configuration;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configurator;
import org.eclipse.ecf.provider.zookeeper.core.internal.Localizer;
import org.eclipse.ecf.provider.zookeeper.core.internal.Notification;
import org.eclipse.ecf.provider.zookeeper.node.internal.WatchManager;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooDiscoveryContainer
extends AbstractDiscoveryContainerAdapter {
    private static ZooDiscoveryContainer discovery;
    public static ExecutorService CACHED_THREAD_POOL;
    private QuorumPeer quorumPeer;
    private Properties DiscoveryProperties = new Properties();
    protected Advertiser advertiser;
    protected Localizer localizer;
    private static ZooKeeperServer zooKeeperServer;
    private ID targetId;
    protected boolean isQuorumPeerReady;
    private boolean isConnected;
    private boolean isDisposed;
    private WatchManager watchManager;

    static {
        CACHED_THREAD_POOL = Executors.newCachedThreadPool();
    }

    private ZooDiscoveryContainer() {
        super("ecf.namespace.zoodiscovery", (DiscoveryContainerConfig)Configurator.INSTANCE);
        if (ZooDiscoveryContainer.autoStart()) {
            try {
                this.targetId = this.getConnectNamespace().createInstance((Object[])new String[]{DefaultDiscoveryConfig.getDefaultTarget()});
                this.init(this.targetId);
            }
            catch (Exception e) {
                Logger.log(1, e.getMessage(), e);
            }
        }
        Logger.log(3, PrettyPrinter.prompt(3, null), null);
    }

    public static boolean autoStart() {
        return System.getProperty("zoodiscovery.autoStart") != null;
    }

    public static synchronized ZooDiscoveryContainer getSingleton() {
        if (discovery == null) {
            discovery = new ZooDiscoveryContainer();
        }
        discovery.setDisposed(false);
        return discovery;
    }

    public void init(ServiceReference reference) {
        Configuration conf = Configurator.INSTANCE.createConfig(reference).configure();
        this.doStart(conf);
    }

    private void init(ID targetID) {
        Configuration conf = Configurator.INSTANCE.createConfig(targetID).configure();
        this.doStart(conf);
    }

    private void doStart(final Configuration conf) {
        if (this.watchManager != null && !this.watchManager.isDisposed()) {
            return;
        }
        this.watchManager = new WatchManager(conf);
        this.advertiser = Advertiser.getSingleton(this.watchManager);
        this.localizer = Localizer.getSingleton();
        if (conf.isCentralized()) {
            if (Geo.getHost().equals(conf.getServerIps().split(":")[0])) {
                CACHED_THREAD_POOL.execute(new Runnable(){

                    public void run() {
                        ZooDiscoveryContainer.this.startStandAlone(conf);
                        ZooDiscoveryContainer.this.watchManager.watch();
                        ZooDiscoveryContainer.this.localizer.init();
                    }
                });
            } else {
                this.watchManager.watch();
                this.localizer.init();
            }
        } else if (conf.isQuorum()) {
            CACHED_THREAD_POOL.execute(new Runnable(){

                public void run() {
                    ZooDiscoveryContainer.this.startQuorumPeer(conf);
                    ZooDiscoveryContainer.this.watchManager.watch();
                    ZooDiscoveryContainer.this.localizer.init();
                }
            });
        } else if (conf.isStandAlone()) {
            CACHED_THREAD_POOL.execute(new Runnable(){

                public void run() {
                    ZooDiscoveryContainer.this.startStandAlone(conf);
                    ZooDiscoveryContainer.this.watchManager.watch();
                    ZooDiscoveryContainer.this.localizer.init();
                }
            });
        }
    }

    void startStandAlone(Configuration conf) {
        if (zooKeeperServer != null && zooKeeperServer.isRunning()) {
            return;
        }
        if (zooKeeperServer != null && !zooKeeperServer.isRunning()) {
            try {
                zooKeeperServer.startup();
                return;
            }
            catch (Exception e) {
                Logger.log(4, "Zookeeper server cannot be started! ", e);
            }
        }
        try {
            zooKeeperServer = new ZooKeeperServer();
            FileTxnSnapLog fileTxnSnapLog = new FileTxnSnapLog(conf.getZookeeperDataFile(), conf.getZookeeperDataFile());
            zooKeeperServer.setTxnLogFactory(fileTxnSnapLog);
            zooKeeperServer.setTickTime(conf.getTickTime());
            NIOServerCnxn.Factory cnxnFactory = new NIOServerCnxn.Factory(new InetSocketAddress(conf.getClientPort()));
            cnxnFactory.startup(zooKeeperServer);
        }
        catch (Exception e) {
            Logger.log(1, "Zookeeper server cannot be started! Possibly another instance is already running on the same port. ", e);
        }
    }

    void startQuorumPeer(Configuration conf) {
        if (this.quorumPeer != null && this.quorumPeer.isAlive()) {
            return;
        }
        if (this.quorumPeer != null && !this.quorumPeer.isAlive()) {
            this.quorumPeer.start();
            return;
        }
        try {
            final QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
            quorumPeerConfig.parse(conf.getConfFile());
            QuorumPeer.Factory qpFactory = new QuorumPeer.Factory(){

                public QuorumPeer create(NIOServerCnxn.Factory cnxnFactory) throws IOException {
                    ServerConfig serverConfig = new ServerConfig();
                    serverConfig.readFrom(quorumPeerConfig);
                    QuorumPeer peer = new QuorumPeer(quorumPeerConfig.getServers(), new File(serverConfig.getDataDir()), new File(serverConfig.getDataLogDir()), quorumPeerConfig.getElectionAlg(), quorumPeerConfig.getServerId(), quorumPeerConfig.getTickTime(), quorumPeerConfig.getInitLimit(), quorumPeerConfig.getSyncLimit(), cnxnFactory, quorumPeerConfig.getQuorumVerifier());
                    ZooDiscoveryContainer.this.quorumPeer = peer;
                    return peer;
                }

                public NIOServerCnxn.Factory createConnectionFactory() throws IOException {
                    return new NIOServerCnxn.Factory(quorumPeerConfig.getClientPortAddress());
                }
            };
            this.quorumPeer = qpFactory.create(qpFactory.createConnectionFactory());
            this.quorumPeer.start();
            this.quorumPeer.setDaemon(true);
            this.isQuorumPeerReady = true;
        }
        catch (Exception e) {
            Logger.log(1, "Zookeeper quorum cannot be started! ", e);
            this.isQuorumPeerReady = false;
        }
    }

    public void setDiscoveryProperties(Properties discoveryProperties) {
        this.DiscoveryProperties = discoveryProperties;
    }

    public Properties getDiscoveryProperties() {
        return this.DiscoveryProperties;
    }

    public synchronized void shutdown() {
        if (this.isDisposed) {
            return;
        }
        try {
            if (this.watchManager != null) {
                this.watchManager.dispose();
            }
            if (this.localizer != null) {
                this.localizer.close();
            }
            if (zooKeeperServer != null) {
                PurgeTxnLog.purge((File)zooKeeperServer.getTxnLogFactory().getDataDir(), (File)zooKeeperServer.getTxnLogFactory().getSnapDir(), (int)3);
                zooKeeperServer.shutdown();
            }
            if (this.quorumPeer != null) {
                PurgeTxnLog.purge((File)this.quorumPeer.getTxnFactory().getDataDir(), (File)this.quorumPeer.getTxnFactory().getSnapDir(), (int)3);
                if (this.quorumPeer.isAlive()) {
                    this.quorumPeer.shutdown();
                }
                this.quorumPeer.getCnxnFactory().shutdown();
            }
        }
        catch (Throwable t) {
            Logger.log(1, t.getMessage(), t);
        }
        this.targetId = null;
        this.isConnected = false;
        this.isDisposed = true;
        discovery = null;
    }

    public ZooKeeperServer getLocalServer() {
        return zooKeeperServer;
    }

    public void connect(ID id, IConnectContext connectContext) throws ContainerConnectException {
        if (this.isDisposed) {
            throw new ContainerConnectException("Container already disposed!");
        }
        if (this.isConnected) {
            throw new ContainerConnectException("Container already connected!");
        }
        this.targetId = id;
        if (this.targetId == null) {
            this.targetId = this.getConnectNamespace().createInstance((Object[])new String[]{DefaultDiscoveryConfig.getDefaultTarget()});
        }
        this.init(this.targetId);
        this.isConnected = true;
    }

    public void disconnect() {
        if (this.watchManager != null) {
            this.watchManager.dispose();
        }
        this.isConnected = false;
        this.targetId = null;
    }

    public Namespace getConnectNamespace() {
        return super.getConnectNamespace();
    }

    public ID getConnectedID() {
        if (!this.isConnected || this.isDisposed) {
            return null;
        }
        return this.targetId;
    }

    public IServiceInfo getServiceInfo(IServiceID serviceID) {
        Assert.isNotNull((Object)serviceID);
        return this.watchManager.getAllKnownServices().get(serviceID.getName());
    }

    public IServiceTypeID[] getServiceTypes() {
        IServiceTypeID[] ids = new IServiceTypeID[this.getServices().length];
        int i = 0;
        while (i < ids.length) {
            ids[i] = this.getServices()[i].getServiceID().getServiceTypeID();
            ++i;
        }
        return ids;
    }

    public IServiceInfo[] getServices() {
        if (this.watchManager == null) {
            return new IServiceInfo[0];
        }
        return this.watchManager.getAllKnownServices().values().toArray(new IServiceInfo[this.watchManager.getAllKnownServices().size()]);
    }

    public IServiceInfo[] getServices(IServiceTypeID type) {
        Assert.isNotNull((Object)type);
        if (this.watchManager == null) {
            return new IServiceInfo[0];
        }
        ArrayList<IServiceInfo> services = new ArrayList<IServiceInfo>();
        for (IServiceInfo sinfo : this.watchManager.getAllKnownServices().values()) {
            if (sinfo.getServiceID().getServiceTypeID().getInternal() != type.getInternal()) continue;
            services.add(sinfo);
        }
        return services.toArray(new IServiceInfo[services.size()]);
    }

    public Namespace getServicesNamespace() {
        return super.getServicesNamespace();
    }

    public synchronized void registerService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        if (this.targetId == null) {
            this.targetId = this.getConnectNamespace().createInstance((Object[])new String[]{DefaultDiscoveryConfig.getDefaultTarget()});
            this.init(this.targetId);
        }
        if (serviceInfo instanceof AdvertisedService) {
            this.watchManager.publish((AdvertisedService)serviceInfo);
        } else {
            this.watchManager.publish(new AdvertisedService(serviceInfo));
        }
        Localizer.getSingleton().localize(new Notification(serviceInfo, 1));
    }

    public void unregisterAllServices() {
        this.watchManager.unpublishAll();
    }

    public void unregisterService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        this.watchManager.unpublish(serviceInfo.getServiceID().getServiceTypeID().getInternal());
        Localizer.getSingleton().localize(new Notification(serviceInfo, 2));
    }

    public Collection<IServiceListener> getAllServiceListeners() {
        return this.allServiceListeners;
    }

    public Collection<IServiceListener> getServiceListenersForType(IServiceTypeID type) {
        return super.getListeners(type);
    }

    public Collection<IServiceTypeListener> getServiceTypeListeners() {
        return this.serviceTypeListeners;
    }

    public void dispose() {
        this.shutdown();
        super.dispose();
    }

    public ID getID() {
        return Configurator.INSTANCE.getID();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public String getContainerName() {
        return "ecf.discovery.zoodiscovery";
    }

    private void setDisposed(boolean d) {
        this.isDisposed = d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FLAVOR {
        STANDALONE,
        CENTRALIZED,
        REPLICATED;


        public String toString() {
            switch (this) {
                case STANDALONE: {
                    return "zoodiscovery.flavor.standalone";
                }
                case CENTRALIZED: {
                    return "zoodiscovery.flavor.centralized";
                }
                case REPLICATED: {
                    return "zoodiscovery.flavor.replicated";
                }
            }
            throw new AssertionError((Object)"Unsupported configuration");
        }
    }
}

