/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.CallbackRemoteCallListener;
import org.eclipse.ecf.remoteservice.IAsyncCallback;
import org.eclipse.ecf.remoteservice.IAsyncRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxyCreator;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.RemoteCall;
import org.eclipse.ecf.remoteservice.asyncproxy.AbstractAsyncProxyRemoteCall;
import org.eclipse.ecf.remoteservice.asyncproxy.AbstractAsyncProxyRemoteService;
import org.eclipse.ecf.remoteservice.asyncproxy.IAsyncProxyCompletable;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractRemoteService
extends AbstractAsyncProxyRemoteService
implements IRemoteService,
InvocationHandler {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected int futureExecutorServiceMaxThreads = Integer.parseInt(System.getProperty("ecf.remoteservice.futureExecutorServiceMaxThreads", "10"));
    protected ExecutorService futureExecutorService;
    protected IExecutor iFutureExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getFutureExecutorService(IRemoteCall call) {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.futureExecutorService == null) {
                this.futureExecutorService = Executors.newFixedThreadPool(this.futureExecutorServiceMaxThreads);
            }
        }
        return this.futureExecutorService;
    }

    protected void setFutureExecutorService(ExecutorService executorService) {
        this.futureExecutorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IExecutor getIFutureExecutor(IRemoteCall call) {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.iFutureExecutor == null) {
                this.iFutureExecutor = new JobsExecutor("RSJobs[rsID=" + this.getRemoteServiceID() + "]");
            }
        }
        return this.iFutureExecutor;
    }

    protected void setIFutureExecutor(IExecutor executor) {
        this.iFutureExecutor = executor;
    }

    protected abstract String[] getInterfaceClassNames();

    protected abstract IRemoteServiceID getRemoteServiceID();

    protected abstract IRemoteServiceReference getRemoteServiceReference();

    protected Class loadInterfaceClass(String className) throws ClassNotFoundException {
        return this.loadInterfaceClass(this.getClass().getClassLoader(), className);
    }

    protected Class loadInterfaceClass(ClassLoader cl, String className) throws ClassNotFoundException {
        return Class.forName(className, true, cl);
    }

    protected IRemoteService getRemoteService() {
        return this;
    }

    protected long getDefaultTimeout() {
        return IRemoteCall.DEFAULT_TIMEOUT;
    }

    protected IFuture callAsync(AbstractAsyncProxyRemoteCall call) {
        return this.callAsync((IRemoteCall)call);
    }

    public IFuture callAsync(final IRemoteCall call) {
        IExecutor executor = this.getIFutureExecutor(call);
        if (executor == null) {
            throw new ServiceException("iFuture executor is null.  Cannot callAsync remote method=" + call.getMethod());
        }
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractRemoteService.this.callSync(call);
            }
        }, null);
    }

    public Object getProxy() throws ECFException {
        ArrayList<Class> classes = new ArrayList<Class>();
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            String[] clazzes = this.getInterfaceClassNames();
            int i = 0;
            while (i < clazzes.length) {
                classes.add(this.loadInterfaceClass(cl, clazzes[i]));
                ++i;
            }
        }
        catch (Exception e) {
            ECFException except = new ECFException("Failed to create proxy", (Throwable)e);
            this.logWarning("Exception in remote service getProxy", (Throwable)except);
            throw except;
        }
        catch (NoClassDefFoundError e) {
            ECFException except = new ECFException("Failed to load proxy interface class", (Throwable)e);
            this.logWarning("Could not load class for getProxy", (Throwable)except);
            throw except;
        }
        return this.getProxy(cl, classes.toArray(new Class[classes.size()]));
    }

    protected void addRemoteServiceProxyToProxy(List classes) {
        IRemoteServiceReference rsReference = this.getRemoteServiceReference();
        if (rsReference != null && rsReference.getProperty("ecf.rsvc.norsproxy") == null) {
            classes.add(IRemoteServiceProxy.class);
        }
    }

    private boolean nameAlreadyPresent(String className, List classes) {
        for (Class c : classes) {
            if (!className.equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    protected List addAsyncProxyClasses(ClassLoader cl, Class[] interfaces) {
        List<Class> intfs = Arrays.asList(interfaces);
        ArrayList<Class> results = new ArrayList<Class>();
        if (this.getRemoteServiceReference().getProperty("ecf.rsvc.async.noproxy") == null) {
            for (Class intf : intfs) {
                Class asyncClass;
                String intfName = this.convertInterfaceNameToAsyncInterfaceName(intf.getName());
                if (intfName == null || this.nameAlreadyPresent(intfName, intfs) || (asyncClass = this.findAsyncRemoteServiceProxyClass(cl, intf)) == null || intfs.contains(asyncClass)) continue;
                results.add(asyncClass);
            }
        }
        results.addAll(intfs);
        return results;
    }

    public Object getProxy(ClassLoader cl, Class[] interfaces) throws ECFException {
        List classes = this.addAsyncProxyClasses(cl, interfaces);
        this.addRemoteServiceProxyToProxy(classes);
        try {
            return this.createProxy(cl, classes.toArray(new Class[classes.size()]));
        }
        catch (Exception e) {
            ECFException except = new ECFException("Failed to create proxy", (Throwable)e);
            this.logWarning("Exception in remote service getProxy", (Throwable)except);
            throw except;
        }
        catch (NoClassDefFoundError e) {
            ECFException except = new ECFException("Failed to load proxy interface class", (Throwable)e);
            this.logWarning("Could not load class for getProxy", (Throwable)except);
            throw except;
        }
    }

    protected IRemoteServiceProxyCreator getRemoteServiceProxyCreator() {
        ServiceTracker st = new ServiceTracker(Activator.getDefault().getContext(), IRemoteServiceProxyCreator.class, null);
        st.open();
        IRemoteServiceProxyCreator result = (IRemoteServiceProxyCreator)st.getService();
        st.close();
        return result;
    }

    protected Object createProxy(ClassLoader cl, Class[] classes) {
        IRemoteServiceProxyCreator proxyCreator = this.getRemoteServiceProxyCreator();
        if (proxyCreator != null) {
            return proxyCreator.createProxy(new ProxyClassLoader(cl), classes, this);
        }
        return Proxy.newProxyInstance(new ProxyClassLoader(cl), classes, (InvocationHandler)this);
    }

    protected Object createProxy(Class[] classes) {
        return this.createProxy(this.getClass().getClassLoader(), classes);
    }

    protected Class findAsyncRemoteServiceProxyClass(Class c) {
        String proxyClassName = this.convertInterfaceNameToAsyncInterfaceName(c.getName());
        try {
            return Class.forName(proxyClassName);
        }
        catch (ClassNotFoundException e) {
            this.logInfo("No async remote service interface found with name=" + proxyClassName + " for proxy service class=" + c.getName(), e);
            return null;
        }
        catch (NoClassDefFoundError e) {
            this.logWarning("Async remote service interface with name=" + proxyClassName + " could not be loaded for proxy service class=" + c.getName(), e);
            return null;
        }
    }

    protected Class findAsyncRemoteServiceProxyClass(ClassLoader cl, Class c) {
        String proxyClassName = this.convertInterfaceNameToAsyncInterfaceName(c.getName());
        if (proxyClassName == null) {
            return null;
        }
        try {
            return Class.forName(proxyClassName, true, cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            this.logWarning("Async remote service interface with name=" + proxyClassName + " could not be loaded for proxy service class=" + c.getName(), e);
            return null;
        }
    }

    protected String convertInterfaceNameToAsyncInterfaceName(String interfaceName) {
        if (interfaceName == null) {
            return null;
        }
        String asyncProxyName = (String)this.getRemoteServiceReference().getProperty("ecf.rsvc.async.proxy_" + interfaceName);
        if (asyncProxyName != null) {
            return asyncProxyName;
        }
        if (interfaceName.endsWith("Async")) {
            return interfaceName;
        }
        return String.valueOf(interfaceName) + "Async";
    }

    protected Object[] getCallParametersForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return args == null ? EMPTY_ARGS : args;
    }

    protected long getCallTimeoutForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return IRemoteCall.DEFAULT_TIMEOUT;
    }

    protected String getCallMethodNameForProxyInvoke(Method method, Object[] args) {
        return method.getName();
    }

    protected Object invokeObject(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            String[] clazzes = this.getInterfaceClassNames();
            String proxyClass = clazzes.length == 1 ? clazzes[0] : Arrays.asList(clazzes).toString();
            return String.valueOf(proxyClass) + ".proxy@" + this.getRemoteServiceID();
        }
        if (methodName.equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (methodName.equals("equals")) {
            if (args == null || args.length == 0) {
                return Boolean.FALSE;
            }
            try {
                return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
            }
            catch (IllegalArgumentException e) {
                return Boolean.FALSE;
            }
        }
        if (methodName.equals("getRemoteService")) {
            return this.getRemoteService();
        }
        if (methodName.equals("getRemoteServiceReference")) {
            return this.getRemoteServiceReference();
        }
        return null;
    }

    protected Object invokeSync(IRemoteCall call) throws ECFException {
        return this.callSync(call);
    }

    protected boolean isAsync(Object proxy, Method method, Object[] args) {
        return Arrays.asList(method.getDeclaringClass().getInterfaces()).contains(IAsyncRemoteServiceProxy.class) || method.getName().endsWith("Async");
    }

    protected IRemoteCall createRemoteCall(final String callMethod, final Object[] callParameters, final long callTimeout) {
        return new IRemoteCall(){

            public String getMethod() {
                return callMethod;
            }

            public Object[] getParameters() {
                return callParameters;
            }

            public long getTimeout() {
                return callTimeout;
            }
        };
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object resultObject = this.invokeObject(proxy, method, args);
            if (resultObject != null) {
                return resultObject;
            }
            if (this.isAsync(proxy, method, args)) {
                return this.invokeAsync(method, args);
            }
            String callMethod = this.getCallMethodNameForProxyInvoke(method, args);
            Object[] callParameters = this.getCallParametersForProxyInvoke(callMethod, method, args);
            long callTimeout = this.getCallTimeoutForProxyInvoke(callMethod, method, args);
            IRemoteCall remoteCall = this.createRemoteCall(callMethod, callParameters, callTimeout);
            return this.invokeSync(remoteCall);
        }
        catch (Throwable t) {
            if (t instanceof ServiceException) {
                throw t;
            }
            throw new ServiceException("Service exception on remote service proxy rsid=" + this.getRemoteServiceID(), 5, t);
        }
    }

    protected RemoteCall getAsyncRemoteCall(String invokeMethodName, Object[] asyncArgs) {
        return new RemoteCall(invokeMethodName, asyncArgs, IRemoteCall.DEFAULT_TIMEOUT);
    }

    protected Object invokeAsync(Method method, Object[] args) throws Throwable {
        String invokeMethodName = this.getAsyncInvokeMethodName(method);
        AsyncArgs asyncArgs = this.getAsyncArgs(method, args);
        RemoteCall remoteCall = this.getAsyncRemoteCall(invokeMethodName, asyncArgs.getArgs());
        IRemoteCallListener listener = asyncArgs.getListener();
        return listener != null ? this.callAsyncWithResult(remoteCall, listener) : this.callFuture(remoteCall, asyncArgs.getReturnType());
    }

    protected Object callAsyncWithResult(IRemoteCall call, IRemoteCallListener listener) {
        this.callAsync(call, listener);
        return null;
    }

    protected void callCompletableAsync(AbstractAsyncProxyRemoteCall call, final IAsyncProxyCompletable completable) {
        this.callAsync((IRemoteCall)call, new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    IRemoteCallCompleteEvent cce = (IRemoteCallCompleteEvent)event;
                    completable.handleComplete(cce.getResponse(), cce.hadException(), cce.getException());
                }
            }
        });
    }

    protected Future callFutureAsync(AbstractAsyncProxyRemoteCall call) {
        return this.callFutureAsync((IRemoteCall)call);
    }

    protected Future callFutureAsync(final IRemoteCall call) {
        ExecutorService executorService = this.getFutureExecutorService(call);
        if (executorService == null) {
            throw new ServiceException("future executor service is null.  .  Cannot callAsync remote method=" + call.getMethod());
        }
        return executorService.submit(new Callable(){

            public Object call() throws Exception {
                return AbstractRemoteService.this.callSync(call);
            }
        });
    }

    protected AsyncArgs getAsyncArgs(Method method, Object[] args) {
        IRemoteCallListener listener = null;
        Class<?> returnType = method.getReturnType();
        if (Future.class.isAssignableFrom(returnType) || IFuture.class.isAssignableFrom(returnType)) {
            return new AsyncArgs(args, returnType);
        }
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Async calls must include a IRemoteCallListener instance as the last argument");
        }
        Object lastArg = args[args.length - 1];
        if (lastArg instanceof IRemoteCallListener) {
            listener = (IRemoteCallListener)lastArg;
        }
        if (lastArg instanceof IAsyncCallback) {
            listener = new CallbackRemoteCallListener((IAsyncCallback)lastArg);
        }
        if (listener == null) {
            throw new IllegalArgumentException("Last argument must be an instance of IRemoteCallListener");
        }
        return new AsyncArgs(listener, args);
    }

    protected String getAsyncInvokeMethodName(Method method) {
        String methodName = method.getName();
        return methodName.endsWith("Async") ? methodName.substring(0, methodName.length() - "Async".length()) : methodName;
    }

    private void logInfo(String message, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(1, "org.eclipse.ecf.remoteservice", message, e));
        }
    }

    protected void logWarning(String string, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, "org.eclipse.ecf.remoteservice", string, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.futureExecutorService != null) {
                this.futureExecutorService.shutdownNow();
                this.futureExecutorService = null;
            }
            this.iFutureExecutor = null;
        }
    }

    public class AsyncArgs {
        private IRemoteCallListener listener;
        private Object[] args;
        private Class returnType;

        public AsyncArgs(Object[] originalArgs, Class returnType) {
            this.listener = null;
            this.args = originalArgs;
            this.returnType = returnType;
        }

        public AsyncArgs(IRemoteCallListener listener, Object[] originalArgs) {
            this.listener = listener;
            if (this.listener != null) {
                int asynchArgsLength = originalArgs.length - 1;
                this.args = new Object[asynchArgsLength];
                System.arraycopy(originalArgs, 0, this.args, 0, asynchArgsLength);
            } else {
                this.args = originalArgs;
            }
        }

        public IRemoteCallListener getListener() {
            return this.listener;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Class getReturnType() {
            return this.returnType;
        }
    }

    public class ProxyClassLoader
    extends ClassLoader {
        private ClassLoader cl;

        public ProxyClassLoader(ClassLoader cl) {
            this.cl = cl;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return this.cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                Activator a = Activator.getDefault();
                if (a == null) {
                    throw e;
                }
                BundleContext context = a.getContext();
                if (context == null) {
                    throw e;
                }
                return context.getBundle().loadClass(name);
            }
        }
    }
}

