/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.tools;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.xbill.DNS.Address;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.Zone;
import org.xbill.DNS.ZoneTransferException;

public class jnamed {
    static final int FLAG_DNSSECOK = 1;
    static final int FLAG_SIGONLY = 2;
    Map<Integer, Cache> caches;
    Map<Name, Zone> znames;
    Map<Name, TSIG> TSIGs;

    private static String addrport(InetAddress addr, int port) {
        return addr.getHostAddress() + "#" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public jnamed(String conffile) throws IOException, ZoneTransferException {
        BufferedReader br;
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            FileInputStream fs = new FileInputStream(conffile);
            InputStreamReader isr = new InputStreamReader(fs);
            br = new BufferedReader(isr);
        }
        catch (Exception e) {
            System.out.println("Cannot open " + conffile);
            return;
        }
        try {
            String line;
            this.caches = new HashMap<Integer, Cache>();
            this.znames = new HashMap<Name, Zone>();
            this.TSIGs = new HashMap<Name, TSIG>();
            block21: while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String keyword = st.nextToken();
                if (!st.hasMoreTokens()) {
                    System.out.println("Invalid line: " + line);
                    continue;
                }
                if (keyword.charAt(0) == '#') continue;
                switch (keyword) {
                    case "primary": {
                        this.addPrimaryZone(st.nextToken(), st.nextToken());
                        continue block21;
                    }
                    case "secondary": {
                        this.addSecondaryZone(st.nextToken(), st.nextToken());
                        continue block21;
                    }
                    case "cache": {
                        Cache cache = new Cache(st.nextToken());
                        this.caches.put(1, cache);
                        continue block21;
                    }
                    case "key": {
                        String s1 = st.nextToken();
                        String s2 = st.nextToken();
                        if (st.hasMoreTokens()) {
                            this.addTSIG(s1, s2, st.nextToken());
                            continue block21;
                        }
                        this.addTSIG("hmac-md5", s1, s2);
                        continue block21;
                    }
                    case "port": {
                        ports.add(Integer.valueOf(st.nextToken()));
                        continue block21;
                    }
                    case "address": {
                        String addr = st.nextToken();
                        addresses.add(Address.getByAddress(addr));
                        continue block21;
                    }
                }
                System.out.println("unknown keyword: " + keyword);
            }
            if (ports.isEmpty()) {
                ports.add(53);
            }
            if (addresses.isEmpty()) {
                addresses.add(Address.getByAddress("0.0.0.0"));
            }
            for (InetAddress address : addresses) {
                for (Integer o : ports) {
                    int port = o;
                    this.addUDP(address, port);
                    this.addTCP(address, port);
                    System.out.println("jnamed: listening on " + jnamed.addrport(address, port));
                }
            }
            System.out.println("jnamed: running");
        }
        finally {
            br.close();
        }
    }

    public void addPrimaryZone(String zname, String zonefile) throws IOException {
        Name origin = null;
        if (zname != null) {
            origin = Name.fromString(zname, Name.root);
        }
        Zone newzone = new Zone(origin, zonefile);
        this.znames.put(newzone.getOrigin(), newzone);
    }

    public void addSecondaryZone(String zone, String remote) throws IOException, ZoneTransferException {
        Name zname = Name.fromString(zone, Name.root);
        Zone newzone = new Zone(zname, 1, remote);
        this.znames.put(zname, newzone);
    }

    public void addTSIG(String algstr, String namestr, String key) throws IOException {
        Name name = Name.fromString(namestr, Name.root);
        this.TSIGs.put(name, new TSIG(algstr, namestr, key));
    }

    public Cache getCache(int dclass) {
        return this.caches.computeIfAbsent(dclass, Cache::new);
    }

    public Zone findBestZone(Name name) {
        Zone foundzone = this.znames.get(name);
        if (foundzone != null) {
            return foundzone;
        }
        int labels = name.labels();
        for (int i = 1; i < labels; ++i) {
            Name tname = new Name(name, i);
            foundzone = this.znames.get(tname);
            if (foundzone == null) continue;
            return foundzone;
        }
        return null;
    }

    public RRset findExactMatch(Name name, int type, int dclass, boolean glue) {
        Zone zone = this.findBestZone(name);
        if (zone != null) {
            return zone.findExactMatch(name, type);
        }
        Cache cache = this.getCache(dclass);
        List<RRset> rrsets = glue ? cache.findAnyRecords(name, type) : cache.findRecords(name, type);
        if (rrsets == null) {
            return null;
        }
        return rrsets.get(0);
    }

    /*
     * WARNING - void declaration
     */
    void addRRset(Name name, Message response, RRset rrset, int section, int flags) {
        for (int s = 1; s <= section; ++s) {
            if (!response.findRRset(name, rrset.getType(), s)) continue;
            return;
        }
        if ((flags & 2) == 0) {
            for (Record record : rrset.rrs()) {
                void var7_9;
                if (record.getName().isWild() && !name.isWild()) {
                    Record record2 = record.withName(name);
                }
                response.addRecord((Record)var7_9, section);
            }
        }
        if ((flags & 3) != 0) {
            for (Record record : rrset.sigs()) {
                void var7_15;
                if (record.getName().isWild() && !name.isWild()) {
                    Record record3 = record.withName(name);
                }
                response.addRecord((Record)var7_15, section);
            }
        }
    }

    private void addSOA(Message response, Zone zone) {
        response.addRecord(zone.getSOA(), 2);
    }

    private void addNS(Message response, Zone zone, int flags) {
        RRset nsRecords = zone.getNS();
        this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
    }

    private void addCacheNS(Message response, Cache cache, Name name) {
        SetResponse sr = cache.lookupRecords(name, 2, 0);
        if (!sr.isDelegation()) {
            return;
        }
        RRset nsRecords = sr.getNS();
        for (Record r : nsRecords.rrs()) {
            response.addRecord(r, 2);
        }
    }

    private void addGlue(Message response, Name name, int flags) {
        RRset a = this.findExactMatch(name, 1, 1, true);
        if (a == null) {
            return;
        }
        this.addRRset(name, response, a, 3, flags);
    }

    private void addAdditional2(Message response, int section, int flags) {
        for (Record r : response.getSection(section)) {
            Name glueName = r.getAdditionalName();
            if (glueName == null) continue;
            this.addGlue(response, glueName, flags);
        }
    }

    private void addAdditional(Message response, int flags) {
        this.addAdditional2(response, 1, flags);
        this.addAdditional2(response, 2, flags);
    }

    byte addAnswer(Message response, Name name, int type, int dclass, int iterations, int flags) {
        SetResponse sr;
        Zone zone;
        int rcode = 0;
        if (iterations > 6) {
            return 0;
        }
        if (type == 24 || type == 46) {
            type = 255;
            flags |= 2;
        }
        if ((zone = this.findBestZone(name)) != null) {
            sr = zone.findRecords(name, type);
        } else {
            Cache cache = this.getCache(dclass);
            sr = cache.lookupRecords(name, type, 3);
        }
        if (sr.isUnknown()) {
            this.addCacheNS(response, this.getCache(dclass), name);
        }
        if (sr.isNXDOMAIN()) {
            response.getHeader().setRcode(3);
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
            rcode = 3;
        } else if (sr.isNXRRSET()) {
            if (zone != null) {
                this.addSOA(response, zone);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            }
        } else if (sr.isDelegation()) {
            RRset nsRecords = sr.getNS();
            this.addRRset(nsRecords.getName(), response, nsRecords, 2, flags);
        } else if (sr.isCNAME()) {
            CNAMERecord cname = sr.getCNAME();
            RRset rrset = new RRset((Record)cname);
            this.addRRset(name, response, rrset, 1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, cname.getTarget(), type, dclass, iterations + 1, flags);
        } else if (sr.isDNAME()) {
            Name newname;
            DNAMERecord dname = sr.getDNAME();
            RRset rrset = new RRset((Record)dname);
            this.addRRset(name, response, rrset, 1, flags);
            try {
                newname = name.fromDNAME(dname);
            }
            catch (NameTooLongException e) {
                return 6;
            }
            CNAMERecord cname = new CNAMERecord(name, dclass, 0L, newname);
            RRset cnamerrset = new RRset((Record)cname);
            this.addRRset(name, response, cnamerrset, 1, flags);
            if (zone != null && iterations == 0) {
                response.getHeader().setFlag(5);
            }
            rcode = this.addAnswer(response, newname, type, dclass, iterations + 1, flags);
        } else if (sr.isSuccessful()) {
            List<RRset> rrsets = sr.answers();
            for (RRset rrset : rrsets) {
                this.addRRset(name, response, rrset, 1, flags);
            }
            if (zone != null) {
                this.addNS(response, zone, flags);
                if (iterations == 0) {
                    response.getHeader().setFlag(5);
                }
            } else {
                this.addCacheNS(response, this.getCache(dclass), name);
            }
        }
        return (byte)rcode;
    }

    byte[] doAXFR(Name name, Message query, TSIG tsig, TSIGRecord qtsig, Socket s) {
        Zone zone = this.znames.get(name);
        boolean first = true;
        if (zone == null) {
            return this.errorMessage(query, 5);
        }
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            int id = query.getHeader().getID();
            Iterator<RRset> it = zone.AXFR();
            while (it.hasNext()) {
                RRset rrset = it.next();
                Message response = new Message(id);
                Header header = response.getHeader();
                header.setFlag(0);
                header.setFlag(5);
                this.addRRset(rrset.getName(), response, rrset, 1, 1);
                if (tsig != null) {
                    tsig.apply(response, qtsig, first);
                    qtsig = response.getTSIG();
                }
                first = false;
                byte[] out = response.toWire();
                dataOut.writeShort(out.length);
                dataOut.write(out);
            }
        }
        catch (IOException ex) {
            System.out.println("AXFR failed");
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    byte[] generateReply(Message query, byte[] in, Socket s) {
        int flags = 0;
        Header header = query.getHeader();
        if (header.getFlag(0)) {
            return null;
        }
        if (header.getRcode() != 0) {
            return this.errorMessage(query, 1);
        }
        if (header.getOpcode() != 0) {
            return this.errorMessage(query, 4);
        }
        Record queryRecord = query.getQuestion();
        TSIGRecord queryTSIG = query.getTSIG();
        TSIG tsig = null;
        if (queryTSIG != null && ((tsig = this.TSIGs.get(queryTSIG.getName())) == null || tsig.verify(query, in, null) != 0)) {
            return this.formerrMessage(in);
        }
        OPTRecord queryOPT = query.getOPT();
        int maxLength = s != null ? 65535 : (queryOPT != null ? Math.max(queryOPT.getPayloadSize(), 512) : 512);
        if (queryOPT != null && (queryOPT.getFlags() & 0x8000) != 0) {
            flags = 1;
        }
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(0);
        if (query.getHeader().getFlag(7)) {
            response.getHeader().setFlag(7);
        }
        response.addRecord(queryRecord, 0);
        Name name = queryRecord.getName();
        int type = queryRecord.getType();
        int dclass = queryRecord.getDClass();
        if (type == 252 && s != null) {
            return this.doAXFR(name, query, tsig, queryTSIG, s);
        }
        if (!Type.isRR(type) && type != 255) {
            return this.errorMessage(query, 4);
        }
        byte rcode = this.addAnswer(response, name, type, dclass, 0, flags);
        if (rcode != 0 && rcode != 3) {
            return this.errorMessage(query, rcode);
        }
        this.addAdditional(response, flags);
        if (queryOPT != null) {
            int optflags = flags == 1 ? 32768 : 0;
            OPTRecord opt = new OPTRecord(4096, (int)rcode, 0, optflags);
            response.addRecord(opt, 3);
        }
        response.setTSIG(tsig, 0, queryTSIG);
        return response.toWire(maxLength);
    }

    byte[] buildErrorMessage(Header header, int rcode, Record question) {
        Message response = new Message();
        response.setHeader(header);
        for (int i = 0; i < 4; ++i) {
            response.removeAllRecords(i);
        }
        if (rcode == 2) {
            response.addRecord(question, 0);
        }
        header.setRcode(rcode);
        return response.toWire();
    }

    public byte[] formerrMessage(byte[] in) {
        Header header;
        try {
            header = new Header(in);
        }
        catch (IOException e) {
            return null;
        }
        return this.buildErrorMessage(header, 1, null);
    }

    public byte[] errorMessage(Message query, int rcode) {
        return this.buildErrorMessage(query.getHeader(), rcode, query.getQuestion());
    }

    public void TCPclient(Socket s) {
        try (InputStream is = s.getInputStream();){
            byte[] response;
            DataInputStream dataIn = new DataInputStream(is);
            int inLength = dataIn.readUnsignedShort();
            byte[] in = new byte[inLength];
            dataIn.readFully(in);
            try {
                Message query = new Message(in);
                response = this.generateReply(query, in, s);
                if (response == null) {
                    return;
                }
            }
            catch (IOException e) {
                response = this.formerrMessage(in);
            }
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            dataOut.writeShort(response.length);
            dataOut.write(response);
        }
        catch (IOException e) {
            System.out.println("TCPclient(" + jnamed.addrport(s.getLocalAddress(), s.getLocalPort()) + "): " + e);
        }
    }

    public void serveTCP(InetAddress addr, int port) {
        try {
            ServerSocket sock = new ServerSocket(port, 128, addr);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        Socket s = sock.accept();
                        Thread t = new Thread(() -> this.TCPclient(s));
                        t.start();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (sock != null) {
                    if (throwable != null) {
                        try {
                            sock.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        sock.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            System.out.println("serveTCP(" + jnamed.addrport(addr, port) + "): " + e);
            return;
        }
    }

    public void serveUDP(InetAddress addr, int port) {
        try {
            DatagramSocket sock = new DatagramSocket(port, addr);
            Throwable throwable = null;
            try {
                try {
                    int udpLength = 512;
                    byte[] in = new byte[512];
                    DatagramPacket indp = new DatagramPacket(in, in.length);
                    DatagramPacket outdp = null;
                    while (true) {
                        byte[] response;
                        indp.setLength(in.length);
                        try {
                            sock.receive(indp);
                        }
                        catch (InterruptedIOException e) {
                            continue;
                        }
                        try {
                            Message query = new Message(in);
                            response = this.generateReply(query, in, null);
                            if (response == null) {
                                continue;
                            }
                        }
                        catch (IOException e) {
                            response = this.formerrMessage(in);
                        }
                        if (outdp == null) {
                            outdp = new DatagramPacket(response, response.length, indp.getAddress(), indp.getPort());
                        } else {
                            outdp.setData(response);
                            outdp.setLength(response.length);
                            outdp.setAddress(indp.getAddress());
                            outdp.setPort(indp.getPort());
                        }
                        sock.send(outdp);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (sock != null) {
                    if (throwable != null) {
                        try {
                            sock.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        sock.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            System.out.println("serveUDP(" + jnamed.addrport(addr, port) + "): " + e);
            return;
        }
    }

    public void addTCP(InetAddress addr, int port) {
        Thread t = new Thread(() -> this.serveTCP(addr, port));
        t.start();
    }

    public void addUDP(InetAddress addr, int port) {
        Thread t = new Thread(() -> this.serveUDP(addr, port));
        t.start();
    }

    public static void main(String[] args) {
        if (args.length > 1) {
            System.out.println("usage: jnamed [conf]");
            System.exit(0);
        }
        try {
            String conf = args.length == 1 ? args[0] : "jnamed.conf";
            new jnamed(conf);
        }
        catch (IOException | ZoneTransferException e) {
            System.out.println(e);
        }
    }
}

