/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.msn.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ecf.internal.provider.msn.ui.Activator;
import org.eclipse.ecf.internal.provider.msn.ui.Messages;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class MSNConnectWizardPage
extends WizardPage {
    private Combo emailText;
    private Text passwordText;
    private String username;
    private static Pattern emailPattern = Pattern.compile(".+@.+.[a-z]+");
    private static final String PAGE_SETTINGS;
    private static final int MAX_COMBO_VALUES = 40;
    private static final String COMBO_TEXT_KEY = "connectTextValue";
    private static final String COMBO_BOX_ITEMS_KEY = "comboValues";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.provider.msn.ui.MSNConnectWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_SETTINGS = clazz.getName();
    }

    MSNConnectWizardPage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.provider.msn.ui.MSNConnectWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.setTitle(Messages.MSNConnectWizardPage_Title);
        this.setDescription(Messages.MSNConnectWizardPage_WIZARD_PAGE_DESCRIPTION);
        this.setPageComplete(false);
        this.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_CHAT_WIZARD"));
    }

    MSNConnectWizardPage(String username) {
        this();
        this.username = username;
    }

    private void verify(boolean restorePassword) {
        String email = this.emailText.getText().trim();
        if (email.equals("")) {
            this.setErrorMessage(Messages.MSNConnectWizardPage_EmailAddressRequired);
        } else {
            Matcher matcher = emailPattern.matcher(email);
            if (!matcher.matches()) {
                this.setErrorMessage(Messages.MSNConnectWizardPage_EmailAddressInvalid);
            } else {
                if (restorePassword) {
                    this.restorePassword(email);
                }
                if (this.passwordText.getText().equals("")) {
                    this.setErrorMessage(Messages.MSNConnectWizardPage_PasswordRequired);
                } else {
                    this.setErrorMessage(null);
                }
            }
        }
    }

    private void restorePassword(String username) {
        PasswordCacheHelper pwStorage = new PasswordCacheHelper(username);
        String pw = pwStorage.retrievePassword();
        if (pw != null) {
            this.passwordText.setText(pw);
        }
    }

    private void addListeners() {
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSNConnectWizardPage.this.verify(true);
            }
        });
        this.emailText.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MSNConnectWizardPage.this.verify(true);
            }

            public void widgetSelected(SelectionEvent e) {
                MSNConnectWizardPage.this.verify(true);
            }
        });
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MSNConnectWizardPage.this.verify(false);
            }
        });
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(4, 0x1000000, true, false);
        Label label = new Label(parent, 16384);
        label.setText(Messages.MSNConnectWizardPage_EmailAddressLabel);
        this.emailText = new Combo(parent, 2052);
        this.emailText.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        label.setText(Messages.MSNConnectWizardPage_PasswordLabel);
        this.passwordText = new Text(parent, 0x400804);
        this.passwordText.setLayoutData((Object)data);
        this.addListeners();
        this.restoreCombo();
        if (this.username != null) {
            this.emailText.setText(this.username);
            this.restorePassword(this.username);
            this.passwordText.setFocus();
        }
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    String getEmail() {
        return this.emailText.getText();
    }

    String getPassword() {
        return this.passwordText.getText();
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected void saveComboText() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            pageSettings.put(COMBO_TEXT_KEY, this.emailText.getText());
        }
    }

    protected void saveComboItems() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            String connectTextValue = this.emailText.getText();
            List<String> rawItems = Arrays.asList(this.emailText.getItems());
            ArrayList<String> items = new ArrayList<String>();
            if (!rawItems.contains(connectTextValue)) {
                items.add(connectTextValue);
            }
            items.addAll(rawItems);
            int itemsToSaveLength = items.size();
            if (itemsToSaveLength > 40) {
                itemsToSaveLength = 40;
            }
            String[] itemsToSave = new String[itemsToSaveLength];
            System.arraycopy(items.toArray(new String[0]), 0, itemsToSave, 0, itemsToSaveLength);
            pageSettings.put(COMBO_BOX_ITEMS_KEY, itemsToSave);
        }
    }

    public IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    private IDialogSettings getPageSettings() {
        IDialogSettings pageSettings = null;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            pageSettings = dialogSettings.getSection(PAGE_SETTINGS);
            if (pageSettings == null) {
                pageSettings = dialogSettings.addNewSection(PAGE_SETTINGS);
            }
            return pageSettings;
        }
        return null;
    }

    protected void restoreCombo() {
        IDialogSettings pageSettings = this.getPageSettings();
        if (pageSettings != null) {
            String text;
            String[] items = pageSettings.getArray(COMBO_BOX_ITEMS_KEY);
            if (items != null) {
                this.emailText.setItems(items);
            }
            if ((text = pageSettings.get(COMBO_TEXT_KEY)) != null) {
                this.emailText.setText(text);
            }
        }
    }
}

