/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.IContainerManagerListener;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.ECFPlugin;
import org.eclipse.ecf.internal.core.IDisposable;

public class ContainerFactory
implements IContainerFactory,
IContainerManager {
    public static final String BASE_CONTAINER_NAME = "ecf.base";
    static final Map containerdescriptions = new HashMap();
    static final Map containers = new HashMap();
    static final List managerListeners = new ArrayList();
    private static IContainerFactory instance = null;
    private static volatile boolean init = false;

    static {
        instance = new ContainerFactory();
    }

    public static synchronized IContainerFactory getDefault() {
        if (!init) {
            init = true;
            ECFPlugin.getDefault().initializeExtensions();
        }
        return instance;
    }

    protected ContainerFactory() {
        ECFPlugin.getDefault().addDisposable(new IDisposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                Map map = containers;
                synchronized (map) {
                    Iterator i = containers.keySet().iterator();
                    while (i.hasNext()) {
                        ContainerEntry entry = (ContainerEntry)containers.get(i.next());
                        if (entry == null) continue;
                        IContainer c = entry.getContainer();
                        try {
                            c.dispose();
                        }
                        catch (Throwable e) {
                            ECFPlugin.getDefault().log((IStatus)new Status(4, ECFPlugin.getDefault().getBundle().getSymbolicName(), 4, "container dispose error", e));
                            Trace.catching((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/exceptions/catching", ContainerFactory.class, (String)"doDispose", (Throwable)e);
                        }
                    }
                    containers.clear();
                }
                containerdescriptions.clear();
                managerListeners.clear();
            }
        });
    }

    @Override
    public ContainerTypeDescription addDescription(ContainerTypeDescription containerTypeDescription) {
        return this.addDescription0(containerTypeDescription);
    }

    @Override
    public List getDescriptions() {
        return this.getDescriptions0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getDescriptions0() {
        Map map = containerdescriptions;
        synchronized (map) {
            return new ArrayList(containerdescriptions.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerTypeDescription addDescription0(ContainerTypeDescription containerTypeDescription) {
        if (containerTypeDescription == null) {
            return null;
        }
        Map map = containerdescriptions;
        synchronized (map) {
            return containerdescriptions.put(containerTypeDescription.getName(), containerTypeDescription);
        }
    }

    @Override
    public boolean containsDescription(ContainerTypeDescription containerTypeDescription) {
        return this.containsDescription0(containerTypeDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsDescription0(ContainerTypeDescription containerTypeDescription) {
        if (containerTypeDescription == null) {
            return false;
        }
        Map map = containerdescriptions;
        synchronized (map) {
            return containerdescriptions.containsKey(containerTypeDescription.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerTypeDescription getDescription0(ContainerTypeDescription containerTypeDescription) {
        if (containerTypeDescription == null) {
            return null;
        }
        Map map = containerdescriptions;
        synchronized (map) {
            return (ContainerTypeDescription)containerdescriptions.get(containerTypeDescription.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerTypeDescription getDescription0(String containerTypeDescriptionName) {
        if (containerTypeDescriptionName == null) {
            return null;
        }
        Map map = containerdescriptions;
        synchronized (map) {
            return (ContainerTypeDescription)containerdescriptions.get(containerTypeDescriptionName);
        }
    }

    @Override
    public ContainerTypeDescription getDescriptionByName(String containerTypeDescriptionName) {
        return this.getDescription0(containerTypeDescriptionName);
    }

    @Override
    public ContainerTypeDescription removeDescription(ContainerTypeDescription containerTypeDescription) {
        return this.removeDescription0(containerTypeDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContainerTypeDescription removeDescription0(ContainerTypeDescription containerTypeDescription) {
        if (containerTypeDescription == null) {
            return null;
        }
        Map map = containerdescriptions;
        synchronized (map) {
            return (ContainerTypeDescription)containerdescriptions.remove(containerTypeDescription.getName());
        }
    }

    @Override
    public ContainerTypeDescription[] getDescriptionsForContainerAdapter(Class containerAdapter) {
        if (containerAdapter == null) {
            throw new NullPointerException("containerAdapter cannot be null");
        }
        ArrayList<ContainerTypeDescription> result = new ArrayList<ContainerTypeDescription>();
        List descriptions = this.getDescriptions();
        for (ContainerTypeDescription description : descriptions) {
            String[] supportedAdapters = description.getSupportedAdapterTypes();
            if (supportedAdapters == null) continue;
            int j = 0;
            while (j < supportedAdapters.length) {
                if (supportedAdapters[j].equals(containerAdapter.getName())) {
                    result.add(description);
                }
                ++j;
            }
        }
        return result.toArray(new ContainerTypeDescription[0]);
    }

    protected void throwContainerCreateException(String message, Throwable cause, String method) throws ContainerCreateException {
        ContainerCreateException except = cause == null ? new ContainerCreateException(message) : new ContainerCreateException(message, cause);
        Trace.throwing((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/exceptions/throwing", ContainerFactory.class, (String)method, (Throwable)((Object)except));
        throw except;
    }

    @Override
    public IContainer createContainer() throws ContainerCreateException {
        return this.createContainer(BASE_CONTAINER_NAME);
    }

    @Override
    public IContainer createContainer(ID containerID) throws ContainerCreateException {
        if (containerID == null) {
            return this.createContainer();
        }
        return this.createContainer(BASE_CONTAINER_NAME, new Object[]{containerID});
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription) throws ContainerCreateException {
        return this.createContainer(containerTypeDescription, (Object[])null);
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), (Object[])null);
    }

    private ContainerTypeDescription getDescriptionByNameWithException(String containerTypeDescriptionName) throws ContainerCreateException {
        ContainerTypeDescription typeDescription = this.getDescriptionByName(containerTypeDescriptionName);
        if (typeDescription == null) {
            throw new ContainerCreateException("Container type description with name=" + containerTypeDescriptionName + " not found.  This may indicate that the desired provider is not available or not startable within runtime.");
        }
        return typeDescription;
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, Object[] parameters) throws ContainerCreateException {
        ID containerID;
        ContainerTypeDescription cd;
        String method = "createContainer";
        Trace.entering((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/entering", ContainerFactory.class, (String)method, (Object[])new Object[]{containerTypeDescription, Trace.getArgumentsString((Object[])parameters)});
        if (containerTypeDescription == null) {
            this.throwContainerCreateException("ContainerTypeDescription cannot be null", null, method);
        }
        if ((cd = this.getDescription0(containerTypeDescription)) == null) {
            this.throwContainerCreateException("ContainerTypeDescription '" + containerTypeDescription.getName() + "' not found", null, method);
        }
        IContainerInstantiator instantiator = null;
        try {
            instantiator = cd.getInstantiator();
        }
        catch (Exception e) {
            this.throwContainerCreateException("createContainer cannot get IContainerInstantiator for description : " + containerTypeDescription, e, method);
        }
        IContainer container = instantiator.createInstance(containerTypeDescription, parameters);
        if (container == null) {
            this.throwContainerCreateException("Instantiator returned null for '" + cd.getName() + "'", null, method);
        }
        if ((containerID = container.getID()) != null) {
            this.addContainer(container, cd);
        }
        Trace.exiting((String)"org.eclipse.ecf", (String)"org.eclipse.ecf/debug/methods/exiting", ContainerFactory.class, (String)method, (Object)container);
        return container;
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, Object[] parameters) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), parameters);
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, ID containerID, Object[] parameters) throws ContainerCreateException {
        if (containerID == null) {
            return this.createContainer(containerTypeDescription, parameters);
        }
        Object[] params = parameters == null || parameters.length == 0 ? new Object[1] : new Object[parameters.length + 1];
        params[0] = containerID;
        if (parameters != null && parameters.length != 0) {
            System.arraycopy(parameters, 0, params, 1, parameters.length);
        }
        return this.createContainer(containerTypeDescription, params);
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, ID containerID, Object[] parameters) throws ContainerCreateException {
        if (containerID == null) {
            return this.createContainer(containerTypeDescriptionName, parameters);
        }
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), containerID, parameters);
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, ID containerID) throws ContainerCreateException {
        if (containerID == null) {
            return this.createContainer(containerTypeDescription);
        }
        return this.createContainer(containerTypeDescription, new Object[]{containerID});
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, ID containerID) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), new Object[]{containerID});
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, String containerId) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), containerId);
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, String containerId, Object[] parameters) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), containerId, parameters);
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, String containerId) throws ContainerCreateException {
        return this.createContainer(containerTypeDescription, containerId, (Object[])null);
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, String containerId, Object[] parameters) throws ContainerCreateException {
        if (containerId == null) {
            return this.createContainer(containerTypeDescription, parameters);
        }
        Object[] params = parameters == null || parameters.length == 0 ? new Object[1] : new Object[parameters.length + 1];
        params[0] = containerId;
        if (parameters != null && parameters.length != 0) {
            System.arraycopy(parameters, 0, params, 1, parameters.length);
        }
        return this.createContainer(containerTypeDescription, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContainer[] getAllContainers() {
        ArrayList<IContainer> containerValues = new ArrayList<IContainer>();
        Map map = containers;
        synchronized (map) {
            Collection containerEntrys = containers.values();
            for (ContainerEntry entry : containerEntrys) {
                containerValues.add(entry.getContainer());
            }
        }
        return containerValues.toArray(new IContainer[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContainer getContainer(ID containerID) {
        if (containerID == null) {
            return null;
        }
        Map map = containers;
        synchronized (map) {
            ContainerEntry entry;
            block5: {
                entry = (ContainerEntry)containers.get(containerID);
                if (entry != null) break block5;
                return null;
            }
            return entry.getContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasContainer(ID containerID) {
        Assert.isNotNull((Object)containerID);
        Map map = containers;
        synchronized (map) {
            return containers.containsKey(containerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(IContainerManagerListener listener) {
        Assert.isNotNull((Object)listener);
        List list = managerListeners;
        synchronized (list) {
            return managerListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(IContainerManagerListener listener) {
        Assert.isNotNull((Object)listener);
        List list = managerListeners;
        synchronized (list) {
            return managerListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContainer addContainer(IContainer container, ContainerTypeDescription typeDescription) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)typeDescription);
        ID containerID = container.getID();
        Assert.isNotNull((Object)containerID, (String)"Container ID cannot be null");
        ContainerEntry result = null;
        Map map = containers;
        synchronized (map) {
            result = containers.put(containerID, new ContainerEntry(container, typeDescription));
        }
        if (result == null) {
            this.fireContainerAdded(container);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContainerAdded(IContainer result) {
        ArrayList toNotify = null;
        List list = managerListeners;
        synchronized (list) {
            toNotify = new ArrayList(managerListeners);
        }
        for (IContainerManagerListener cml : toNotify) {
            cml.containerAdded(result);
        }
    }

    @Override
    public IContainer removeContainer(IContainer container) {
        Assert.isNotNull((Object)container);
        ID containerID = container.getID();
        if (containerID == null) {
            return null;
        }
        return this.removeContainer(containerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IContainer removeContainer(ID containerID) {
        Assert.isNotNull((Object)containerID);
        ContainerEntry result = null;
        Map map = containers;
        synchronized (map) {
            result = (ContainerEntry)containers.remove(containerID);
        }
        IContainer resultContainer = null;
        if (result != null) {
            resultContainer = result.getContainer();
            this.fireContainerRemoved(resultContainer);
        }
        return resultContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContainerRemoved(IContainer result) {
        ArrayList toNotify = null;
        List list = managerListeners;
        synchronized (list) {
            toNotify = new ArrayList(managerListeners);
        }
        for (IContainerManagerListener cml : toNotify) {
            cml.containerRemoved(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerTypeDescription getContainerTypeDescription(ID containerID) {
        if (containerID == null) {
            return null;
        }
        Map map = containers;
        synchronized (map) {
            ContainerEntry entry;
            block5: {
                entry = (ContainerEntry)containers.get(containerID);
                if (entry != null) break block5;
                return null;
            }
            return entry.getContainerTypeDescription();
        }
    }

    @Override
    public IContainerFactory getContainerFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllContainers() {
        Map map = containers;
        synchronized (map) {
            Iterator i = containers.keySet().iterator();
            while (i.hasNext()) {
                ID key = (ID)i.next();
                ContainerEntry entry = (ContainerEntry)containers.get(key);
                i.remove();
                this.fireContainerRemoved(entry.getContainer());
            }
        }
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, ID containerID, Map parameters) throws ContainerCreateException {
        if (containerID == null) {
            return this.createContainer(containerTypeDescription, parameters);
        }
        if (parameters == null) {
            return this.createContainer(containerTypeDescription, containerID);
        }
        return this.createContainer(containerTypeDescription, new Object[]{containerID, parameters});
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, String containerId, Map parameters) throws ContainerCreateException {
        if (containerId == null) {
            return this.createContainer(containerTypeDescription, parameters);
        }
        if (parameters == null) {
            return this.createContainer(containerTypeDescription, containerId);
        }
        return this.createContainer(containerTypeDescription, new Object[]{containerId, parameters});
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, ID containerID, Map parameters) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), containerID, parameters);
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, String containerId, Map parameters) throws ContainerCreateException {
        return this.createContainer(this.getDescriptionByNameWithException(containerTypeDescriptionName), containerId, parameters);
    }

    @Override
    public IContainer createContainer(ContainerTypeDescription containerTypeDescription, Map parameters) throws ContainerCreateException {
        if (parameters == null) {
            return this.createContainer(containerTypeDescription);
        }
        return this.createContainer(containerTypeDescription, new Object[]{parameters});
    }

    @Override
    public IContainer createContainer(String containerTypeDescriptionName, Map parameters) throws ContainerCreateException {
        if (parameters == null) {
            return this.createContainer(containerTypeDescriptionName);
        }
        return this.createContainer(containerTypeDescriptionName, new Object[]{parameters});
    }

    class ContainerEntry {
        private final IContainer container;
        private final ContainerTypeDescription typeDescription;

        public ContainerEntry(IContainer container, ContainerTypeDescription typeDescription) {
            this.container = container;
            this.typeDescription = typeDescription;
        }

        public IContainer getContainer() {
            return this.container;
        }

        public ContainerTypeDescription getContainerTypeDescription() {
            return this.typeDescription;
        }
    }
}

