/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ServicePropertiesPropertySource
implements IPropertySource,
IPropertySource2 {
    List propertyDescriptors = new ArrayList();

    private String createStringFromBytes(byte[] bytes) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < bytes.length) {
            buf.append(bytes[i]);
            if (i + 1 != bytes.length) {
                buf.append(",");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public ServicePropertiesPropertySource(IServiceProperties serviceProperties) {
        Enumeration e = serviceProperties.getPropertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = null;
            Object val = serviceProperties.getProperty(key);
            if (val != null) {
                value = val instanceof String ? (String)val : (val instanceof byte[] ? this.createStringFromBytes((byte[])val) : val.toString());
            }
            this.propertyDescriptors.add(new ServicePropertyDescriptor(key, value));
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        ServicePropertyDescriptor desc = this.findServicePropertyDescriptor(id);
        if (desc != null) {
            return desc.getValue();
        }
        return null;
    }

    private ServicePropertyDescriptor findServicePropertyDescriptor(Object id) {
        Iterator i = this.propertyDescriptors.iterator();
        while (i.hasNext()) {
            ServicePropertyDescriptor desc = (ServicePropertyDescriptor)((Object)i.next());
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    class ServicePropertyDescriptor
    extends TextPropertyDescriptor {
        String value;

        public ServicePropertyDescriptor(String name, String value) {
            super((Object)name, name);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

