/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.ui.MultiRosterAccount;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.deferred.DeferredContentProvider;
import org.eclipse.jface.viewers.deferred.SetModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ChatRoomSelectionDialog
extends TitleAreaDialog {
    private static final int X_INITIAL_SIZE = 640;
    private static final int Y_INITIAL_SIZE = 400;
    private Room loadingRoom = new Room();
    MultiRosterAccount[] accounts = null;
    private Room selectedRoom = null;
    private Job roomRetrieveJob = null;
    private SetModel rooms = new SetModel();

    public ChatRoomSelectionDialog(Shell parentShell, MultiRosterAccount[] accounts) {
        super(parentShell);
        this.accounts = accounts;
        this.setTitleImage(SharedImages.getImage((String)"IMG_CHAT_WIZARD"));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(640, 400, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = new TableViewer(main, 0x10010B00);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_ROOM_NAME_COLUMN);
        tc.setWidth(213);
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_SUBJECT_COLUMN);
        tc.pack();
        int width = tc.getWidth();
        tc.setWidth(width + width / 4);
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_DESCRIPTION_COLUMN);
        tc.pack();
        width = tc.getWidth();
        tc.setWidth(width + width / 4);
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_MEMBERS_COLUMN);
        tc.pack();
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_MODERATED_COLUMN);
        tc.pack();
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_PERSISTENT_COLUMN);
        tc.pack();
        tc = new TableColumn(table, 0);
        tc.setText(Messages.ChatRoomSelectionDialog_ACCOUNT_COLUMN);
        tc.pack();
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement;
                ISelection selection = event.getSelection();
                IStructuredSelection ss = (IStructuredSelection)(selection instanceof IStructuredSelection ? selection : null);
                Object object = firstElement = ss == null ? null : ss.getFirstElement();
                if (!event.getSelection().isEmpty() && !ChatRoomSelectionDialog.this.loadingRoom.equals(firstElement)) {
                    ChatRoomSelectionDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        viewer.setContentProvider((IContentProvider)new DeferredContentProvider(new Comparator(){

            public int compare(Object r1, Object r2) {
                Room room1 = (Room)r1;
                Room room2 = (Room)r2;
                return room1.getRoomInfo().getName().compareTo(room2.getRoomInfo().getName());
            }
        }));
        viewer.setLabelProvider((IBaseLabelProvider)new ChatRoomLabelProvider());
        this.rooms.addAll(Arrays.asList(this.loadingRoom));
        viewer.setInput((Object)this.rooms);
        this.setTitle(Messages.ChatRoomSelectionDialog_TITLE);
        this.setMessage(Messages.ChatRoomSelectionDialog_MESSAGE);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection s = (IStructuredSelection)e.getSelection();
                Object o = s.getFirstElement();
                if (o instanceof Room) {
                    ChatRoomSelectionDialog.this.selectedRoom = (Room)o;
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ChatRoomSelectionDialog.this.selectedRoom != null) {
                    ChatRoomSelectionDialog.this.okPressed();
                }
            }
        });
        this.startRetrieveJob();
        ChatRoomSelectionDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void startRetrieveJob() {
        this.roomRetrieveJob = new Job("Chat Room Retrieve"){

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<Room> add = new ArrayList<Room>();
                int i = 0;
                while (i < ChatRoomSelectionDialog.this.accounts.length) {
                    IChatRoomManager chatRoomManager = ChatRoomSelectionDialog.this.accounts[i].getPresenceContainerAdapter().getChatRoomManager();
                    if (chatRoomManager != null) {
                        try {
                            IChatRoomInfo[] infos = chatRoomManager.getChatRoomInfos();
                            if (infos != null) {
                                int j = 0;
                                while (j < infos.length) {
                                    if (infos[j] != null && ChatRoomSelectionDialog.this.accounts[i] != null) {
                                        add.add(new Room(infos[j], ChatRoomSelectionDialog.this.accounts[i]));
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ChatRoomSelectionDialog.this.rooms.removeAll((Object[])new Room[]{ChatRoomSelectionDialog.this.loadingRoom});
                ChatRoomSelectionDialog.this.rooms.addAll(add);
                return Status.OK_STATUS;
            }
        };
        this.roomRetrieveJob.schedule();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setText(Messages.ChatRoomSelectionDialog_ENTER_CHAT_BUTTON_TEXT);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    public Room getSelectedRoom() {
        return this.selectedRoom;
    }

    public boolean close() {
        if (this.roomRetrieveJob != null) {
            this.roomRetrieveJob.cancel();
            this.roomRetrieveJob = null;
            this.rooms.clear();
        }
        return super.close();
    }

    private class ChatRoomLabelProvider
    implements ITableLabelProvider {
        private ChatRoomLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Room room = (Room)element;
            IChatRoomInfo info = room.getRoomInfo();
            MultiRosterAccount account = room.getAccount();
            switch (columnIndex) {
                case 0: {
                    return info.getName();
                }
                case 1: {
                    return info.getSubject();
                }
                case 2: {
                    return info.getDescription();
                }
                case 3: {
                    return account == null ? null : String.valueOf(info.getParticipantsCount());
                }
                case 4: {
                    return account == null ? null : String.valueOf(info.isModerated());
                }
                case 5: {
                    return account == null ? null : String.valueOf(info.isPersistent());
                }
                case 6: {
                    return account == null ? null : account.getContainer().getConnectedID().getName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public class Room {
        IChatRoomInfo info;
        MultiRosterAccount account;

        public Room() {
            this.info = new IChatRoomInfo(){

                public IChatRoomContainer createChatRoomContainer() throws ContainerCreateException {
                    return null;
                }

                public ID getConnectedID() {
                    return null;
                }

                public String getDescription() {
                    return null;
                }

                public String getName() {
                    return "Retrieving chat room list from servers...";
                }

                public int getParticipantsCount() {
                    return 0;
                }

                public ID getRoomID() {
                    return null;
                }

                public String getSubject() {
                    return null;
                }

                public boolean isModerated() {
                    return false;
                }

                public boolean isPersistent() {
                    return false;
                }

                public boolean requiresPassword() {
                    return false;
                }

                public Object getAdapter(Class adapter) {
                    return null;
                }
            };
        }

        public Room(IChatRoomInfo info, MultiRosterAccount man) {
            this.info = info;
            this.account = man;
        }

        public IChatRoomInfo getRoomInfo() {
            return this.info;
        }

        public MultiRosterAccount getAccount() {
            return this.account;
        }
    }
}

