/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.pror.editor.IReqifEditor;
import org.eclipse.rmf.reqif10.search.filter.IFilter;
import org.eclipse.rmf.reqif10.search.filter.SimpleCompoundFilter;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterPanel;
import org.eclipse.rmf.reqif10.search.filter.ui.FilterSearchQuery;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchUIPlugin;
import org.eclipse.rmf.reqif10.search.ui.UsageSearchResult;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ReqIFSearchPage
extends DialogPage
implements ISearchPage {
    private static Map<ReqIF, SimpleCompoundFilter> lastSearches = new HashMap<ReqIF, SimpleCompoundFilter>();
    private Composite pane;
    private Button and;
    private Button or;
    private ReqIF reqif;
    private static IPartListener2 listener;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.setControl((Control)parent);
        ReqIF reqIF = this.reqif = this.getReqifEditor() != null ? this.getReqifEditor().getReqif() : null;
        if (this.reqif == null) {
            this.createNoSearchMessage(parent);
            return;
        }
        Composite toolbar = this.createToolbar(parent);
        this.createAndButton(toolbar);
        this.createOrButton(toolbar);
        this.createAddButton(toolbar);
        this.createClearButton(toolbar);
        this.pane = this.createPane(parent);
        this.restoreFilter();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.rmf.reqif10.search.ui.reqifSearchHelp");
        this.attachPartListener();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.pane.setFocus();
    }

    private void createNoSearchMessage(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Please activate a ReqIF Editor before starting search.");
        label.setLayoutData((Object)new GridData(2, 0x1000000, true, true));
    }

    private Composite createToolbar(Composite parent) {
        Composite toolbar = new Composite(parent, 0);
        toolbar.setLayout((Layout)new GridLayout(4, false));
        toolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return toolbar;
    }

    private void createAndButton(Composite toolbar) {
        this.and = new Button(toolbar, 16);
        this.and.setText("Match all");
        this.and.setSelection(true);
    }

    private void createOrButton(Composite toolbar) {
        this.or = new Button(toolbar, 16);
        this.or.setText("Match any");
    }

    private void createClearButton(Composite toolbar) {
        Button clear = new Button(toolbar, 8);
        clear.setText("Clear");
        clear.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control[] controlArray = ReqIFSearchPage.this.pane.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
                ReqIFSearchPage.this.pane.pack();
            }
        });
    }

    private void createAddButton(Composite toolbar) {
        Button add = new Button(toolbar, 8);
        add.setText("Add new");
        add.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterPanel filterPanel = new FilterPanel(ReqIFSearchPage.this.pane, ReqIFSearchPage.this.reqif);
                filterPanel.setLayoutData(new GridData(4, 0x1000000, true, false));
                ReqIFSearchPage.this.pane.pack();
            }
        });
    }

    private Composite createPane(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 512);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        sc.setBackground(parent.getBackground());
        Composite pane = new Composite((Composite)sc, 0);
        pane.setLayout((Layout)new GridLayout());
        sc.setContent((Control)pane);
        sc.setExpandHorizontal(true);
        return pane;
    }

    private void restoreFilter() {
        SimpleCompoundFilter wrapperFilter = lastSearches.get(this.reqif);
        if (wrapperFilter == null) {
            return;
        }
        this.or.setSelection(wrapperFilter.isOrFilter());
        this.and.setSelection(!wrapperFilter.isOrFilter());
        for (IFilter filter : wrapperFilter.getFilters()) {
            FilterPanel filterPanel = new FilterPanel(this.pane, this.reqif, filter);
            filterPanel.setLayoutData(new GridData(4, 0x1000000, true, false));
        }
        this.pane.pack();
    }

    private IReqifEditor getReqifEditor() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof IReqifEditor) {
            return (IReqifEditor)editor;
        }
        return null;
    }

    public boolean performAction() {
        SimpleCompoundFilter filter = this.getFilter();
        if (filter == null || filter.getFilters().size() == 0) {
            return false;
        }
        lastSearches.put(this.reqif, filter);
        FilterSearchQuery query = new FilterSearchQuery(this.reqif, (IFilter)filter);
        NewSearchUI.runQueryInForeground((IRunnableContext)new ProgressMonitorDialog(this.getShell()), (ISearchQuery)query);
        this.getSearchView().showSearchResult(query.getSearchResult());
        return true;
    }

    private SearchView getSearchView() {
        SearchView searchView = null;
        try {
            searchView = (SearchView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.search.ui.views.SearchView");
        }
        catch (PartInitException e) {
            ReqIFSearchUIPlugin.INSTANCE.log((Object)e);
        }
        return searchView;
    }

    public void dispose() {
        if (this.getFilter() != null) {
            lastSearches.put(this.reqif, this.getFilter());
        }
        super.dispose();
    }

    private SimpleCompoundFilter getFilter() {
        if (this.pane == null) {
            return null;
        }
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        Control[] controlArray = this.pane.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFilter filter;
            Control control = controlArray[n2];
            if (control instanceof FilterPanel && (filter = ((FilterPanel)control).getFilter()) != null) {
                filters.add(filter);
            }
            ++n2;
        }
        return new SimpleCompoundFilter(filters, this.or.getSelection());
    }

    public void setContainer(ISearchPageContainer container) {
    }

    private void attachPartListener() {
        if (listener != null) {
            return;
        }
        listener = new IPartListener2(){

            public void partClosed(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (!(part instanceof IReqifEditor)) {
                    return;
                }
                ReqIF closingReqif = ((IReqifEditor)part).getReqif();
                ISearchResult searchResult = ReqIFSearchPage.this.getSearchView().getCurrentSearchResult();
                if (searchResult instanceof UsageSearchResult) {
                    Set<Resource> keys = ((UsageSearchResult)searchResult).getSearchEntries().keySet();
                    for (Resource resource : keys) {
                        if (!resource.getURI().equals(closingReqif.eResource().getURI())) continue;
                        ReqIFSearchPage.this.getSearchView().showEmptySearchPage(partRef.getId());
                        return;
                    }
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        System.out.println("Attaching listener.");
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(listener);
    }
}

