/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.editor.ISpecificationEditor;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchResultPage;
import org.eclipse.rmf.reqif10.search.ui.UsageSearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class ResultNavigator
implements IEditorActionDelegate,
IExecutableExtension {
    static final String NEXT_ID = "org.eclipse.rmf.reqif10.search.next";
    static final String PREV_ID = "org.eclipse.rmf.reqif10.search.prev";
    private Specification spec;
    private SpecHierarchy selectedSpecHierarchy;
    private ISpecificationEditor editor;

    public void run(IAction action) {
        this.editor.setFocus();
        SpecHierarchy match = null;
        if (action.getId().equals(NEXT_ID)) {
            match = this.next();
        } else if (action.getId().equals(PREV_ID)) {
            match = this.prev();
        } else {
            throw new IllegalStateException("" + action);
        }
        if (match != null) {
            StructuredSelection selection = new StructuredSelection((Object)match);
            this.editor.getSite().getSelectionProvider().setSelection((ISelection)selection);
        } else {
            MessageDialog.openInformation((Shell)this.editor.getSite().getShell(), (String)"No more elements", (String)"No more elements in this direction.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof SpecHierarchy)) {
            action.setEnabled(false);
            return;
        }
        action.setEnabled(this.specInSearchResult());
        this.selectedSpecHierarchy = (SpecHierarchy)element;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ISpecificationEditor) {
            this.editor = (ISpecificationEditor)targetEditor;
            this.spec = ((ISpecificationEditor)targetEditor).getSpecification();
        } else {
            this.spec = null;
            this.editor = null;
        }
    }

    private boolean specInSearchResult() {
        for (SpecHierarchy sh : this.getMatchingSpecsHierarchies()) {
            Specification s = this.getSpecForSpecHierarchy(sh);
            if (s != this.spec) continue;
            return true;
        }
        return false;
    }

    private Set<SpecHierarchy> getMatchingSpecsHierarchies() {
        HashSet<SpecHierarchy> set = new HashSet<SpecHierarchy>();
        ISearchResultViewPart view = NewSearchUI.getSearchResultView();
        if (view != null && view.getActivePage() instanceof ReqIFSearchResultPage) {
            ReqIFSearchResultPage page = (ReqIFSearchResultPage)view.getActivePage();
            UsageSearchResult result = page.getSearchResult();
            Collection<EObject> entries = result.getSearchEntries().get(this.spec.eResource());
            if (entries == null) {
                return set;
            }
            for (EObject entry : entries) {
                if (!(entry instanceof SpecHierarchy)) continue;
                set.add((SpecHierarchy)entry);
            }
        }
        return set;
    }

    private Specification getSpecForSpecHierarchy(SpecHierarchy entry) {
        while (true) {
            if (entry.eContainer() instanceof Specification) {
                return (Specification)entry.eContainer();
            }
            if (!(entry.eContainer() instanceof SpecHierarchy)) break;
            entry = (SpecHierarchy)entry.eContainer();
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private SpecHierarchy next() {
        Set<SpecHierarchy> bag = this.getMatchingSpecsHierarchies();
        SpecHierarchy next = this.oneDown(this.selectedSpecHierarchy);
        while (next != null) {
            if (bag.contains(next)) {
                return next;
            }
            next = this.oneDown(next);
        }
        return null;
    }

    private SpecHierarchy oneDown(SpecHierarchy sh) {
        if (sh.getChildren().size() > 0) {
            return (SpecHierarchy)sh.getChildren().get(0);
        }
        SpecHierarchy element = sh;
        while (element instanceof SpecHierarchy) {
            EObject container = element.eContainer();
            int pos = this.getSpecHierarchies(container).indexOf((Object)element);
            if (pos < this.getSpecHierarchies(container).size() - 1) {
                return (SpecHierarchy)this.getSpecHierarchies(container).get(pos + 1);
            }
            element = container;
        }
        return null;
    }

    private SpecHierarchy prev() {
        Set<SpecHierarchy> bag = this.getMatchingSpecsHierarchies();
        SpecHierarchy next = this.oneUp(this.selectedSpecHierarchy);
        while (next != null) {
            if (bag.contains(next)) {
                return next;
            }
            next = this.oneUp(next);
        }
        return null;
    }

    private SpecHierarchy oneUp(SpecHierarchy sh) {
        SpecHierarchy element = sh;
        if (element instanceof SpecHierarchy) {
            EObject container = element.eContainer();
            if (!(container instanceof SpecHierarchy) && !(container instanceof Specification)) {
                return null;
            }
            int pos = this.getSpecHierarchies(container).indexOf((Object)element);
            if (pos > 0) {
                sh = (SpecHierarchy)this.getSpecHierarchies(container).get(pos - 1);
                while (sh.getChildren().size() > 0) {
                    sh = (SpecHierarchy)sh.getChildren().get(sh.getChildren().size() - 1);
                }
                return sh;
            }
            if (container instanceof SpecHierarchy) {
                return (SpecHierarchy)container;
            }
            return null;
        }
        return null;
    }

    private EList<SpecHierarchy> getSpecHierarchies(EObject eObject) {
        if (eObject instanceof SpecHierarchy) {
            return ((SpecHierarchy)eObject).getChildren();
        }
        if (eObject instanceof Specification) {
            return ((Specification)eObject).getChildren();
        }
        return null;
    }
}

