/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages;

import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rmf.reqif10.csv.importer.mapping.MappingFactory;
import org.eclipse.rmf.reqif10.csv.importer.mapping.MappingItem;
import org.eclipse.rmf.reqif10.csv.importer.mapping.MappingLibrary;
import org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages.LeftMappingPart;
import org.eclipse.rmf.reqif10.csv.importer.ui.wizards.pages.RightMappingPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CSVMappingWizardPage
extends WizardPage {
    private LeftMappingPart leftMappingPart;
    private RightMappingPart rightMappingPart;
    private MappingLibrary mappingLibrary;

    public CSVMappingWizardPage() {
        super("Mapping Wizard Page");
        this.setTitle("Mapping Wizard Page");
        this.setDescription("Mapping Wizard Page");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(composite, 0);
        this.mappingLibrary = MappingFactory.eINSTANCE.createMappingLibrary();
        this.leftMappingPart = new LeftMappingPart((Composite)sashForm, this.mappingLibrary);
        Composite rightMappingPartContainer = new Composite((Composite)sashForm, 0);
        rightMappingPartContainer.setLayout((Layout)new FillLayout());
        this.rightMappingPart = new RightMappingPart(rightMappingPartContainer, this.leftMappingPart.getEditingDomain());
        this.rightMappingPart.setVisible(false);
        this.leftMappingPart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean visible = false;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof MappingItem) {
                    CSVMappingWizardPage.this.rightMappingPart.selectionChanged(event.getSelection());
                    visible = true;
                }
                CSVMappingWizardPage.this.rightMappingPart.setVisible(visible);
            }
        });
        this.leftMappingPart.getEditingDomain().getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                CSVMappingWizardPage.this.validatePage();
            }
        });
        sashForm.setWeights(new int[]{45, 55});
        this.validatePage();
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        this.setPageComplete(false);
        boolean valid = true;
        EList<MappingItem> items = this.mappingLibrary.getItems();
        if (items.isEmpty()) {
            this.setErrorMessage("At least one mapping item must be exist");
            valid = false;
        }
        for (MappingItem mappingItem : items) {
            String errorMessage = "";
            if (mappingItem.getColumnId().isEmpty()) {
                errorMessage = "A mapping item have an empty column id";
            } else if (this.containsDuplicateColumnId(mappingItem.getColumnId(), items)) {
                errorMessage = "Several mapping item have a column id as " + mappingItem.getColumnId();
            } else if (mappingItem.getAttributeName().isEmpty()) {
                errorMessage = "A mapping item have an empty attribute name";
            } else if (this.containsDuplicateAttributeName(mappingItem.getAttributeName(), items)) {
                errorMessage = "Several mapping item have a attribute name as " + mappingItem.getAttributeName();
            }
            if (errorMessage.isEmpty()) continue;
            this.setErrorMessage(errorMessage);
            valid = false;
        }
        if (valid) {
            this.setPageComplete(true);
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    private boolean containsDuplicateColumnId(String columnId, EList<MappingItem> items) {
        int count = 0;
        for (MappingItem item : items) {
            if (!columnId.equals(item.getColumnId())) continue;
            if (count == 1) {
                return true;
            }
            ++count;
        }
        return false;
    }

    private boolean containsDuplicateAttributeName(String name, EList<MappingItem> items) {
        int count = 0;
        for (MappingItem item : items) {
            if (!name.equals(item.getAttributeName())) continue;
            if (count == 1) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void setColumnMappingInput(List<String> columnIDS) {
        this.rightMappingPart.setColumnMappingInput(columnIDS);
    }

    public MappingLibrary getMappingLibrary() {
        return this.mappingLibrary;
    }
}

