/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecRelationType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.AgileCellEditorActionHandler;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.editor.presentation.SpecificationEditor;
import org.eclipse.rmf.reqif10.pror.filter.ReqifFilter;
import org.eclipse.rmf.reqif10.pror.filter.SimpleStringFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reqif10ActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    private AgileCellEditorActionHandler agileCellEditorActionHandler;
    private List<SpecObject> linkSelection = new ArrayList<SpecObject>();
    private List<SpecObject> linkSource = new ArrayList<SpecObject>();
    protected IAction showPropertiesViewAction = new Action(Reqif10EditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                Reqif10ActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                Reqif10EditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(Reqif10EditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return Reqif10ActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (Reqif10ActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)Reqif10ActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    private Text quicksearch;

    public Reqif10ActionBarContributor() {
        super(1);
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        this.agileCellEditorActionHandler = new AgileCellEditorActionHandler(actionBars);
        this.agileCellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.agileCellEditorActionHandler.setCutAction((IAction)this.cutAction);
        this.agileCellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.agileCellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.agileCellEditorActionHandler.setUndoAction((IAction)this.undoAction);
        this.agileCellEditorActionHandler.setRedoAction((IAction)this.redoAction);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("reqif10-settings"));
        toolBarManager.add((IContributionItem)new Separator("reqif10-additions"));
        toolBarManager.add(this.createQuickSearchToolbar());
    }

    private IContributionItem createQuickSearchToolbar() {
        return new ControlContribution("quicksearch"){
            private int width;
            private final int FIELD_SIZE = 25;
            {
                this.width = -1;
                this.FIELD_SIZE = 25;
            }

            protected Control createControl(Composite parent) {
                return Reqif10ActionBarContributor.this.createQuickSearchControl(parent);
            }

            protected int computeWidth(Control control) {
                if (this.width == -1) {
                    GC gc = new GC((Drawable)control);
                    FontMetrics fm = gc.getFontMetrics();
                    this.width = 25 * fm.getAverageCharWidth();
                }
                return this.width;
            }
        };
    }

    private Control createQuickSearchControl(Composite parent) {
        this.quicksearch = new Text(parent, 896);
        this.quicksearch.setSize(500, 0);
        this.quicksearch.setEnabled(this.activeEditorPart instanceof SpecificationEditor);
        this.quicksearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Reqif10ActionBarContributor.this.activeEditorPart instanceof SpecificationEditor) {
                    Reqif10ActionBarContributor.this.quicksearch.setEnabled(true);
                    SpecificationEditor specEditor = (SpecificationEditor)Reqif10ActionBarContributor.this.activeEditor;
                    String text = Reqif10ActionBarContributor.this.quicksearch.getText();
                    if (text == null || "".equals(text)) {
                        specEditor.setFilter(null);
                    } else {
                        SimpleStringFilter filter = new SimpleStringFilter(text);
                        specEditor.setFilter((ReqifFilter)filter);
                    }
                } else {
                    Reqif10ActionBarContributor.this.quicksearch.setEnabled(false);
                }
            }
        });
        return this.quicksearch;
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10Editor_menu"), "org.eclipse.rmf.reqif10MenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.quicksearch != null && !this.quicksearch.isDisposed()) {
            this.quicksearch.setText("");
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
        this.saveLinkingSelection(selection);
    }

    private void saveLinkingSelection(ISelection selection) {
        this.linkSelection.clear();
        if (selection instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof SpecObject) {
                    this.linkSelection.add((SpecObject)obj);
                }
                if (!(obj instanceof SpecHierarchy)) continue;
                SpecObject specObject = ((SpecHierarchy)obj).getObject();
                if (obj == null) continue;
                this.linkSelection.add(specObject);
            }
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        this.buildLinkMenuEntries(menuManager);
    }

    private void buildLinkMenuEntries(IMenuManager menuManager) {
        if (this.linkSelection.isEmpty()) {
            return;
        }
        menuManager.insertAfter("edit", (IContributionItem)new Separator());
        ImageDescriptor toIcon = ExtendedImageRegistry.INSTANCE.getImageDescriptor(Reqif10EditorPlugin.INSTANCE.getImage("full/obj16/SpecRelationTo.png"));
        ImageDescriptor fromIcon = ExtendedImageRegistry.INSTANCE.getImageDescriptor(Reqif10EditorPlugin.INSTANCE.getImage("full/obj16/SpecRelationFrom.png"));
        if (!this.linkSource.isEmpty()) {
            MenuManager submenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_Action_Complete_Linking_From", new String[]{String.valueOf(this.linkSource.size())}), fromIcon, "_Action_Complete_Linking_From");
            this.populateLinkMenu((IContributionManager)submenuManager, this.linkSelection, this.linkSource);
            menuManager.insertAfter("edit", (IContributionItem)submenuManager);
            submenuManager = new MenuManager(Reqif10EditorPlugin.INSTANCE.getString("_Action_Complete_Linking_To", new String[]{String.valueOf(this.linkSource.size())}), toIcon, "_Action_Complete_Linking_To");
            this.populateLinkMenu((IContributionManager)submenuManager, this.linkSource, this.linkSelection);
            menuManager.insertAfter("edit", (IContributionItem)submenuManager);
        }
        Action action = new Action(Reqif10EditorPlugin.INSTANCE.getString("_Action_Initiate_Linking", new String[]{String.valueOf(this.linkSelection.size())})){

            public void run() {
                Reqif10ActionBarContributor.this.linkSource.clear();
                Reqif10ActionBarContributor.this.linkSource.addAll(Reqif10ActionBarContributor.this.linkSelection);
            }
        };
        menuManager.insertAfter("edit", (IAction)action);
    }

    private void populateLinkMenu(IContributionManager manager, List<SpecObject> source, List<SpecObject> target) {
        EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
        ReqIFContent coreContent = ReqIF10Util.getReqIF((Object)this.linkSource.get(0)).getCoreContent();
        manager.add(this.createLinkCommand(source, target, domain, coreContent, null));
        for (SpecType type : coreContent.getSpecTypes()) {
            if (!(type instanceof SpecRelationType)) continue;
            manager.add(this.createLinkCommand(source, target, domain, coreContent, (SpecRelationType)type));
        }
    }

    private IAction createLinkCommand(List<SpecObject> source, List<SpecObject> target, final EditingDomain domain, ReqIFContent coreContent, SpecRelationType type) {
        String label;
        if (type == null) {
            label = Reqif10EditorPlugin.INSTANCE.getString("_Action_SpecRelation_Untyped");
        } else {
            String typeName = type.getLongName();
            if (typeName == null) {
                typeName = type.getIdentifier();
            }
            label = Reqif10EditorPlugin.INSTANCE.getString("_Action_SpecRelation_Typed", new String[]{typeName});
        }
        final CompoundCommand cmd = new CompoundCommand(label);
        for (SpecObject sourceObject : source) {
            for (SpecObject targetObject : target) {
                SpecRelation specRelation = ReqIF10Factory.eINSTANCE.createSpecRelation();
                specRelation.setSource(sourceObject);
                specRelation.setTarget(targetObject);
                specRelation.setType(type);
                cmd.append(AddCommand.create((EditingDomain)domain, (Object)coreContent, (Object)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_RELATIONS, (Object)specRelation));
            }
        }
        return new Action(label){

            public void run() {
                domain.getCommandStack().execute((Command)cmd);
            }
        };
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public AgileCellEditorActionHandler getAgileCellEditorActionHandler() {
        return this.agileCellEditorActionHandler;
    }
}

