/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Documentation;
import org.eclipse.acceleo.DocumentedElement;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.ErrorBinding;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorExpressionStatement;
import org.eclipse.acceleo.ErrorFileStatement;
import org.eclipse.acceleo.ErrorForStatement;
import org.eclipse.acceleo.ErrorIfStatement;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorLetStatement;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.ErrorModule;
import org.eclipse.acceleo.ErrorModuleDocumentation;
import org.eclipse.acceleo.ErrorModuleElementDocumentation;
import org.eclipse.acceleo.ErrorModuleReference;
import org.eclipse.acceleo.ErrorProtectedArea;
import org.eclipse.acceleo.ErrorQuery;
import org.eclipse.acceleo.ErrorTemplate;
import org.eclipse.acceleo.ErrorVariable;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LeafStatement;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleDocumentation;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.NewLineStatement;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.ParameterDocumentation;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.VisibilityKind;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.Positions;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class AcceleoParser {
    public static final String SPACE = " ";
    public static final String ACCELEOENV_URI_PROTOCOL = "acceleoenv::";
    public static final String MODULE_FILE_EXTENSION = "mtl";
    public static final String NO_SLASH_END = "]";
    public static final String SLASH_END = "/]";
    public static final String TEXT_END = "[";
    public static final String EMPTY_EXPRESSION_STATEMENT = "[/]";
    public static final String COMMENT = "comment";
    public static final String BLOCK_COMMENT_START = "[comment]";
    public static final String BLOCK_COMMENT_END = "[/comment]";
    public static final String COMMENT_START_MISSING_SPACE = "[comment";
    public static final String COMMENT_START = "[comment ";
    public static final String COMMENT_END = "/]";
    public static final String MODULE = "module";
    public static final String MODULE_HEADER_START = "[module ";
    public static final String MODULE_HEADER_END = "/]";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String QUALIFIER_SEPARATOR = "::";
    public static final String EQUAL = "=";
    public static final String PIPE = "|";
    public static final String QUOTE = "'";
    public static final String TEMPLATE = "template";
    public static final String TEMPLATE_HEADER_START = "[template ";
    public static final String TEMPLATE_HEADER_END = "]";
    public static final String TEMPLATE_GUARD = "?";
    public static final String POST = "post";
    public static final String TEMPLATE_POST = "post(";
    public static final String END_BLOCK_PREFIX = "[/";
    public static final String TEMPLATE_END = "[/template]";
    public static final String EXPRESSION_STATEMENT_START = "[";
    public static final String EXPRESSION_STATEMENT_END = "/]";
    public static final String PROTECTED = "protected";
    public static final String PROTECTED_AREA_HEADER_START = "[protected ";
    public static final String PROTECTED_AREA_HEADER_END = "]";
    public static final String START_TAG_PREFIX = "startTagPrefix";
    public static final String PROTECTED_AREA_START_TAG_PREFIX = "startTagPrefix(";
    public static final String END_TAG_PREFIX = "endTagPrefix";
    public static final String PROTECTED_AREA_END_TAG_PREFIX = "endTagPrefix(";
    public static final String PROTECTED_AREA_END = "[/protected]";
    public static final String FILE = "file";
    public static final String FILE_HEADER_START = "[file ";
    public static final String FILE_HEADER_END = "]";
    public static final String FILE_END = "[/file]";
    public static final String LET = "let";
    public static final String LET_HEADER_START = "[let ";
    public static final String LET_HEADER_END = "]";
    public static final String LET_END = "[/let]";
    public static final String FOR = "for";
    public static final String FOR_HEADER_START = "[for ";
    public static final String SEPARATOR = "separator";
    public static final String FOR_SEPARATOR = "separator(";
    public static final String FOR_HEADER_END = "]";
    public static final String FOR_END = "[/for]";
    public static final String IF = "if";
    public static final String IF_HEADER_START = "[if ";
    public static final String IF_HEADER_START_MISSING_SPACE = "[if(";
    public static final String IF_HEADER_END = "]";
    public static final String ELSEIF = "elseif";
    public static final String IF_ELSEIF = "[elseif ";
    public static final String ELSE = "else";
    public static final String IF_ELSE = "[else]";
    public static final String IF_END = "[/if]";
    public static final String QUERY = "query";
    public static final String QUERY_START = "[query ";
    public static final String QUERY_END = "/]";
    public static final String IMPORT = "import";
    public static final String IMPORT_START = "[import ";
    public static final String IMPORT_END = "/]";
    public static final String DOCUMENTATION_START = "[**";
    public static final String DOCUMENTATION_END = "/]";
    public static final String ENCODING_TAG = "encoding";
    private static final Pattern ENCODING_PATTERN = Pattern.compile(Pattern.quote("[comment ") + "\\s*" + Pattern.quote("encoding") + "\\s*=\\s*(.+?)\\s*" + Pattern.quote("/]"));
    private static final int ENCODING_PATTERN_ENCODING_GROUP_INDEX = 1;
    public static final String MAIN_TAG = "@main";
    public static final String AUTHOR_TAG = "@author ";
    public static final String VERSION_TAG = "@version ";
    public static final String SINCE_TAG = "@since ";
    public static final String PARAM_TAG = "@param ";
    public static final String EXTENDS = "extends ";
    public static final int INDENTATION = 2;
    private Positions<ASTNode> positions;
    private int currentPosition;
    private int[] lines;
    private int[] columns;
    private String text;
    private int textLength;
    private List<Error> errors;

    public String parseEncoding(InputStream source) throws IOException {
        String firstLine;
        Matcher matcher;
        BufferedReader reader;
        String res = source != null ? ((reader = new BufferedReader(new InputStreamReader(source))).ready() ? ((matcher = ENCODING_PATTERN.matcher(firstLine = reader.readLine())).find() && matcher.start() == 0 ? matcher.group(1) : null) : null) : null;
        return res;
    }

    public AcceleoAstResult parse(InputStream source, String charsetName, String moduleQualifiedName) throws IOException {
        return this.parse(AcceleoUtil.getContent(source, charsetName), charsetName, moduleQualifiedName);
    }

    public AcceleoAstResult parse(String source, String charsetName, String qualifiedName) {
        this.currentPosition = this.skipEncoding(source);
        this.text = source;
        this.textLength = this.text.length();
        this.lines = new int[this.textLength + 1];
        this.columns = new int[this.textLength + 1];
        this.positions = new Positions();
        this.computeLinesAndColumns(this.text, this.textLength);
        this.errors = new ArrayList<Error>();
        this.skipSpaces();
        List<Comment> comments = this.parseCommentsOrModuleDocumentations();
        this.skipSpaces();
        Module module = this.parseModule(comments);
        module.setQualifiedName(qualifiedName);
        module.setEncoding(charsetName);
        XMIResourceImpl containerEmfResource = new XMIResourceImpl(URI.createURI((String)(ACCELEOENV_URI_PROTOCOL + qualifiedName)));
        containerEmfResource.getContents().add((Object)module);
        return new AcceleoAstResult(module, this.positions, this.errors);
    }

    private int skipEncoding(String text) {
        int res;
        block5: {
            res = 0;
            if (text != null) {
                BufferedReader reader = new BufferedReader(new StringReader(text));
                try {
                    if (reader.ready()) {
                        Matcher matcher;
                        String firstLine = reader.readLine();
                        res = firstLine != null ? ((matcher = ENCODING_PATTERN.matcher(firstLine)).find() && matcher.start() == 0 ? matcher.end() : 0) : 0;
                        break block5;
                    }
                    res = 0;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                res = 0;
            }
        }
        return res;
    }

    private void computeLinesAndColumns(String str, int textLength) {
        int currentLine = 0;
        int currentColumn = 0;
        int i = 0;
        while (i < textLength) {
            this.lines[i] = currentLine++;
            this.columns[i] = currentColumn++;
            int newLineLength = AcceleoParser.newLineAt(str, textLength, i);
            if (newLineLength != 0) {
                currentColumn = 0;
                i += newLineLength;
                continue;
            }
            ++i;
        }
        this.lines[str.length()] = currentLine;
        this.columns[str.length()] = currentColumn;
    }

    public static int newLineAt(String text, int textLength, int index) {
        int res = index < textLength ? (text.charAt(index) == '\r' && index + 1 < textLength && text.charAt(index + 1) == '\n' ? 2 : (text.charAt(index) == '\n' || text.charAt(index) == '\r' ? 1 : 0)) : 0;
        return res;
    }

    public static int nextNewLineIndex(String text, int textLength, int start) {
        int res = -1;
        int i = start;
        while (i < textLength) {
            if (AcceleoParser.newLineAt(text, textLength, i) != 0) {
                res = i;
                break;
            }
            ++i;
        }
        return res;
    }

    private void setIdentifierPositions(AcceleoASTNode node, int start, int end) {
        this.positions.setIdentifierStartPositions((EObject)node, Integer.valueOf(start));
        this.positions.setIdentifierStartLines((EObject)node, Integer.valueOf(this.lines[start]));
        this.positions.setIdentifierStartColumns((EObject)node, Integer.valueOf(this.columns[start]));
        this.positions.setIdentifierEndPositions((EObject)node, Integer.valueOf(end));
        this.positions.setIdentifierEndLines((EObject)node, Integer.valueOf(this.lines[end]));
        this.positions.setIdentifierEndColumns((EObject)node, Integer.valueOf(this.columns[end]));
    }

    private void setPositions(AcceleoASTNode node, int start, int end) {
        this.positions.setStartPositions((EObject)node, Integer.valueOf(start));
        this.positions.setStartLines((EObject)node, Integer.valueOf(this.lines[start]));
        this.positions.setStartColumns((EObject)node, Integer.valueOf(this.columns[start]));
        this.positions.setEndPositions((EObject)node, Integer.valueOf(end));
        this.positions.setEndLines((EObject)node, Integer.valueOf(this.lines[end]));
        this.positions.setEndColumns((EObject)node, Integer.valueOf(this.columns[end]));
    }

    protected List<Comment> parseCommentsOrModuleDocumentations() {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        Comment comment = this.parseComment(true);
        ModuleDocumentation documentation = this.parseModuleDocumentation();
        while (comment != null || documentation != null) {
            if (comment != null) {
                comments.add(comment);
            }
            if (documentation != null) {
                comments.add(documentation);
            }
            this.skipSpaces();
            comment = this.parseComment(true);
            documentation = this.parseModuleDocumentation();
        }
        return comments;
    }

    protected void skipSpaces() {
        while (this.currentPosition < this.text.length() && Character.isWhitespace(this.text.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
    }

    protected boolean readString(String str) {
        boolean res = this.text.startsWith(str, this.currentPosition);
        if (res) {
            this.currentPosition += str.length();
        }
        return res;
    }

    protected int readMissingString(String str) {
        int res = this.readString(str) ? -1 : this.currentPosition;
        return res;
    }

    protected String parseIdentifier() {
        String res;
        if (this.currentPosition < this.text.length() && Character.isJavaIdentifierStart(this.text.charAt(this.currentPosition))) {
            int identifierStart = this.currentPosition++;
            while (this.currentPosition < this.text.length() && Character.isJavaIdentifierPart(this.text.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
            res = this.text.substring(identifierStart, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected Comment parseComment(boolean errorOnMissingSpace) {
        Comment res;
        if (this.text.startsWith(BLOCK_COMMENT_START, this.currentPosition)) {
            EClass blockCommentEClass = AcceleoPackage.eINSTANCE.getBlockComment();
            EClass errorBlockCommentEClass = AcceleoPackage.eINSTANCE.getErrorBlockComment();
            res = this.createComment(BLOCK_COMMENT_START, BLOCK_COMMENT_END, blockCommentEClass, errorBlockCommentEClass);
        } else if (this.text.startsWith(COMMENT_START, this.currentPosition)) {
            EClass commentEClass = AcceleoPackage.eINSTANCE.getComment();
            EClass errorCommentEClass = AcceleoPackage.eINSTANCE.getErrorComment();
            res = this.createComment(COMMENT_START, "/]", commentEClass, errorCommentEClass);
        } else if (errorOnMissingSpace && this.text.startsWith(COMMENT_START_MISSING_SPACE, this.currentPosition)) {
            EClass errorCommentEClass = AcceleoPackage.eINSTANCE.getErrorComment();
            int missingSpacePosition = this.currentPosition + COMMENT_START_MISSING_SPACE.length();
            res = this.createComment(COMMENT_START_MISSING_SPACE, "/]", errorCommentEClass, errorCommentEClass);
            ((ErrorComment)res).setMissingSpace(missingSpacePosition);
        } else {
            res = null;
        }
        return res;
    }

    private Comment createComment(String startTag, String endTag, EClass commentClass, EClass errorCommentClass) {
        Comment res;
        int startPosition = this.currentPosition;
        int startOfCommentBody = this.currentPosition + startTag.length();
        int endOfCommentBody = this.getNext(endTag);
        if (endOfCommentBody < 0) {
            endOfCommentBody = this.text.length();
            res = (Comment)EcoreUtil.create((EClass)errorCommentClass);
            this.setPositions(res, startPosition, endOfCommentBody);
            ((ErrorComment)res).setMissingEndHeader(endOfCommentBody);
            this.errors.add((Error)((Object)res));
            this.currentPosition = endOfCommentBody;
        } else {
            res = (Comment)EcoreUtil.create((EClass)commentClass);
            this.setPositions(res, startPosition, endOfCommentBody + endTag.length());
            this.currentPosition = endOfCommentBody + endTag.length();
        }
        CommentBody commentBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
        commentBody.setValue(this.text.substring(startOfCommentBody, endOfCommentBody));
        this.setPositions(commentBody, startOfCommentBody, endOfCommentBody);
        res.setBody(commentBody);
        return res;
    }

    protected ModuleDocumentation parseModuleDocumentation() {
        ModuleDocumentation res;
        if (this.text.startsWith(DOCUMENTATION_START, this.currentPosition)) {
            int sincePosition;
            int versionPosition;
            int commentStartPositon = this.currentPosition;
            this.currentPosition += DOCUMENTATION_START.length();
            int startPosition = this.currentPosition;
            int endPosition = this.getNext("/]");
            if (endPosition < 0) {
                this.currentPosition = endPosition = this.text.length();
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorModuleDocumentation();
                ((ErrorModuleDocumentation)res).setMissingEndHeader(endPosition);
                this.errors.add((Error)((Object)res));
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModuleDocumentation();
                this.currentPosition = endPosition + "/]".length();
            }
            String docString = this.text.substring(startPosition, endPosition);
            int docStringLength = docString.length();
            CommentBody commentBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
            this.setPositions(commentBody, startPosition, endPosition);
            commentBody.setValue(docString);
            res.setBody(commentBody);
            int authorPosition = docString.indexOf(AUTHOR_TAG);
            if (authorPosition >= 0) {
                int authorStart = authorPosition + AUTHOR_TAG.length();
                int authorEnd = AcceleoParser.nextNewLineIndex(docString, docStringLength, authorStart);
                res.setAuthor(docString.substring(authorStart, authorEnd));
            }
            if ((versionPosition = docString.indexOf(VERSION_TAG)) >= 0) {
                int versionStart = versionPosition + VERSION_TAG.length();
                int versionEnd = AcceleoParser.nextNewLineIndex(docString, docStringLength, versionStart);
                res.setVersion(docString.substring(versionStart, versionEnd));
            }
            if ((sincePosition = docString.indexOf(SINCE_TAG)) >= 0) {
                int sinceStart = sincePosition + SINCE_TAG.length();
                int sinceEnd = AcceleoParser.nextNewLineIndex(docString, docStringLength, sinceStart);
                if (sinceEnd >= 0) {
                    res.setSince(docString.substring(sinceStart, sinceEnd));
                } else {
                    res.setSince(docString.substring(sinceStart, docString.length()));
                }
            }
            this.setPositions(res, commentStartPositon, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected ModuleElementDocumentation parseModuleElementDocumentation() {
        ModuleElementDocumentation res;
        if (this.text.startsWith(DOCUMENTATION_START, this.currentPosition)) {
            int commentStartPositon = this.currentPosition;
            this.currentPosition += DOCUMENTATION_START.length();
            int startPosition = this.currentPosition;
            int endPosition = this.getNext("/]");
            if (endPosition < 0) {
                this.currentPosition = endPosition = this.text.length();
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorModuleElementDocumentation();
                ((ErrorModuleElementDocumentation)res).setMissingEndHeader(endPosition);
                this.errors.add((Error)((Object)res));
            } else {
                this.currentPosition = endPosition + "/]".length();
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModuleElementDocumentation();
            }
            String docString = this.text.substring(startPosition, endPosition);
            int docStringLength = docString.length();
            CommentBody commentBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
            this.setPositions(commentBody, this.currentPosition, endPosition);
            commentBody.setValue(docString);
            res.setBody(commentBody);
            int paramPosition = docString.indexOf(PARAM_TAG);
            while (paramPosition >= 0) {
                ParameterDocumentation paramDoc = AcceleoPackage.eINSTANCE.getAcceleoFactory().createParameterDocumentation();
                int paramStart = paramPosition + PARAM_TAG.length();
                int paramEnd = AcceleoParser.nextNewLineIndex(docString, docStringLength, paramStart);
                if (paramEnd < 0) {
                    paramPosition = -1;
                    paramEnd = docString.length();
                } else {
                    paramPosition = docString.indexOf(PARAM_TAG, paramEnd);
                }
                this.setPositions(paramDoc, paramStart + startPosition, paramEnd + startPosition);
                CommentBody paramBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
                paramBody.setValue(docString.substring(paramStart, paramEnd));
                this.setPositions(paramBody, paramStart + startPosition, paramEnd + startPosition);
                paramDoc.setBody(paramBody);
                res.getParameterDocumentation().add((Object)paramDoc);
            }
            this.setPositions(res, commentStartPositon, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected Module parseModule(List<Comment> comments) {
        Module res;
        if (this.text.startsWith(MODULE_HEADER_START, this.currentPosition)) {
            boolean missingParenthesis;
            ModuleReference extendedModule;
            int startPosition = Stream.concat(Stream.of(Integer.valueOf(this.currentPosition)), comments.stream().map(arg_0 -> this.positions.getStartPositions(arg_0))).min(Integer::compareTo).get();
            int startHeaderPosition = this.currentPosition;
            this.currentPosition += MODULE_HEADER_START.length();
            this.skipSpaces();
            int identifierStartPosition = this.currentPosition;
            String name = this.parseIdentifier();
            int identifierEndPosition = this.currentPosition;
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            ArrayList<Metamodel> metamodels = new ArrayList<Metamodel>();
            Metamodel metamodel = this.parseMetamodel();
            int missingEPackage = -1;
            if (metamodel == null) {
                missingEPackage = this.currentPosition;
            }
            while (metamodel != null) {
                metamodels.add(metamodel);
                this.skipSpaces();
                if (!this.readString(COMMA)) break;
                this.skipSpaces();
                metamodel = this.parseMetamodel();
                missingEPackage = metamodel == null ? this.currentPosition : -1;
            }
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            if (this.readString(EXTENDS)) {
                this.skipSpaces();
                extendedModule = this.parseModuleReference();
                this.skipSpaces();
            } else {
                extendedModule = null;
            }
            int missingEndHeader = this.readMissingString("/]");
            int endHeaderPosition = this.currentPosition;
            this.skipSpaces();
            ArrayList<ModuleElement> moduleElements = new ArrayList<ModuleElement>();
            List<Comment> elementComments = this.parseCommentsOrModuleElementDocumentations();
            this.skipSpaces();
            ArrayList<Import> imports = new ArrayList<Import>();
            Import imported = this.parseImport();
            while (imported != null) {
                moduleElements.addAll(elementComments);
                imports.add(imported);
                this.skipSpaces();
                elementComments = this.parseCommentsOrModuleElementDocumentations();
                this.skipSpaces();
                imported = this.parseImport();
            }
            moduleElements.addAll(this.parseModuleElements(elementComments));
            int endPosition = this.currentPosition;
            boolean bl = missingParenthesis = missingOpenParenthesis != -1 || missingCloseParenthesis != -1;
            if (missingParenthesis || missingEPackage != -1 || missingEndHeader != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorModule();
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                res.setMissingEPackage(missingEPackage);
                res.setMissingCloseParenthesis(missingCloseParenthesis);
                ((ErrorModule)res).setMissingEndHeader(missingEndHeader);
                this.errors.add((ErrorModule)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModule();
            }
            this.setIdentifierPositions(res, identifierStartPosition, identifierEndPosition);
            this.setPositions(res, startPosition, endPosition);
            res.setStartHeaderPosition(startHeaderPosition);
            res.setEndHeaderPosition(endHeaderPosition);
            res.getModuleElements().addAll(comments);
            res.setDocumentation(this.getLastDocumentation(comments));
            res.setName(name);
            res.getMetamodels().addAll(metamodels);
            res.getImports().addAll(imports);
            res.setExtends(extendedModule);
            res.getModuleElements().addAll(moduleElements);
        } else {
            res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorModule();
            this.errors.add((Error)((Object)res));
        }
        return res;
    }

    protected Import parseImport() {
        Import res;
        if (this.text.startsWith(IMPORT_START, this.currentPosition)) {
            int startPosition = this.currentPosition;
            this.currentPosition += IMPORT_START.length();
            this.skipSpaces();
            ModuleReference moduleReference = this.parseModuleReference();
            this.skipSpaces();
            int missingEnd = this.readMissingString("/]");
            if (missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorImport();
                res.setMissingEnd(missingEnd);
                this.errors.add((ErrorImport)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createImport();
            }
            res.setModule(moduleReference);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected ModuleReference parseModuleReference() {
        ModuleReference res;
        int startPosition = this.currentPosition;
        String moduleQualifiedName = this.parseModuleQualifiedName();
        if (moduleQualifiedName == null) {
            res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorModuleReference();
            this.errors.add((ErrorModuleReference)res);
        } else {
            res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModuleReference();
        }
        res.setQualifiedName(moduleQualifiedName);
        this.setPositions(res, startPosition, this.currentPosition);
        return res;
    }

    protected String parseModuleQualifiedName() {
        StringBuilder builder = new StringBuilder();
        String segment = this.parseIdentifier();
        while (segment != null) {
            builder.append(segment);
            if (!this.readString(QUALIFIER_SEPARATOR)) break;
            builder.append(QUALIFIER_SEPARATOR);
            segment = this.parseIdentifier();
        }
        String res = builder.length() != 0 ? builder.toString() : null;
        return res;
    }

    protected Documentation getLastDocumentation(List<Comment> comments) {
        int i = comments.size() - 1;
        while (i >= 0) {
            Comment current = comments.get(i);
            if (current instanceof Documentation) {
                return (Documentation)current;
            }
            --i;
        }
        return null;
    }

    protected List<ModuleElement> parseModuleElements(List<Comment> comments) {
        DocumentedElement moduleElement;
        ArrayList<ModuleElement> res = new ArrayList<ModuleElement>();
        List<Comment> localComments = comments;
        do {
            res.addAll(localComments);
            Documentation documentation = this.getLastDocumentation(localComments);
            Template template = this.parseTemplate(documentation, this.hasMain(localComments));
            moduleElement = template != null ? template : this.parseQuery(documentation);
            if (moduleElement != null) {
                res.add((ModuleElement)((Object)moduleElement));
            }
            this.skipSpaces();
            localComments = this.parseCommentsOrModuleElementDocumentations();
        } while (moduleElement != null);
        return res;
    }

    private boolean hasMain(List<Comment> comments) {
        for (Comment comment : comments) {
            if (!comment.getBody().getValue().contains(MAIN_TAG)) continue;
            return true;
        }
        return false;
    }

    protected List<Comment> parseCommentsOrModuleElementDocumentations() {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        Comment comment = this.parseComment(true);
        ModuleElementDocumentation documentation = this.parseModuleElementDocumentation();
        while (comment != null || documentation != null) {
            if (comment != null) {
                comments.add(comment);
            }
            if (documentation != null) {
                comments.add(documentation);
            }
            this.skipSpaces();
            comment = this.parseComment(true);
            documentation = this.parseModuleElementDocumentation();
        }
        return comments;
    }

    protected Query parseQuery(Documentation documentation) {
        Query res;
        if (this.text.startsWith(QUERY_START, this.currentPosition)) {
            boolean missingSymbols;
            int startPosition = this.currentPosition;
            this.currentPosition += QUERY_START.length();
            this.skipSpaces();
            VisibilityKind visibility = this.parseVisibility();
            int missingVisibility = visibility == null ? this.currentPosition : -1;
            this.skipSpaces();
            int identifierStartPosition = this.currentPosition;
            String name = this.parseIdentifier();
            int identifierEndPosition = this.currentPosition;
            int missingName = name == null ? this.currentPosition : -1;
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            List<Variable> parameters = this.parseParameters();
            int missingParameters = parameters.isEmpty() ? this.currentPosition : -1;
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            int missingColon = this.readMissingString(COLON);
            this.skipSpaces();
            int typeEndLimit = this.getAqlExpressionEndLimit(EQUAL, "/]");
            AstResult type = this.parseWhileAqlTypeLiteral(this.text.substring(this.currentPosition, typeEndLimit));
            type.addAllPositonsTo(this.positions, this.currentPosition, this.lines[this.currentPosition], this.columns[this.currentPosition]);
            this.currentPosition += type.getEndPosition((ASTNode)type.getAst());
            int missingType = type.getStartPosition((ASTNode)type.getAst()) == type.getEndPosition((ASTNode)type.getAst()) ? this.currentPosition : -1;
            this.skipSpaces();
            int missingEqual = this.readMissingString(EQUAL);
            this.skipSpaces();
            int expressionEndLimit = this.getAqlExpressionEndLimit("/]", "/]");
            Expression body = this.parseExpression(expressionEndLimit);
            this.skipSpaces();
            int missingEnd = this.readMissingString("/]");
            boolean missingValue = missingVisibility != -1 || missingName != -1 || missingType != -1 || parameters.isEmpty();
            boolean missingParenthesis = missingOpenParenthesis != -1 || missingParameters != -1 || missingCloseParenthesis != -1;
            boolean bl = missingSymbols = missingColon != -1 || missingEqual != -1 || missingEnd != -1;
            if (missingVisibility != -1 || missingValue || missingParenthesis || missingSymbols) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorQuery();
                res.setMissingVisibility(missingVisibility);
                res.setMissingName(missingName);
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                ((ErrorQuery)res).setMissingParameters(missingParameters);
                ((ErrorQuery)res).setMissingCloseParenthesis(missingCloseParenthesis);
                ((ErrorQuery)res).setMissingColon(missingColon);
                ((ErrorQuery)res).setMissingType(missingType);
                ((ErrorQuery)res).setMissingEqual(missingEqual);
                ((ErrorQuery)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorQuery)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createQuery();
            }
            res.setDocumentation(documentation);
            res.setVisibility(visibility);
            res.setName(name);
            res.getParameters().addAll(parameters);
            if (type != null) {
                res.setType(type);
                res.setTypeAql(type.getAst());
            }
            res.setBody(body);
            this.setIdentifierPositions(res, identifierStartPosition, identifierEndPosition);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected List<Variable> parseParameters() {
        ArrayList<Variable> res = new ArrayList<Variable>();
        Variable variable = this.parseVariable();
        while (variable != null) {
            res.add(variable);
            this.skipSpaces();
            if (this.readString(COMMA)) {
                this.skipSpaces();
                variable = this.parseVariable();
                continue;
            }
            this.skipSpaces();
            break;
        }
        return res;
    }

    protected Variable parseVariable() {
        Variable res;
        int startPosition = this.currentPosition;
        int identifierStartPosition = this.currentPosition;
        String name = this.parseIdentifier();
        int identifierEndPosition = this.currentPosition;
        int missingName = name == null ? this.currentPosition : -1;
        this.skipSpaces();
        int missingColon = this.readMissingString(COLON);
        this.skipSpaces();
        int typeEndLimit = this.getAqlExpressionEndLimit(COMMA, CLOSE_PARENTHESIS);
        AstResult type = this.parseWhileAqlTypeLiteral(this.text.substring(this.currentPosition, typeEndLimit));
        type.addAllPositonsTo(this.positions, this.currentPosition, this.lines[this.currentPosition], this.columns[this.currentPosition]);
        this.currentPosition += type.getEndPosition((ASTNode)type.getAst());
        int missingType = type.getStartPosition((ASTNode)type.getAst()) == type.getEndPosition((ASTNode)type.getAst()) ? this.currentPosition : -1;
        if (missingName == -1) {
            if (missingType != -1 || missingColon != -1 || type.getAst() instanceof org.eclipse.acceleo.query.ast.Error) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorVariable();
                res.setMissingName(missingName);
                res.setMissingColon(missingColon);
                res.setMissingType(missingType);
                this.errors.add((ErrorVariable)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createVariable();
            }
            res.setName(name);
            if (type != null) {
                res.setType(type);
                res.setTypeAql(type.getAst());
            }
            this.setIdentifierPositions(res, identifierStartPosition, identifierEndPosition);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected Template parseTemplate(Documentation documentation, boolean isMain) {
        Template res;
        if (this.text.startsWith(TEMPLATE_HEADER_START, this.currentPosition)) {
            boolean missingParenthesis;
            int missingPostCloseParenthesis;
            Expression postExpression;
            int missingGuardCloseParenthesis;
            Expression guardExpression;
            int missingGuardOpenParenthesis;
            int startPosition = this.currentPosition;
            int significantTextColumn = this.columns[startPosition] + 2;
            int headerStartLine = this.lines[startPosition];
            this.currentPosition += TEMPLATE_HEADER_START.length();
            this.skipSpaces();
            VisibilityKind visibility = this.parseVisibility();
            int missingVisibility = visibility == null ? this.currentPosition : -1;
            this.skipSpaces();
            int identifierStartPosition = this.currentPosition;
            String name = this.parseIdentifier();
            int identifierEndPosition = this.currentPosition;
            int missingName = name == null ? this.currentPosition : -1;
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            List<Variable> parameters = this.parseParameters();
            int missingParameters = parameters.isEmpty() ? this.currentPosition : -1;
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            if (this.text.startsWith(TEMPLATE_GUARD, this.currentPosition)) {
                this.currentPosition += TEMPLATE_GUARD.length();
                this.skipSpaces();
                missingGuardOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
                this.skipSpaces();
                int expressionEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
                guardExpression = this.parseExpression(expressionEndLimit);
                this.skipSpaces();
                missingGuardCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
                this.skipSpaces();
            } else {
                guardExpression = null;
                missingGuardOpenParenthesis = -1;
                missingGuardCloseParenthesis = -1;
            }
            if (this.text.startsWith(TEMPLATE_POST, this.currentPosition)) {
                this.currentPosition += TEMPLATE_POST.length();
                this.skipSpaces();
                int expressionEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
                postExpression = this.parseExpression(expressionEndLimit);
                this.skipSpaces();
                missingPostCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
                this.skipSpaces();
            } else {
                missingPostCloseParenthesis = -1;
                postExpression = null;
            }
            int missingEndHeader = this.readMissingString("]");
            Block body = this.parseBlock(headerStartLine, significantTextColumn, TEMPLATE_END);
            int missingEnd = this.readMissingString(TEMPLATE_END);
            boolean missingValue = missingVisibility != -1 || missingName != -1 || parameters.isEmpty();
            boolean missingGuardParenthesis = missingGuardOpenParenthesis != -1 || missingGuardCloseParenthesis != -1;
            boolean bl = missingParenthesis = missingOpenParenthesis != -1 || missingParameters != -1 || missingCloseParenthesis != -1 || missingGuardParenthesis || missingPostCloseParenthesis != -1;
            if (missingValue || missingParenthesis || missingEndHeader != -1 || missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorTemplate();
                res.setMissingVisibility(missingVisibility);
                res.setMissingName(missingName);
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                ((ErrorTemplate)res).setMissingParameters(missingParameters);
                ((ErrorTemplate)res).setMissingCloseParenthesis(missingCloseParenthesis);
                ((ErrorTemplate)res).setMissingGuardOpenParenthesis(missingGuardOpenParenthesis);
                ((ErrorTemplate)res).setMissingGuardCloseParenthesis(missingGuardCloseParenthesis);
                ((ErrorTemplate)res).setMissingPostCloseParenthesis(missingPostCloseParenthesis);
                ((ErrorTemplate)res).setMissingEndHeader(missingEndHeader);
                ((ErrorTemplate)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorTemplate)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTemplate();
            }
            res.setMain(isMain);
            res.setDocumentation(documentation);
            res.setVisibility(visibility);
            res.setName(name);
            res.getParameters().addAll(parameters);
            res.setGuard(guardExpression);
            res.setPost(postExpression);
            res.setBody(body);
            this.setIdentifierPositions(res, identifierStartPosition, identifierEndPosition);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected Block parseBlock(int headerStartLine, int significantTextColumn, String ... endBlocks) {
        Block res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
        int startPosition = this.currentPosition;
        boolean inlined = AcceleoParser.newLineAt(this.text, this.textLength, this.currentPosition) == 0 && headerStartLine == this.lines[this.currentPosition];
        this.skipNewLine();
        int beforeStatementPosition = this.currentPosition;
        Statement statement = this.parseStatement(inlined, significantTextColumn);
        int afterStatementPosition = this.currentPosition;
        boolean onlyCommentsFromStart = true;
        LeafStatement lastLeafStatement = null;
        block0: while (beforeStatementPosition != afterStatementPosition) {
            if (statement != null) {
                if (statement instanceof Comment) {
                    if (onlyCommentsFromStart) {
                        inlined = AcceleoParser.newLineAt(this.text, this.textLength, this.currentPosition) == 0 && headerStartLine == this.lines[this.currentPosition];
                        this.skipNewLine();
                    }
                    if (lastLeafStatement != null) {
                        lastLeafStatement.setNewLineNeeded(lastLeafStatement.isNewLineNeeded() || !inlined && AcceleoParser.newLineAt(this.text, this.textLength, this.currentPosition) != 0);
                    }
                } else if (statement instanceof LeafStatement) {
                    lastLeafStatement = (LeafStatement)statement;
                    onlyCommentsFromStart = false;
                } else {
                    lastLeafStatement = null;
                    onlyCommentsFromStart = false;
                }
                res.getStatements().add((Object)statement);
            }
            String[] stringArray = endBlocks;
            int n = endBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                String endOfBlock = stringArray[n2];
                if (this.text.startsWith(endOfBlock, this.currentPosition)) break block0;
                ++n2;
            }
            beforeStatementPosition = this.currentPosition;
            statement = this.parseStatement(inlined, significantTextColumn);
            afterStatementPosition = this.currentPosition;
        }
        res.setInlined(inlined);
        this.setPositions(res, startPosition, this.currentPosition);
        return res;
    }

    private void skipNewLine() {
        this.currentPosition += AcceleoParser.newLineAt(this.text, this.textLength, this.currentPosition);
    }

    protected Statement parseStatement(boolean inlined, int significantTextColumn) {
        TextStatement text;
        ExpressionStatement expressionStatement;
        Comment comment;
        ProtectedArea protectedArea;
        LetStatement letStatement;
        IfStatement ifStatement;
        ForStatement forStatement;
        Statement res = null;
        FileStatement file = this.parseFileStatement();
        res = file != null ? file : ((forStatement = this.parseForStatement()) != null ? forStatement : ((ifStatement = this.parseIfStatement(IF_HEADER_START)) != null ? ifStatement : ((letStatement = this.parseLetStatement()) != null ? letStatement : ((protectedArea = this.parseProtectedArea()) != null ? protectedArea : ((comment = this.parseComment(false)) != null ? comment : ((expressionStatement = this.parseExpressionStatement(inlined)) != null ? expressionStatement : ((text = this.parseTextStatement(inlined, significantTextColumn)) != null ? text : null)))))));
        if (res != null) {
            if (res instanceof TextStatement) {
                res.setMultiLines(false);
            } else {
                res.setMultiLines(!this.positions.getStartLines((EObject)res).equals(this.positions.getEndLines((EObject)res)));
            }
        }
        return res;
    }

    protected IfStatement parseIfStatement(String startTag) {
        IfStatement res;
        int missingSpace = this.text.startsWith(IF_HEADER_START_MISSING_SPACE, this.currentPosition) ? this.currentPosition + IF_HEADER_START_MISSING_SPACE.length() - 1 : -1;
        if (this.text.startsWith(startTag, this.currentPosition) || missingSpace != -1) {
            Block elseBlock;
            boolean parseEndIf;
            int startPosition = this.currentPosition;
            int thenSignificantTextColumn = this.columns[startPosition] + 2;
            int thenHeaderStartLine = this.lines[startPosition];
            this.currentPosition = missingSpace != -1 ? missingSpace : (this.currentPosition += startTag.length());
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            int expressionEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
            Expression condition = this.parseExpression(expressionEndLimit);
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            int missingEndHeader = this.readMissingString("]");
            Block thenblock = this.parseBlock(thenHeaderStartLine, thenSignificantTextColumn, IF_END, IF_ELSEIF, IF_ELSE);
            IfStatement elseIf = this.parseIfStatement(IF_ELSEIF);
            boolean bl = parseEndIf = elseIf == null;
            if (elseIf != null) {
                elseBlock = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBlock();
                elseBlock.getStatements().add((Object)elseIf);
            } else if (this.readString(IF_ELSE)) {
                int elseStartPosition = this.currentPosition - IF_ELSE.length();
                int elseSignificantTextColumn = this.columns[elseStartPosition] + 2;
                int headerStartLine = this.lines[elseStartPosition];
                elseBlock = this.parseBlock(headerStartLine, elseSignificantTextColumn, IF_END);
            } else {
                elseBlock = null;
            }
            int missingEnd = parseEndIf ? this.readMissingString(IF_END) : -1;
            if (missingSpace != -1 || missingOpenParenthesis != -1 || missingCloseParenthesis != -1 || missingEndHeader != -1 || missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorIfStatement();
                res.setMissingSpace(missingSpace);
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                res.setMissingCloseParenthesis(missingCloseParenthesis);
                res.setMissingEndHeader(missingEndHeader);
                ((ErrorIfStatement)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorIfStatement)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createIfStatement();
            }
            res.setCondition(condition);
            res.setThen(thenblock);
            res.setElse(elseBlock);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected ForStatement parseForStatement() {
        ForStatement res;
        if (this.text.startsWith(FOR_HEADER_START, this.currentPosition)) {
            boolean missingParenthesis;
            int missingSeparatorCloseParenthesis;
            Expression separator;
            int startPosition = this.currentPosition;
            int significantTextColumn = this.columns[startPosition] + 2;
            int headerStartLine = this.lines[startPosition];
            this.currentPosition += FOR_HEADER_START.length();
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            int bindingEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
            Binding binding = this.parseBinding(PIPE, bindingEndLimit);
            int missingBinding = binding == null ? this.currentPosition : -1;
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            if (this.readString(FOR_SEPARATOR)) {
                this.skipSpaces();
                int separatorEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
                separator = this.parseExpression(separatorEndLimit);
                this.skipSpaces();
                missingSeparatorCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
                this.skipSpaces();
            } else {
                separator = null;
                missingSeparatorCloseParenthesis = -1;
            }
            int missingEndHeader = this.readMissingString("]");
            Block body = this.parseBlock(headerStartLine, significantTextColumn, FOR_END);
            int missingEnd = this.readMissingString(FOR_END);
            boolean bl = missingParenthesis = missingOpenParenthesis != -1 || missingBinding != -1 || missingCloseParenthesis != -1 || missingSeparatorCloseParenthesis != -1;
            if (missingParenthesis || missingEndHeader != -1 || missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorForStatement();
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                res.setMissingBinding(missingBinding);
                ((ErrorForStatement)res).setMissingCloseParenthesis(missingCloseParenthesis);
                ((ErrorForStatement)res).setMissingSeparatorCloseParenthesis(missingSeparatorCloseParenthesis);
                ((ErrorForStatement)res).setMissingEndHeader(missingEndHeader);
                ((ErrorForStatement)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorForStatement)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createForStatement();
            }
            res.setBinding(binding);
            res.setSeparator(separator);
            res.setBody(body);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected FileStatement parseFileStatement() {
        FileStatement res;
        if (this.text.startsWith(FILE_HEADER_START, this.currentPosition)) {
            boolean missingSymbole;
            Expression charset;
            int missingOpenMode;
            int startPosition = this.currentPosition;
            int significantTextColumn = this.columns[startPosition] + 2;
            int headerStartLine = this.lines[startPosition];
            this.currentPosition += FILE_HEADER_START.length();
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            int urlExpressionEndLimit = this.getAqlExpressionEndLimit(COMMA, "]");
            Expression url = this.parseExpression(urlExpressionEndLimit);
            this.skipSpaces();
            int missingComma = this.readMissingString(COMMA);
            this.skipSpaces();
            OpenModeKind openMode = this.parseOpenModeKind();
            if (openMode == null) {
                missingOpenMode = this.currentPosition;
                int position = this.getNext(COMMA, CLOSE_PARENTHESIS);
                if (position >= 0) {
                    this.currentPosition = position;
                }
            } else {
                missingOpenMode = -1;
            }
            if (this.readString(COMMA)) {
                this.skipSpaces();
                int charsetExpressionEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
                charset = this.parseExpression(charsetExpressionEndLimit);
            } else {
                charset = null;
            }
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            int missingEndHeader = this.readMissingString("]");
            Block body = this.parseBlock(headerStartLine, significantTextColumn, FILE_END);
            int missingEnd = this.readMissingString(FILE_END);
            boolean bl = missingSymbole = missingOpenParenthesis != -1 || missingCloseParenthesis != -1 || missingComma != -1;
            if (missingOpenMode != -1 || missingSymbole || missingEndHeader != -1 || missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorFileStatement();
                res.setMissingOpenMode(missingOpenMode);
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                res.setMissingComma(missingComma);
                ((ErrorFileStatement)res).setMissingCloseParenthesis(missingCloseParenthesis);
                ((ErrorFileStatement)res).setMissingEndHeader(missingEndHeader);
                ((ErrorFileStatement)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorFileStatement)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createFileStatement();
            }
            res.setUrl(url);
            res.setCharset(charset);
            res.setMode(openMode);
            res.setBody(body);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected OpenModeKind parseOpenModeKind() {
        OpenModeKind res = null;
        for (OpenModeKind openMode : OpenModeKind.VALUES) {
            if (!this.text.startsWith(openMode.getName(), this.currentPosition)) continue;
            res = openMode;
            this.currentPosition += openMode.getName().length();
            break;
        }
        return res;
    }

    protected LetStatement parseLetStatement() {
        LetStatement res;
        if (this.text.startsWith(LET_HEADER_START, this.currentPosition)) {
            int startPosition = this.currentPosition;
            int significantTextColumn = this.columns[startPosition] + 2;
            int headerStartLine = this.lines[startPosition];
            this.currentPosition += LET_HEADER_START.length();
            this.skipSpaces();
            List<Binding> bindings = this.parseBindings(EQUAL, "]");
            int missingBindings = bindings.isEmpty() ? this.currentPosition : -1;
            this.skipSpaces();
            int missingEndHeader = this.readMissingString("]");
            Block body = this.parseBlock(headerStartLine, significantTextColumn, LET_END);
            int missingEnd = this.readMissingString(LET_END);
            if (missingBindings != -1 || missingEndHeader != -1 || missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorLetStatement();
                res.setMissingBindings(missingBindings);
                res.setMissingEndHeader(missingEndHeader);
                ((ErrorLetStatement)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorLetStatement)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createLetStatement();
            }
            res.getVariables().addAll(bindings);
            res.setBody(body);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected Binding parseBinding(String affectationSymbol, int endLimit) {
        Binding res;
        int missingType;
        AstResult type;
        int typeEndLimit;
        int startPosition = this.currentPosition;
        int identifierStartPosition = this.currentPosition;
        String name = this.parseIdentifier();
        int identifierEndPosition = this.currentPosition;
        int missingName = name == null ? this.currentPosition : -1;
        this.skipSpaces();
        int missingColon = this.currentPosition;
        if (this.readString(COLON)) {
            this.skipSpaces();
            typeEndLimit = Math.min(this.getAqlExpressionEndLimit(affectationSymbol, COMMA), endLimit);
            type = this.parseWhileAqlTypeLiteral(this.text.substring(this.currentPosition, typeEndLimit));
            type.addAllPositonsTo(this.positions, this.currentPosition, this.lines[this.currentPosition], this.columns[this.currentPosition]);
            this.currentPosition += type.getEndPosition((ASTNode)type.getAst());
            missingType = type.getStartPosition((ASTNode)type.getAst()) == type.getEndPosition((ASTNode)type.getAst()) ? this.currentPosition : -1;
            missingColon = -1;
        } else {
            this.skipSpaces();
            typeEndLimit = Math.min(this.getAqlExpressionEndLimit(affectationSymbol, COMMA), endLimit);
            type = this.parseWhileAqlTypeLiteral(this.text.substring(this.currentPosition, typeEndLimit));
            type.addAllPositonsTo(this.positions, this.currentPosition, this.lines[this.currentPosition], this.columns[this.currentPosition]);
            this.currentPosition += type.getEndPosition((ASTNode)type.getAst());
            if (type.getStartPosition((ASTNode)type.getAst()) == type.getEndPosition((ASTNode)type.getAst())) {
                missingColon = -1;
                type = null;
            }
            missingType = -1;
        }
        this.skipSpaces();
        int missingAffectationSymbol = this.readMissingString(affectationSymbol);
        if (missingColon != -1 && missingAffectationSymbol != -1) {
            int typeEndLimit2 = Math.min(this.getAqlExpressionEndLimit(affectationSymbol, COMMA), endLimit);
            type = this.parseWhileAqlTypeLiteral(this.text.substring(this.currentPosition, typeEndLimit2));
            type.addAllPositonsTo(this.positions, this.currentPosition, this.lines[this.currentPosition], this.columns[this.currentPosition]);
            this.currentPosition += type.getEndPosition((ASTNode)type.getAst());
            missingType = type.getStartPosition((ASTNode)type.getAst()) == type.getEndPosition((ASTNode)type.getAst()) ? this.currentPosition : -1;
            this.skipSpaces();
            missingAffectationSymbol = this.readMissingString(affectationSymbol);
        }
        this.skipSpaces();
        Expression expression = this.parseExpression(endLimit);
        if (missingName == -1) {
            boolean hasErrorExpression = expression.getAst().getAst() instanceof org.eclipse.acceleo.query.ast.Error;
            if (missingColon != -1 || missingType != -1 || missingAffectationSymbol != -1 || hasErrorExpression) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorBinding();
                res.setMissingName(missingName);
                res.setMissingColon(missingColon);
                res.setMissingType(missingType);
                if (missingAffectationSymbol != -1) {
                    ((ErrorBinding)res).setMissingAffectationSymbole(affectationSymbol);
                    ((ErrorBinding)res).setMissingAffectationSymbolePosition(missingAffectationSymbol);
                }
                this.errors.add((ErrorBinding)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createBinding();
            }
            res.setName(name);
            if (type != null) {
                res.setType(type);
                res.setTypeAql(type.getAst());
            }
            res.setInitExpression(expression);
            this.setIdentifierPositions(res, identifierStartPosition, identifierEndPosition);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected List<Binding> parseBindings(String affectationSymbol, String endTag) {
        ArrayList<Binding> res = new ArrayList<Binding>();
        int bindingEndLimit = this.getAqlExpressionEndLimit(COMMA, endTag);
        Binding binding = this.parseBinding(affectationSymbol, bindingEndLimit);
        while (binding != null) {
            res.add(binding);
            this.skipSpaces();
            if (this.readString(COMMA)) {
                this.skipSpaces();
                bindingEndLimit = this.getAqlExpressionEndLimit(COMMA, endTag);
                binding = this.parseBinding(affectationSymbol, bindingEndLimit);
                continue;
            }
            this.skipSpaces();
            break;
        }
        return res;
    }

    protected ProtectedArea parseProtectedArea() {
        ProtectedArea res;
        if (this.text.startsWith(PROTECTED_AREA_HEADER_START, this.currentPosition)) {
            int missingEndTagPrefixCloseParenthesis;
            Expression endTagPrefix;
            int missingStartTagPrefixCloseParenthesis;
            Expression startTagPrefix;
            int startPosition = this.currentPosition;
            int significantTextColumn = this.columns[startPosition] + 2;
            int headerStartLine = this.lines[startPosition];
            this.currentPosition += PROTECTED_AREA_HEADER_START.length();
            this.skipSpaces();
            int missingOpenParenthesis = this.readMissingString(OPEN_PARENTHESIS);
            this.skipSpaces();
            int expressionEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
            Expression id = this.parseExpression(expressionEndLimit);
            this.skipSpaces();
            int missingCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
            this.skipSpaces();
            if (this.readString(PROTECTED_AREA_START_TAG_PREFIX)) {
                this.skipSpaces();
                int startTagPrefixEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
                startTagPrefix = this.parseExpression(startTagPrefixEndLimit);
                this.skipSpaces();
                missingStartTagPrefixCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
                this.skipSpaces();
            } else {
                startTagPrefix = null;
                missingStartTagPrefixCloseParenthesis = -1;
            }
            if (this.readString(PROTECTED_AREA_END_TAG_PREFIX)) {
                this.skipSpaces();
                int startTagPrefixEndLimit = this.getAqlExpressionEndLimit(CLOSE_PARENTHESIS, "]");
                endTagPrefix = this.parseExpression(startTagPrefixEndLimit);
                this.skipSpaces();
                missingEndTagPrefixCloseParenthesis = this.readMissingString(CLOSE_PARENTHESIS);
                this.skipSpaces();
            } else {
                endTagPrefix = null;
                missingEndTagPrefixCloseParenthesis = -1;
            }
            int missingEndHeader = this.readMissingString("]");
            Block body = this.parseBlock(headerStartLine, significantTextColumn, PROTECTED_AREA_END);
            int missingEnd = this.readMissingString(PROTECTED_AREA_END);
            if (missingOpenParenthesis != -1 || missingCloseParenthesis != -1 || missingStartTagPrefixCloseParenthesis != -1 || missingEndTagPrefixCloseParenthesis != -1 || missingEndHeader != -1 || missingEnd != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorProtectedArea();
                res.setMissingOpenParenthesis(missingOpenParenthesis);
                res.setMissingCloseParenthesis(missingCloseParenthesis);
                res.setMissingStartTagPrefixCloseParenthesis(missingStartTagPrefixCloseParenthesis);
                res.setMissingEndTagPrefixCloseParenthesis(missingEndTagPrefixCloseParenthesis);
                ((ErrorProtectedArea)res).setMissingEndHeader(missingEndHeader);
                ((ErrorProtectedArea)res).setMissingEnd(missingEnd);
                this.errors.add((ErrorProtectedArea)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createProtectedArea();
            }
            res.setId(id);
            res.setStartTagPrefix(startTagPrefix);
            res.setEndTagPrefix(endTagPrefix);
            res.setId(id);
            res.setBody(body);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected ExpressionStatement parseExpressionStatement(boolean inlined) {
        ExpressionStatement res;
        if (this.text.startsWith(EMPTY_EXPRESSION_STATEMENT, this.currentPosition) || !this.text.startsWith(END_BLOCK_PREFIX, this.currentPosition) && !this.text.startsWith(IF_ELSE, this.currentPosition) && this.text.startsWith("[", this.currentPosition)) {
            int startPosition = this.currentPosition;
            this.currentPosition += "[".length();
            this.skipSpaces();
            int expressionEndLimit = this.getAqlExpressionEndLimit("/]", "/]");
            Expression expression = this.parseExpression(expressionEndLimit);
            this.skipSpaces();
            int missingEndHeader = this.readMissingString("/]");
            int newLineLength = AcceleoParser.newLineAt(this.text, this.textLength, this.currentPosition);
            if (missingEndHeader != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorExpressionStatement();
                res.setMissingEndHeader(missingEndHeader);
                this.errors.add((ErrorExpressionStatement)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpressionStatement();
                res.setNewLineNeeded(!inlined && newLineLength != 0);
            }
            res.setExpression(expression);
            if (res.isNewLineNeeded()) {
                this.currentPosition += newLineLength;
            }
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected Expression parseExpression(int endLimit) {
        Expression res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createExpression();
        AQLUtils.AcceleoAQLResult acceleoAqlResult = this.parseWhileAqlExpression(this.text.substring(this.currentPosition, endLimit));
        AstResult astResult = acceleoAqlResult.getAstResult();
        int startPosition = this.currentPosition;
        res.setAst(astResult);
        res.setAql(astResult.getAst());
        int endPosition = this.currentPosition + astResult.getEndPosition((ASTNode)astResult.getAst());
        this.setPositions(res, startPosition, endPosition);
        this.currentPosition += acceleoAqlResult.getEndPosition();
        astResult.addAllPositonsTo(this.positions, startPosition, this.lines[startPosition], this.columns[startPosition]);
        return res;
    }

    protected VisibilityKind parseVisibility() {
        VisibilityKind res = null;
        for (VisibilityKind visibility : VisibilityKind.VALUES) {
            if (!this.text.startsWith(visibility.getName(), this.currentPosition)) continue;
            res = visibility;
            this.currentPosition += visibility.getName().length();
            break;
        }
        return res;
    }

    protected Metamodel parseMetamodel() {
        Metamodel res;
        if (this.readString(QUOTE)) {
            int startPosition = this.currentPosition;
            int nextQuote = this.getNext(QUOTE, CLOSE_PARENTHESIS, "/]");
            if (nextQuote < 0) {
                nextQuote = this.text.length();
            }
            String nsURI = this.text.substring(this.currentPosition, nextQuote);
            this.currentPosition = nextQuote;
            int missingEndQuote = this.readMissingString(QUOTE);
            if (missingEndQuote != -1) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorMetamodel();
                res.setMissingEndQuote(missingEndQuote);
                this.errors.add((ErrorMetamodel)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createMetamodel();
            }
            res.setReferencedPackage(nsURI);
            this.setPositions(res, startPosition, this.currentPosition);
        } else {
            res = null;
        }
        return res;
    }

    protected int getNext(String ... tokens) {
        int res = -1;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            int position = this.text.indexOf(token, this.currentPosition);
            if (position >= 0) {
                res = position;
                break;
            }
            ++n2;
        }
        return res;
    }

    protected TextStatement parseTextStatement(boolean inlined, int significantTextColumn) {
        TextStatement res;
        int endOfText = this.getNext("[");
        if (endOfText < 0) {
            endOfText = this.text.length();
        }
        if (this.currentPosition != endOfText) {
            if (inlined) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
                int nextNewLine = AcceleoParser.nextNewLineIndex(this.text, this.textLength, this.currentPosition);
                if (nextNewLine > -1 && nextNewLine < endOfText) {
                    this.setPositions(res, this.currentPosition, nextNewLine);
                    res.setValue(this.text.substring(this.currentPosition, nextNewLine));
                    res.setNewLineNeeded(true);
                    this.currentPosition = nextNewLine + AcceleoParser.newLineAt(this.text, this.textLength, nextNewLine);
                } else {
                    this.setPositions(res, this.currentPosition, endOfText);
                    res.setValue(this.text.substring(this.currentPosition, endOfText));
                    res.setNewLineNeeded(false);
                    this.currentPosition = endOfText;
                }
            } else {
                res = this.getSignificantTextStatement(significantTextColumn, endOfText);
            }
        } else {
            res = null;
        }
        return res;
    }

    private TextStatement getSignificantTextStatement(int significantTextColumn, int endOfText) {
        TextStatement res;
        int localStartOfText = this.currentPosition;
        int newLineLength = AcceleoParser.newLineAt(this.text, this.textLength, localStartOfText);
        if (this.columns[localStartOfText] == 0 && newLineLength != 0) {
            NewLineStatement newLineStatement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createNewLineStatement();
            newLineStatement.setIndentationNeeded(false);
            newLineStatement.setNewLineNeeded(true);
            newLineStatement.setValue("");
            this.currentPosition += newLineLength;
            this.setPositions(newLineStatement, localStartOfText, this.currentPosition);
            res = newLineStatement;
        } else {
            res = this.getNonEmptyLineTextStatement(significantTextColumn, endOfText);
        }
        return res;
    }

    private TextStatement getNonEmptyLineTextStatement(int significantTextColumn, int endOfText) {
        TextStatement res;
        int localStartOfText = this.currentPosition;
        int newLineLength = AcceleoParser.newLineAt(this.text, this.textLength, localStartOfText);
        if (newLineLength != 0) {
            if (this.columns[localStartOfText] > significantTextColumn) {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
                res.setNewLineNeeded(true);
                res.setValue("");
                this.currentPosition += newLineLength;
                this.setPositions(res, localStartOfText, this.currentPosition);
            } else {
                this.currentPosition += newLineLength;
                res = this.getNonEmptyLineNonEmptyTextTextStatement(significantTextColumn, endOfText);
            }
        } else {
            res = this.getNonEmptyLineNonEmptyTextTextStatement(significantTextColumn, endOfText);
        }
        return res;
    }

    private TextStatement getNonEmptyLineNonEmptyTextTextStatement(int significantTextColumn, int endOfText) {
        TextStatement res;
        int localStartOfText = this.currentPosition;
        boolean hasMarginError = false;
        while (localStartOfText < endOfText && this.columns[localStartOfText] < significantTextColumn) {
            hasMarginError = hasMarginError || !Character.isWhitespace(this.text.charAt(localStartOfText));
            ++localStartOfText;
        }
        if (hasMarginError) {
            String margin = this.text.substring(this.currentPosition, localStartOfText);
            res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorMargin();
            res.setValue(margin.trim());
            res.setNewLineNeeded(this.columns[localStartOfText] == 0);
            this.setPositions(res, this.currentPosition, localStartOfText);
            this.currentPosition = localStartOfText;
        } else {
            int newLineLength = AcceleoParser.newLineAt(this.text, this.textLength, localStartOfText);
            if (newLineLength != 0 && this.columns[localStartOfText] == significantTextColumn) {
                NewLineStatement newLineStatement = AcceleoPackage.eINSTANCE.getAcceleoFactory().createNewLineStatement();
                newLineStatement.setIndentationNeeded(true);
                newLineStatement.setNewLineNeeded(true);
                newLineStatement.setValue("");
                this.currentPosition = localStartOfText + newLineLength;
                this.setPositions(newLineStatement, localStartOfText, this.currentPosition);
                res = newLineStatement;
            } else if (localStartOfText < endOfText) {
                boolean isEmptyLine;
                boolean needNewLine;
                int localEndOfText = localStartOfText;
                while (localEndOfText < endOfText && this.columns[localEndOfText] >= significantTextColumn) {
                    ++localEndOfText;
                }
                if (this.columns[localEndOfText] == 0) {
                    --localEndOfText;
                    needNewLine = true;
                } else {
                    needNewLine = false;
                }
                boolean bl = isEmptyLine = this.columns[localStartOfText] == significantTextColumn && needNewLine;
                if (localStartOfText < localEndOfText || isEmptyLine) {
                    res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createTextStatement();
                    res.setValue(this.text.substring(localStartOfText, localEndOfText));
                    res.setNewLineNeeded(needNewLine);
                    if (needNewLine) {
                        localEndOfText += AcceleoParser.newLineAt(this.text, this.textLength, localEndOfText);
                    }
                    this.setPositions(res, localStartOfText, localEndOfText);
                    this.currentPosition = localEndOfText;
                } else {
                    res = null;
                    this.currentPosition = localEndOfText;
                }
            } else {
                res = null;
                this.currentPosition = endOfText;
            }
        }
        return res;
    }

    protected AQLUtils.AcceleoAQLResult parseWhileAqlExpression(String expression) {
        return AQLUtils.parseWhileAqlExpression((String)expression);
    }

    protected AstResult parseWhileAqlTypeLiteral(String expression) {
        return AQLUtils.parseWhileAqlTypeLiteral((String)expression);
    }

    protected int getAqlExpressionEndLimit(String endDelimiter, String endTag) {
        int res = this.currentPosition;
        int parenthesisDepth = 0;
        int curlyBracketDepth = 0;
        block11: while (res < this.text.length()) {
            if ((this.text.startsWith(endTag, res) || this.endLimitReached(endDelimiter, res)) && this.isProperlyParenthesed(parenthesisDepth, curlyBracketDepth)) break;
            block0 : switch (this.text.charAt(res)) {
                case '\'': {
                    boolean isEscaped = false;
                    ++res;
                    while (res < this.text.length()) {
                        switch (this.text.charAt(res)) {
                            case '\\': {
                                isEscaped = !isEscaped;
                                ++res;
                                break;
                            }
                            case '\'': {
                                if (!isEscaped) {
                                    ++res;
                                    break block0;
                                }
                                ++res;
                                isEscaped = false;
                                break;
                            }
                            default: {
                                ++res;
                                isEscaped = false;
                            }
                        }
                    }
                    continue block11;
                }
                case '{': {
                    ++curlyBracketDepth;
                    ++res;
                    break;
                }
                case '}': {
                    --curlyBracketDepth;
                    ++res;
                    break;
                }
                case '(': {
                    ++parenthesisDepth;
                    ++res;
                    break;
                }
                case ')': {
                    --parenthesisDepth;
                    ++res;
                    break;
                }
                default: {
                    ++res;
                }
            }
        }
        return res;
    }

    private boolean endLimitReached(String endDelimiter, int position) {
        return this.text.startsWith(endDelimiter, position) || this.text.startsWith("[", position);
    }

    private boolean isProperlyParenthesed(int parenthesisDepth, int curlyBracketDepth) {
        return parenthesisDepth == 0 && curlyBracketDepth == 0;
    }
}

