/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.os.OSSupport;

public final class CoordinateUtils {
    private CoordinateUtils() {
    }

    public static Point getDisplayLocation(Control composite) throws Exception {
        Rectangle bounds = composite.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        return CoordinateUtils.getDisplayLocation(composite, x, y);
    }

    public static Point getDisplayLocation(Control composite, int x, int y) throws Exception {
        Composite parent;
        if (EnvironmentUtils.IS_LINUX && composite instanceof Shell) {
            Shell shell = (Shell)composite;
            Point point = composite.toDisplay(0, 0);
            y = point.y;
            Menu menuBar = shell.getMenuBar();
            if (menuBar != null) {
                Rectangle menuBounds = OSSupport.get().getMenuBarBounds(menuBar);
                y -= menuBounds.height;
            }
        }
        if (!(composite instanceof Shell) && (parent = composite.getParent()) != null) {
            Point location = parent.toDisplay(x, y);
            x = location.x;
            y = location.y;
        }
        return new Point(x, y);
    }

    public static org.eclipse.draw2d.geometry.Rectangle getBounds(Control parent, Control child) throws Exception {
        org.eclipse.draw2d.geometry.Rectangle bounds = new org.eclipse.draw2d.geometry.Rectangle(child.getBounds());
        Point childLocation = CoordinateUtils.getDisplayLocation(child);
        Point parentLocation = CoordinateUtils.getDisplayLocation(parent);
        bounds.x = childLocation.x - parentLocation.x;
        bounds.y = childLocation.y - parentLocation.y;
        return bounds;
    }

    public static Insets getClientAreaInsets(Composite composite) throws Exception {
        boolean isParentRTL;
        Point displayLocation = CoordinateUtils.getDisplayLocation((Control)composite);
        Point clientAreaLocation = composite.toDisplay(0, 0);
        Composite parentComposite = composite != null ? composite.getParent() : null;
        boolean isRTL = composite != null && (composite.getStyle() & 0x4000000) != 0;
        boolean bl = isParentRTL = parentComposite != null && (parentComposite.getStyle() & 0x4000000) != 0;
        if (isRTL && !isParentRTL) {
            Rectangle clientArea = composite.getClientArea();
            clientAreaLocation.x -= clientArea.width;
        }
        int top = Math.abs(clientAreaLocation.y - displayLocation.y);
        int left = Math.abs(clientAreaLocation.x - displayLocation.x);
        if (top == 0 && left == 0) {
            return IFigure.NO_INSETS;
        }
        Rectangle bounds = composite.getBounds();
        Rectangle clientArea = composite.getClientArea();
        int bottom = bounds.height - top - clientArea.height;
        int right = bounds.width - left - clientArea.width;
        return new Insets(top, left, bottom, right);
    }

    public static Insets getClientAreaInsets2(Composite composite) throws Exception {
        Insets trimInsets = CoordinateUtils.getClientAreaInsets(composite);
        if (trimInsets.top != 0 || trimInsets.left != 0) {
            return IFigure.NO_INSETS;
        }
        Rectangle bounds = composite.getBounds();
        Rectangle clientArea = composite.getClientArea();
        int top = clientArea.y;
        int left = clientArea.x;
        int bottom = bounds.height - top - clientArea.height;
        int right = bounds.width - left - clientArea.width;
        return new Insets(top, left, bottom, right);
    }
}

