/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.m2m.internal.qvt.oml.compiler.RecursiveUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;

public final class CompositeUnitResolver
implements UnitResolver,
RecursiveUnitResolver {
    private List<UnitResolver> fResolvers;

    public CompositeUnitResolver(UnitResolver ... resolvers) {
        this.fResolvers = new ArrayList<UnitResolver>(resolvers.length);
        UnitResolver[] unitResolverArray = resolvers;
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            UnitResolver unitResolver = unitResolverArray[n2];
            if (unitResolver == null) {
                throw new IllegalArgumentException();
            }
            this.fResolvers.add(unitResolver);
            ++n2;
        }
    }

    @Override
    public final UnitProxy resolveUnit(String qualifiedName) {
        return this.resolveUnit(qualifiedName, new HashSet<RecursiveUnitResolver>());
    }

    @Override
    public final UnitProxy resolveUnit(String qualifiedName, Set<RecursiveUnitResolver> accessedParents) {
        if (accessedParents.contains(this)) {
            return null;
        }
        for (UnitResolver nextResolver : this.fResolvers) {
            UnitProxy unit = null;
            if (nextResolver instanceof RecursiveUnitResolver) {
                accessedParents.add(this);
                unit = ((RecursiveUnitResolver)((Object)nextResolver)).resolveUnit(qualifiedName, accessedParents);
            } else {
                unit = nextResolver.resolveUnit(qualifiedName);
            }
            if (unit == null) continue;
            return unit;
        }
        return null;
    }
}

