/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public abstract class ASMModelElement
extends ASMOclType {
    private ASMModel model;
    private ASMModelElement metaobject;
    private String name;

    protected ASMModelElement(ASMModel model, ASMModelElement metaobject) {
        super(metaobject);
        this.model = model;
        this.metaobject = metaobject;
        this.addSupertype(ASMModelElement.getOclAnyType());
    }

    @Override
    public abstract ASMOclAny get(StackFrame var1, String var2);

    @Override
    public void set(StackFrame frame, String name, ASMOclAny value) {
        if (value instanceof ASMOclUndefined) {
            return;
        }
        if (name.equals("name") && value instanceof ASMString) {
            this.name = ((ASMString)value).getSymbol();
        }
    }

    public String toString() {
        return String.valueOf(this.model.getName()) + "!" + this.name;
    }

    public void setMetaobject(ASMModelElement metaobject) {
        this.metaobject = metaobject;
    }

    public ASMModelElement getMetaobject() {
        return this.metaobject;
    }

    public ASMModel getModel() {
        return this.model;
    }

    @Override
    public String getName() {
        return String.valueOf(this.model.getName()) + "!" + this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public abstract ASMBoolean conformsTo(ASMOclType var1);

    public ASMModelElement getAcquaintance(String name) {
        return null;
    }

    public abstract ASMModelElement getProperty(String var1);

    public abstract ASMModelElement getPropertyType(String var1);

    public static ASMModelElement lookupElementExtended(StackFrame frame, ASMModelElement self, ASMString name) {
        return null;
    }

    public static ASMModelElement otherEnd(StackFrame frame, ASMModelElement self) {
        return null;
    }

    protected static ASMModelElement createNewInstance(StackFrame frame, ASMModelElement self) {
        ASMModel selfModel = self.getModel();
        for (ASMModel model : frame.getExecEnv().getModels().values()) {
            if (!model.isTarget() || !model.getMetamodel().equals(selfModel)) continue;
            return model.newModelElement(self);
        }
        return null;
    }
}

