/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BagType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SetType;

public class MapType
extends OclAnyType {
    private static List<Operation> operations;
    private OclAnyType keyType;
    private OclAnyType valueType;

    public MapType(OclAnyType keyType, OclAnyType valueType) {
        super(new OclType(MapType.computeName(keyType, valueType)));
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public OclAnyType getKeyType() {
        return this.keyType;
    }

    public OclAnyType getValueType() {
        return this.valueType;
    }

    @Override
    protected List<Operation> getTypeOperations() {
        if (operations == null) {
            operations = new ArrayList<Operation>(){
                {
                    this.add(new Operation("get", MapType.getInstance(), null, new HashMap<String, OclAnyType>(){
                        {
                            this.put("key", OclAnyType.getInstance());
                        }
                    }){

                        @Override
                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof MapType) {
                                return ((MapType)context).getValueType();
                            }
                            return null;
                        }
                    });
                    this.add(new Operation("including", MapType.getInstance(), null, (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("key", OclAnyType.getInstance());
                            this.put("val", OclAnyType.getInstance());
                        }
                    }));
                    this.add(new Operation("union", MapType.getInstance(), null, (Map<String, OclAnyType>)new HashMap<String, OclAnyType>(){
                        {
                            this.put("m", MapType.getInstance());
                        }
                    }));
                    this.add(new Operation("getKeys", MapType.getInstance(), null){

                        @Override
                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof MapType) {
                                return SetType.getInstance();
                            }
                            return null;
                        }
                    });
                    this.add(new Operation("getValues", MapType.getInstance(), null){

                        @Override
                        public OclAnyType getType(OclAnyType context, Object ... parameters) {
                            if (context instanceof MapType) {
                                return BagType.getInstance();
                            }
                            return null;
                        }
                    });
                }
            };
        }
        return operations;
    }

    @Override
    public OclAnyType[] getSupertypes() {
        return new OclAnyType[]{OclAnyType.getInstance()};
    }

    private static String computeName(OclAnyType keyType, OclAnyType valueType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Map");
        buffer.append('(');
        buffer.append(keyType.toString());
        buffer.append(", ");
        buffer.append(valueType.toString());
        buffer.append(')');
        return buffer.toString();
    }
}

