/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.dependency;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.ui.dependency.IDependencyProvider;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;

public class DependencyProviderDescriptor {
    private final IConfigurationElement configurationElement;
    private final String attributeClassName;
    private boolean logOnce;
    private IDependencyProvider provider;

    public DependencyProviderDescriptor(String attributeName, IConfigurationElement configurationElement) {
        this.attributeClassName = attributeName;
        this.configurationElement = configurationElement;
    }

    public IDependencyProvider getDependencyProvider() {
        block3: {
            if (this.provider == null && !this.logOnce) {
                try {
                    this.provider = (IDependencyProvider)this.configurationElement.createExecutableExtension(this.attributeClassName);
                }
                catch (CoreException e) {
                    if (this.logOnce) break block3;
                    this.logOnce = true;
                    String className = this.configurationElement.getAttribute(this.attributeClassName);
                    String message = EMFCompareIDEUIMessages.getString("ModelDependencyProviderRegistry.invalidModelDependency", className);
                    Status status = new Status(4, this.configurationElement.getDeclaringExtension().getContributor().getName(), message, (Throwable)e);
                    EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        return this.provider;
    }
}

