/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;

public class TypeReferenceLocator
extends PatternLocator {
    protected TypeReferencePattern pattern;
    protected boolean isDeclarationOfReferencedTypesPattern;

    public TypeReferenceLocator(TypeReferencePattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedTypesPattern = this.pattern instanceof DeclarationOfReferencedTypesPattern;
    }

    protected IModelElement findElement(IModelElement element, int accuracy) {
        if (accuracy != 0) {
            return null;
        }
        DeclarationOfReferencedTypesPattern declPattern = (DeclarationOfReferencedTypesPattern)this.pattern;
        while (element != null && !declPattern.enclosingElement.equals(element)) {
            element = element.getParent();
        }
        return element;
    }

    public int match(SimpleReference ref, MatchingNodeSet nodeSet) {
        if (!(ref instanceof TypeReference)) {
            return 0;
        }
        return this.match((TypeReference)ref, nodeSet);
    }

    @Override
    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch(node, 2);
        }
        if (this.matchesName(this.pattern.simpleName, node.getName().toCharArray())) {
            return nodeSet.addMatch(node, 3);
        }
        return 0;
    }

    @Override
    protected int referenceType() {
        return 7;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

