/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IMakefileReaderProvider;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.BuildInfoFactory;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.make.internal.core.makefile.AbstractMakefile;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.cdt.make.internal.core.makefile.posix.PosixMakefile;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigInfoFactory;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MakeCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.make.core";
    public static final String MAKE_PROJECT_ID = MakeCorePlugin.getUniqueIdentifier() + ".make";
    public static final String OLD_BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    public static final String EXTERNAL_SI_PROVIDER_SIMPLE_ID = "ExternalScannerInfoProvider";
    public static final String SI_CONSOLE_PARSER_SIMPLE_ID = "ScannerInfoConsoleParser";
    public static final String DEFAULT_EXTERNAL_SI_PROVIDER_ID = MakeCorePlugin.getUniqueIdentifier() + ".DefaultExternalScannerInfoProvider";
    public static final String GCC_SPECS_CONSOLE_PARSER_ID = MakeCorePlugin.getUniqueIdentifier() + ".GCCSpecsConsoleParser";
    public static final String GCC_SCANNER_INFO_CONSOLE_PARSER_ID = MakeCorePlugin.getUniqueIdentifier() + ".GCCScannerInfoConsoleParser";
    public static final String MAKEFILE_STYLE = "org.eclipse.cdt.make.core.editor_makefile_style";
    public static final String MAKEFILE_DIRS = "org.eclipse.cdt.make.core.editor_makefile_dirs";
    public static final String CFG_DATA_PROVIDER_ID = "org.eclipse.cdt.make.core.configurationDataProvider";
    private MakeTargetManager fTargetManager;
    private DiscoveredPathManager fDiscoveryPathManager;
    private static MakeCorePlugin plugin;
    private static final String SCANNER_CONFIG;

    static {
        SCANNER_CONFIG = MakeCorePlugin.getUniqueIdentifier() + "/debug/scdiscovery";
    }

    public MakeCorePlugin() {
        plugin = this;
    }

    public static MakeCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        String msg;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if ((msg = e.getMessage()) == null || msg.length() == 0) {
            msg = e.getClass().getSimpleName();
        }
        MakeCorePlugin.log((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), 0, msg, e));
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static String getUniqueIdentifier() {
        if (MakeCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return MakeCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IMakeBuilderInfo createBuildInfo(Preferences prefs, String builderID, boolean useDefaults) {
        return BuildInfoFactory.create(prefs, builderID, useDefaults);
    }

    public static IMakeBuilderInfo createBuildInfo(IProject project, String builderID) throws CoreException {
        return BuildInfoFactory.create(project, builderID);
    }

    public static IMakeBuilderInfo createBuildInfo(Map<String, String> args, String builderID) {
        return BuildInfoFactory.create(args, builderID);
    }

    public IMakeTargetManager getTargetManager() {
        if (this.fTargetManager == null) {
            this.fTargetManager = new MakeTargetManager();
            this.fTargetManager.startup();
        }
        return this.fTargetManager;
    }

    public boolean isMakefileGNUStyle() {
        String style = this.getPluginPreferences().getString(MAKEFILE_STYLE);
        return style != null && style.equalsIgnoreCase("GNU");
    }

    public String[] getMakefileDirs() {
        String stringList = this.getPluginPreferences().getString(MAKEFILE_DIRS);
        StringTokenizer st = new StringTokenizer(stringList, File.pathSeparator + "\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    @Deprecated
    public static IMakefile createMakefile(File file, boolean isGnuStyle, String[] makefileDirs) {
        AbstractMakefile makefile;
        if (isGnuStyle) {
            GNUMakefile gnu = new GNUMakefile();
            ArrayList<String> includeList = new ArrayList<String>();
            includeList.add(new Path(file.getAbsolutePath()).removeLastSegments(1).toOSString());
            includeList.addAll(Arrays.asList(gnu.getIncludeDirectories()));
            includeList.addAll(Arrays.asList(makefileDirs));
            String[] includes = includeList.toArray(new String[includeList.size()]);
            gnu.setIncludeDirectories(includes);
            try {
                gnu.parse(file.getAbsolutePath(), (Reader)new FileReader(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            makefile = gnu;
        } else {
            PosixMakefile posix = new PosixMakefile();
            try {
                posix.parse(file.getAbsolutePath(), (Reader)new FileReader(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            makefile = posix;
        }
        return makefile;
    }

    public static IMakefile createMakefile(IFileStore file, boolean isGnuStyle, String[] makefileDirs) throws CoreException {
        return MakeCorePlugin.createMakefile(file.toURI(), isGnuStyle, makefileDirs, null);
    }

    static IMakefile createMakefile(IFileStore file, boolean isGnuStyle, String[] makefileDirs, String encoding) throws CoreException {
        return MakeCorePlugin.createMakefile(file.toURI(), isGnuStyle, makefileDirs, encoding);
    }

    static IMakefile createMakefile(URI fileURI, boolean isGnuStyle, String[] makefileDirs, String encoding) {
        return MakeCorePlugin.createMakefile(fileURI, isGnuStyle, makefileDirs, new FileStoreReaderProvider(encoding));
    }

    public static IMakefile createMakefile(URI fileURI, boolean isGnuStyle, String[] makefileDirs, IMakefileReaderProvider makefileReaderProvider) {
        AbstractMakefile makefile;
        if (isGnuStyle) {
            GNUMakefile gnu = new GNUMakefile();
            ArrayList<String> includeList = new ArrayList<String>();
            includeList.add(new Path(fileURI.getPath()).removeLastSegments(1).toString());
            includeList.addAll(Arrays.asList(gnu.getIncludeDirectories()));
            includeList.addAll(Arrays.asList(makefileDirs));
            String[] includes = includeList.toArray(new String[includeList.size()]);
            gnu.setIncludeDirectories(includes);
            try {
                gnu.parse(fileURI, makefileReaderProvider);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            makefile = gnu;
        } else {
            PosixMakefile posix = new PosixMakefile();
            try {
                posix.parse(fileURI, makefileReaderProvider);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            makefile = posix;
        }
        return makefile;
    }

    public static IMakefile createMakefile(URI fileURI, boolean isGnuStyle, String[] makefileDirs) {
        return MakeCorePlugin.createMakefile(fileURI, isGnuStyle, makefileDirs, null);
    }

    public IMakefile createMakefile(IFile file) throws CoreException {
        return MakeCorePlugin.createMakefile(EFS.getStore((URI)file.getLocationURI()), this.isMakefileGNUStyle(), this.getMakefileDirs(), file.getCharset());
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fTargetManager != null) {
                this.fTargetManager.shutdown();
                this.fTargetManager = null;
            }
            if (this.fDiscoveryPathManager != null) {
                this.fDiscoveryPathManager.shutdown();
                this.fDiscoveryPathManager = null;
            }
            this.savePluginPreferences();
        }
        finally {
            super.stop(context);
        }
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(Preferences prefs, String builderID, boolean useDefaults) {
        return ScannerConfigInfoFactory.create(prefs, builderID, useDefaults);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(IProject project, String builderID) throws CoreException {
        return ScannerConfigInfoFactory.create(project, builderID);
    }

    public static IScannerConfigBuilderInfo createScannerConfigBuildInfo(Map<String, String> args, String builderID) {
        return ScannerConfigInfoFactory.create(args, builderID);
    }

    public static IPath getWorkingDirectory() {
        return MakeCorePlugin.getDefault().getStateLocation();
    }

    public IDiscoveredPathManager getDiscoveryManager() {
        if (this.fDiscoveryPathManager == null) {
            this.fDiscoveryPathManager = new DiscoveredPathManager();
            this.fDiscoveryPathManager.startup();
        }
        return this.fDiscoveryPathManager;
    }

    public IExternalScannerInfoProvider getExternalScannerInfoProvider(String id) {
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, EXTERNAL_SI_PROVIDER_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    String tool = extensions[i].getUniqueIdentifier();
                    if (tool != null && tool.equals(id)) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < configElements.length) {
                            IConfigurationElement[] runElement = configElements[j].getChildren("run");
                            if (runElement.length > 0) {
                                IExternalScannerInfoProvider builder = (IExternalScannerInfoProvider)runElement[0].createExecutableExtension("class");
                                return builder;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
        return null;
    }

    public String[] getScannerInfoConsoleParserIds(String commandId) {
        IExtensionPoint extension;
        String[] empty = new String[]{};
        if (commandId == null || commandId.length() == 0) {
            commandId = "all";
        }
        if ((extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SI_CONSOLE_PARSER_SIMPLE_ID)) != null) {
            IExtension[] extensions = extension.getExtensions();
            ArrayList<String> parserIds = new ArrayList<String>(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements;
                String id;
                String parserId = extensions[i].getUniqueIdentifier();
                if (parserId != null && (id = (configElements = extensions[i].getConfigurationElements())[0].getAttribute("commandId")) != null && (id.equals(commandId) || id.equals("all"))) {
                    parserIds.add(parserId);
                }
                ++i;
            }
            return parserIds.toArray(empty);
        }
        return empty;
    }

    public IScannerInfoConsoleParser getScannerInfoConsoleParser(String parserId) {
        try {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, SI_CONSOLE_PARSER_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    String id = extensions[i].getUniqueIdentifier();
                    if (id != null && id.equals(parserId)) {
                        IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                        IScannerInfoConsoleParser parser = (IScannerInfoConsoleParser)configElements[0].createExecutableExtension("class");
                        return parser;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        GCCScannerConfigUtil.createSpecs();
    }

    private void configurePluginDebugOptions() {
        String option;
        if (this.isDebugging() && (option = Platform.getDebugOption((String)SCANNER_CONFIG)) != null) {
            TraceUtil.SCANNER_CONFIG = option.equalsIgnoreCase("true");
        }
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }

    private static class FileStoreReaderProvider
    implements IMakefileReaderProvider {
        private final String fEncoding;

        private FileStoreReaderProvider(String encoding) {
            this.fEncoding = encoding != null ? encoding : ResourcesPlugin.getEncoding();
        }

        @Override
        public Reader getReader(URI fileURI) throws IOException {
            try {
                IFileStore store = EFS.getStore((URI)fileURI);
                IFileInfo info = store.fetchInfo();
                if (!info.exists() || info.isDirectory()) {
                    throw new IOException();
                }
                return new InputStreamReader(store.openInputStream(0, null), this.fEncoding);
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                throw new IOException(e.getMessage());
            }
        }
    }
}

