/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.context.common;

import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.context.common.BaseInputKeyWrapper;

public class JavaTransitiveInstancesKey
extends BaseInputKeyWrapper<String> {
    private Class<?> cachedOriginalInstanceClass;
    private Class<?> cachedWrapperInstanceClass;
    private final String nameInJavaCode;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_MAP = Map.of(Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);

    public JavaTransitiveInstancesKey(String jvmClassName, String javaClassName) {
        super(jvmClassName);
        this.nameInJavaCode = javaClassName;
    }

    public JavaTransitiveInstancesKey(Class<?> instanceClass) {
        this(JavaTransitiveInstancesKey.primitiveTypeToWrapperClass(Objects.requireNonNull(instanceClass)).getName(), JavaTransitiveInstancesKey.primitiveTypeToWrapperClass(Objects.requireNonNull(instanceClass)).getCanonicalName());
        this.cachedOriginalInstanceClass = instanceClass;
    }

    @Deprecated(since="2.9")
    public JavaTransitiveInstancesKey(String jvmClassName) {
        this(jvmClassName, jvmClassName.replace('$', '.'));
    }

    private Class<?> getOriginalInstanceClass() {
        if (this.cachedOriginalInstanceClass == null) {
            try {
                this.resolveClassInternal();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.cachedOriginalInstanceClass;
    }

    private Class<?> forceGetOriginalInstanceClass() throws ClassNotFoundException {
        if (this.cachedOriginalInstanceClass == null) {
            this.resolveClassInternal();
        }
        return this.cachedOriginalInstanceClass;
    }

    public Class<?> forceGetWrapperInstanceClass() throws ClassNotFoundException {
        this.forceGetOriginalInstanceClass();
        return this.getWrapperInstanceClass();
    }

    public Class<?> forceGetInstanceClass() throws ClassNotFoundException {
        return this.forceGetWrapperInstanceClass();
    }

    public Class<?> getWrapperInstanceClass() {
        if (this.cachedWrapperInstanceClass == null) {
            this.cachedWrapperInstanceClass = JavaTransitiveInstancesKey.primitiveTypeToWrapperClass(this.getOriginalInstanceClass());
        }
        return this.cachedWrapperInstanceClass;
    }

    public Class<?> getInstanceClass() {
        return this.getWrapperInstanceClass();
    }

    private void resolveClassInternal() throws ClassNotFoundException {
        this.cachedOriginalInstanceClass = Class.forName((String)this.wrappedKey);
    }

    @Override
    public String getPrettyPrintableName() {
        return this.nameInJavaCode;
    }

    @Override
    public String getStringID() {
        return "javaClass#" + this.getPrettyPrintableName();
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    public String toString() {
        return this.getPrettyPrintableName();
    }

    private static Class<?> primitiveTypeToWrapperClass(Class<?> instanceClass) {
        return PRIMITIVE_TYPE_MAP.getOrDefault(instanceClass, instanceClass);
    }
}

