/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public class QueryRegistryTreeInputChange {
  private final boolean entryAffected;

  private final QueryRegistryTreeEntry entry;

  private final boolean pckgAffected;

  private final QueryRegistryTreePackage pckg;

  private final boolean sourceAffected;

  private final QueryRegistryTreeSource source;

  public QueryRegistryTreeInputChange(final boolean entryAffected, final QueryRegistryTreeEntry entry, final boolean pckgAffected, final QueryRegistryTreePackage pckg, final boolean sourceAffected, final QueryRegistryTreeSource source) {
    super();
    this.entryAffected = entryAffected;
    this.entry = entry;
    this.pckgAffected = pckgAffected;
    this.pckg = pckg;
    this.sourceAffected = sourceAffected;
    this.source = source;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + (this.entryAffected ? 1231 : 1237);
    result = prime * result + ((this.entry== null) ? 0 : this.entry.hashCode());
    result = prime * result + (this.pckgAffected ? 1231 : 1237);
    result = prime * result + ((this.pckg== null) ? 0 : this.pckg.hashCode());
    result = prime * result + (this.sourceAffected ? 1231 : 1237);
    return prime * result + ((this.source== null) ? 0 : this.source.hashCode());
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    QueryRegistryTreeInputChange other = (QueryRegistryTreeInputChange) obj;
    if (other.entryAffected != this.entryAffected)
      return false;
    if (this.entry == null) {
      if (other.entry != null)
        return false;
    } else if (!this.entry.equals(other.entry))
      return false;
    if (other.pckgAffected != this.pckgAffected)
      return false;
    if (this.pckg == null) {
      if (other.pckg != null)
        return false;
    } else if (!this.pckg.equals(other.pckg))
      return false;
    if (other.sourceAffected != this.sourceAffected)
      return false;
    if (this.source == null) {
      if (other.source != null)
        return false;
    } else if (!this.source.equals(other.source))
      return false;
    return true;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("entryAffected", this.entryAffected);
    b.add("entry", this.entry);
    b.add("pckgAffected", this.pckgAffected);
    b.add("pckg", this.pckg);
    b.add("sourceAffected", this.sourceAffected);
    b.add("source", this.source);
    return b.toString();
  }

  @Pure
  public boolean isEntryAffected() {
    return this.entryAffected;
  }

  @Pure
  public QueryRegistryTreeEntry getEntry() {
    return this.entry;
  }

  @Pure
  public boolean isPckgAffected() {
    return this.pckgAffected;
  }

  @Pure
  public QueryRegistryTreePackage getPckg() {
    return this.pckg;
  }

  @Pure
  public boolean isSourceAffected() {
    return this.sourceAffected;
  }

  @Pure
  public QueryRegistryTreeSource getSource() {
    return this.source;
  }
}
