/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourceGetter;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SemanticResourcesUpdater
extends AdapterImpl
implements Adapter {
    private static final Collection<EStructuralFeature> FEATURES_OF_INTEREST = Arrays.asList(ViewpointPackage.Literals.DANALYSIS__REFERENCED_ANALYSIS, ViewpointPackage.Literals.DANALYSIS__SEMANTIC_RESOURCES, ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES, ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__CONTROLLED_RESOURCES);
    private DAnalysisSessionImpl session;
    private Collection<Resource> semanticResources;

    public SemanticResourcesUpdater(DAnalysisSessionImpl session) {
        this.session = session;
    }

    public void setSemanticResources(Collection<Resource> semanticResources) {
        for (DAnalysis dAnalysis : this.session.allAnalyses()) {
            if (dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().add((Object)this);
        }
        this.semanticResources = semanticResources;
    }

    public void notifyChanged(Notification msg) {
        if (this.isEventOfInterest(msg)) {
            BasicEList oldValue;
            String uriString;
            URI oldResourceURI;
            Map uriResourceMap;
            if (this.isRemoveSemanticResourceNotification(msg) && this.isRemoveManyStringNotification(msg) && (uriResourceMap = ((ResourceSetImpl)this.semanticResources.iterator().next().getResourceSet()).getURIResourceMap()).containsKey(oldResourceURI = URI.createURI((String)(uriString = (String)(oldValue = (BasicEList)msg.getOldValue()).get(0)))) && !((Resource)uriResourceMap.get(oldResourceURI)).getURI().toString().equals(uriString)) {
                Resource resource = (Resource)uriResourceMap.get(oldResourceURI);
                uriResourceMap.remove(oldResourceURI);
                uriResourceMap.put(resource.getURI(), resource);
            }
            Collection<Resource> updatedSemanticResources = SemanticResourceGetter.collectTopLevelSemanticResources(this.session);
            boolean newSemanticResourceAdded = false;
            for (Resource semanticResource : updatedSemanticResources) {
                if (this.semanticResources.contains(semanticResource)) continue;
                newSemanticResourceAdded = true;
                this.session.registerResourceInCrossReferencer(semanticResource);
            }
            if (newSemanticResourceAdded || this.semanticResources.size() != updatedSemanticResources.size()) {
                this.semanticResources.clear();
                this.semanticResources.addAll(updatedSemanticResources);
                this.session.notifyListeners(11);
            }
        }
    }

    private boolean isEventOfInterest(Notification msg) {
        return msg.getEventType() != 8 && FEATURES_OF_INTEREST.contains(msg.getFeature());
    }

    private boolean isRemoveSemanticResourceNotification(Notification msg) {
        return msg.getFeature() == ViewpointPackage.Literals.DANALYSIS__SEMANTIC_RESOURCES && !this.semanticResources.isEmpty();
    }

    private boolean isRemoveManyStringNotification(Notification msg) {
        return msg.getEventType() == 6 && msg.getOldValue() instanceof BasicEList && !((BasicEList)msg.getOldValue()).isEmpty() && ((BasicEList)msg.getOldValue()).get(0) instanceof String;
    }

    public void dispose() {
        for (DAnalysis dAnalysis : this.session.allAnalyses()) {
            if (!dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().remove((Object)this);
        }
        this.session = null;
        this.semanticResources = null;
    }
}

