/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.richtext.celleditor.config;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.richtext.RichTextPainter;
import org.eclipse.papyrus.infra.emf.nattable.celleditor.config.SingleStringCellEditorConfiguration;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.ui.Activator;
import org.eclipse.papyrus.uml.nattable.richtext.celleditor.RichTextCellEditorWithUMLReferences;
import org.eclipse.papyrus.uml.nattable.richtext.celleditor.config.messages.Messages;
import org.eclipse.papyrus.uml.nattable.richtext.cellpainter.PapyrusRichTextCellPainter;
import org.eclipse.papyrus.uml.tools.namereferences.NameReferencesHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.uml2.uml.UMLPackage;

public class RichTextCellEditorConfiguration
extends SingleStringCellEditorConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.nattable.richtext.cell.editor.axis.configuration";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return Messages.RichTextCellEditorConfiguration_Description;
    }

    public boolean handles(Table table, Object axisElement) {
        boolean result = false;
        Object object = AxisUtils.getRepresentedElement((Object)axisElement);
        if (object instanceof EStructuralFeature) {
            EStructuralFeature feature = (EStructuralFeature)object;
            result = UMLPackage.eINSTANCE.getComment_Body().equals(feature);
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.getCellPainter(configRegistry, axis, configLabel), DisplayMode.NORMAL, configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)this.getCellEditor(configRegistry, axis, configLabel), DisplayMode.EDIT, configLabel);
    }

    protected ICellEditor getCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("useCkEditor")) {
            return new RichTextCellEditorWithUMLReferences();
        }
        return super.getCellEditor(configRegistry, axis, configLabel);
    }

    protected ICellPainter getCellPainter(IConfigRegistry configRegistry, Object axis, String configLabel) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("useHtmlRenderer")) {
            INattableModelManager nattableManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"nattable_model_manager_id"});
            if (nattableManager != null && nattableManager.getTable() != null) {
                Table table = nattableManager.getTable();
                NameReferencesHelper helper = new NameReferencesHelper(table.getContext().eResource());
                boolean wrapTextFlag = StyleUtils.getBooleanNamedStyleValue((Table)table, (String)"wrapText");
                boolean autoResizeCellHeightFlag = StyleUtils.getBooleanNamedStyleValue((Table)table, (String)"autoResizeCellHeight");
                CustomPapyrusRichTextCellPainter pCellPainter = new CustomPapyrusRichTextCellPainter(wrapTextFlag, false, autoResizeCellHeightFlag, (TextReferencesHelper)helper);
                return new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)pCellPainter, 2, 5, 2, 5));
            }
            return new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new PapyrusRichTextCellPainter(), 2, 5, 2, 5));
        }
        return super.getCellPainter(configRegistry, axis, configLabel);
    }

    private class CustomPapyrusRichTextCellPainter
    extends PapyrusRichTextCellPainter {
        private final TextReferencesHelper helper;

        public CustomPapyrusRichTextCellPainter(boolean wrapText, boolean calculateByTextLength, boolean calculateByTextHeight, TextReferencesHelper helper) {
            super(wrapText, calculateByTextLength, calculateByTextHeight);
            Assert.isNotNull((Object)helper);
            this.helper = helper;
            this.richTextPainter = new PapyrusRichTextPainter(wrapText, this.helper);
        }
    }

    private class PapyrusRichTextPainter
    extends RichTextPainter {
        private final TextReferencesHelper helper;

        public PapyrusRichTextPainter(boolean wordWrap, TextReferencesHelper helper) {
            super(wordWrap);
            this.helper = helper;
        }

        public void paintHTML(String html, GC gc, Rectangle bounds) {
            super.paintHTML(this.helper.replaceReferences(html), gc, bounds);
        }
    }
}

