/*******************************************************************************
 * Copyright (c) 2001, 2019 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.j2ee.webapplication;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.J2EEEObject;
/**
 * @generated
 * The web-resource-collection element is used to identify a subset of the resources and HTTP methods on those resources within a web application to which a security constraint applies. If no HTTP methods are specified, then the security constraint applies to all HTTP methods.
 * @since 1.0
 */
public interface WebResourceCollection extends J2EEEObject {

	/**
	 * Adds instance of HTTPMethodType
	 * @param httpMethod name of the httpMethod to add
	 */
	public void addHTTP(String httpMethod);
	
	/**
	 * Adds instance of URLPatternType
	 * @param urlPattern name of the url to add
	 */
	public void addURL(String urlPattern);
	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return The value of the WebResourceName attribute
	 * The web-resource-name contains the name of this web resource collection
	 */
	String getWebResourceName();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @param value The new value of the WebResourceName attribute
	 */
	void setWebResourceName(String value);

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return The value of the Description attribute
	 */
	String getDescription();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @param value The new value of the Description attribute
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Url Pattern</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Url Pattern</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @version J2EE1.4
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Url Pattern</em>' attribute list.
	 * @see org.eclipse.jst.j2ee.webapplication.WebapplicationPackage#getWebResourceCollection_UrlPattern()
	 * @model type="java.lang.String" unique="false" required="true"
	 * @generated
	 */
	EList getUrlPattern();

	/**
	 * Returns the value of the '<em><b>Http Method</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum}.
	 * The literals are from the enumeration {@link org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Http Method</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @version J2EE1.4
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Http Method</em>' attribute list.
	 * @see org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum
	 * @see org.eclipse.jst.j2ee.webapplication.WebapplicationPackage#getWebResourceCollection_HttpMethod()
	 * @model type="org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum"
	 * @generated
	 */
	EList getHttpMethod();

	/**
	 * @deprecated : Use getHttpMethod();
	 * @return List of HttpMethods
	 */
	EList getHTTPs();
	
	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return The SecConstraint reference
	 */
	
	
	SecurityConstraint getSecConstraint();

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @param value The new value of the SecConstraint reference
	 */
	void setSecConstraint(SecurityConstraint value);

	/**
	 * @generated This field/method will be replaced during code generation 
	 * @return The list of URLs references
	 */
	EList getURLs();

	/**
	 * Returns the value of the '<em><b>Descriptions</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.jst.j2ee.common.Description}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Descriptions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @version J2EE1.4
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptions</em>' containment reference list.
	 * @see org.eclipse.jst.j2ee.webapplication.WebapplicationPackage#getWebResourceCollection_Descriptions()
	 * @model type="org.eclipse.jst.j2ee.common.Description" containment="true"
	 * @generated
	 */
	EList getDescriptions();

}














