/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyMessages;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalExpressionTypes;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;

public abstract class Expression
implements IExpression {
    private ArrayList controlStack = new ArrayList(30);
    protected final ProxyFactoryRegistry registry;
    protected final IStandardBeanProxyFactory beanProxyFactory;
    protected Boolean traceFlag;
    private static final Integer ARRAYACCESS_INDEX_1 = new Integer(1);
    private static final Integer ARRAY_CREATION_DIMENSION_1 = new Integer(1);
    private static final Integer ARRAY_CREATION_DIMENSION_0 = new Integer(0);
    private static final ForExpression ARRAY_INITIALIZER = new ExpressionEnum(-2147483647, "Array Initializer Internal");
    private static final Integer ARRAYINITIALIZER_COUNT_0 = new Integer(0);
    private static final Integer ARRAYINITIALIZER_COUNT_1 = new Integer(1);
    private static final Integer ARRAYINITIALIZER_COUNT_2 = new Integer(2);
    private static final Integer CLASS_INSTANCE_CREATION_ARGUMENTS_1 = new Integer(1);
    private static final Integer CLASS_INSTANCE_CREATION_ARGUMENTS_0 = new Integer(0);
    private static final Integer METHOD_ARGUMENTS_1 = new Integer(1);
    private static final Integer METHOD_ARGUMENTS_0 = new Integer(0);
    private ForExpression[] nextForExpressionStack = new ForExpression[30];
    private int nextForExpressionStackPos = -1;
    private boolean expressionValid = true;
    private String invalidMsg = null;
    private List expressionProxies;
    private int highestMarkID = 0;
    private MarkEntry currentMarkEntry;
    private List markEntries;
    private static final ForExpression PROCESS_EXPRESSION = new ExpressionEnum(Integer.MIN_VALUE, "Process Expression");
    private static final ForExpression BLOCKEND_EXPRESSION = new ExpressionEnum(PROCESS_EXPRESSION.getValue() - 2, "End Block Expression");
    private static final ForExpression TRYEND_EXPRESSION = new ExpressionEnum(BLOCKEND_EXPRESSION.getValue() - 1, "End Try Expression");
    private static final ForExpression TRYCATCH_EXPRESSION = new ExpressionEnum(TRYEND_EXPRESSION.getValue() - 1, "Catch Expression");
    private static final ForExpression THREADTRANSFER_EXPRESSION = new ExpressionEnum(TRYCATCH_EXPRESSION.getValue() - 1, "Catch Expression");
    private static final ForExpression SUBEXPRESSIONEND_EXPRESSION = new ExpressionEnum(THREADTRANSFER_EXPRESSION.getValue() - 2, "End Subexpression");
    private int blockNumber = -1;
    protected static final int NORMAL_EXPRESSION_PROXY = 0;
    protected static final int BEANTYPE_EXPRESSION_PROXY = 1;
    protected static final int METHOD_EXPRESSION_PROXY = 2;
    protected static final int FIELD_EXPRESSION_PROXY = 3;
    private int subexpressionNumber = -1;
    private int tryNumber = -1;

    public boolean isTraceSet() {
        return this.traceFlag != null;
    }

    public boolean isTrace() {
        return this.traceFlag != null ? this.traceFlag : false;
    }

    public void setTrace(boolean trace) {
        this.traceFlag = trace;
    }

    protected final void push(Object o) {
        this.controlStack.add(o);
    }

    protected final Object pop() {
        return this.controlStack.remove(this.controlStack.size() - 1);
    }

    protected final Object peek(int fromTop) {
        return this.controlStack.get(this.controlStack.size() - fromTop);
    }

    protected final void checkForExpression(ForExpression forExpression) throws IllegalStateException {
        if (this.expressionValid) {
            if (this.nextForExpressionStackPos == -1) {
                if (forExpression == ForExpression.ROOTEXPRESSION) {
                    return;
                }
            } else if (this.nextForExpressionStack[this.nextForExpressionStackPos] == forExpression) {
                if (forExpression != ForExpression.ROOTEXPRESSION) {
                    this.popForExpression();
                }
                return;
            }
        } else {
            String expMsg = this.invalidMsg != null ? MessageFormat.format(ProxyMessages.Expression_InInvalidStateDueTo_EXC_, this.invalidMsg) : ProxyMessages.Expression_InInvalidState_EXC_;
            throw new IllegalStateException(expMsg);
        }
        ForExpression expected = this.nextForExpressionStackPos >= 0 ? this.nextForExpressionStack[this.nextForExpressionStackPos] : ForExpression.ROOTEXPRESSION;
        this.expressionValid = false;
        throw new IllegalStateException(MessageFormat.format(ProxyMessages.Expression_TypeSentInInvalidOrder_EXC_, forExpression, expected));
    }

    protected final void popForExpression() throws IllegalStateException {
        if (this.expressionValid && this.nextForExpressionStackPos >= 0) {
            --this.nextForExpressionStackPos;
            if (this.currentMarkEntry != null && this.nextForExpressionStackPos < this.currentMarkEntry.nextExpressionStackPos) {
                ++this.nextForExpressionStackPos;
                this.throwInvalidMarkNesting();
            }
        }
    }

    private void throwInvalidMarkNesting() throws IllegalStateException {
        this.expressionValid = false;
        throw new IllegalStateException(MessageFormat.format(ProxyMessages.Expression_InvalidMarkNesting, new Integer(this.currentMarkEntry != null ? this.currentMarkEntry.markID : 0)));
    }

    protected final boolean peekForExpression(ForExpression forExpression) {
        return this.expressionValid && (this.nextForExpressionStackPos == -1 ? forExpression == ForExpression.ROOTEXPRESSION : this.nextForExpressionStack[this.nextForExpressionStackPos] == forExpression);
    }

    protected final void markInvalid() {
        this.expressionValid = false;
    }

    protected final void markInvalid(String msg) {
        this.invalidMsg = msg;
        this.markInvalid();
    }

    @Override
    public void close() {
        this.nextForExpressionStackPos = -1;
        this.controlStack.clear();
        if (this.expressionProxies != null) {
            this.markAllProxiesNotResolved(this.expressionProxies);
        }
        this.expressionProxies = null;
        this.markEntries = null;
        this.expressionValid = false;
        this.closeProxy();
    }

    @Override
    public boolean isValid() {
        return this.expressionValid;
    }

    private boolean expressionReady() {
        if (this.nextForExpressionStackPos >= 0 && this.nextForExpressionStack[this.nextForExpressionStackPos] == PROCESS_EXPRESSION) {
            this.checkForExpression(PROCESS_EXPRESSION);
            return true;
        }
        return false;
    }

    private void pushForExpression(ForExpression nextExpression) {
        if (++this.nextForExpressionStackPos >= this.nextForExpressionStack.length) {
            ForExpression[] newStack = new ForExpression[this.nextForExpressionStackPos * 2];
            System.arraycopy(this.nextForExpressionStack, 0, newStack, 0, this.nextForExpressionStack.length);
            this.nextForExpressionStack = newStack;
        }
        this.nextForExpressionStack[this.nextForExpressionStackPos] = nextExpression;
    }

    private void processExpression() {
        while (this.expressionReady()) {
            try {
                int expType = ((InternalExpressionTypes)this.pop()).getValue();
                switch (expType) {
                    case 4: {
                        this.pushCastToProxy((IProxyBeanType)this.pop());
                        break;
                    }
                    case 8: {
                        this.pushInstanceofToProxy((IProxyBeanType)this.pop());
                        break;
                    }
                    case 11: {
                        this.pushPrefixToProxy((PrefixOperator)this.pop());
                        break;
                    }
                    case 9: {
                        this.pushInfixToProxy((InfixOperator)this.pop(), (InternalInfixOperandType)this.pop());
                        break;
                    }
                    case 1: {
                        this.pushArrayAccessToProxy((Integer)this.pop());
                        break;
                    }
                    case 2: {
                        this.pushArrayCreationToProxy((IProxyBeanType)this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 3: {
                        this.pushArrayInitializerToProxy((IProxyBeanType)this.pop(), (Integer)this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 6: {
                        this.pushClassInstanceCreationToProxy((IProxyBeanType)this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 7: {
                        this.pushFieldAccessToProxy(this.pop(), (Boolean)this.pop());
                        break;
                    }
                    case 10: {
                        this.pushMethodInvocationToProxy(this.pop(), (Boolean)this.pop(), (Integer)this.pop());
                        break;
                    }
                    case 5: {
                        this.pushConditionalToProxy((InternalConditionalOperandType)this.pop());
                        break;
                    }
                    case 15: {
                        this.pushAssignmentToProxy((ExpressionProxy)this.pop());
                        break;
                    }
                    case 17: {
                        this.pushAssignmentToProxy();
                        break;
                    }
                    case 20: {
                        this.pushBlockEndToProxy((Integer)this.pop());
                        break;
                    }
                    case 24: {
                        this.pushTryEndToProxy((Integer)this.pop());
                        break;
                    }
                    case 25: {
                        this.pushThrowToProxy();
                        break;
                    }
                    case 30: {
                        this.pushIfTestToProxy();
                        break;
                    }
                    case 29: {
                        this.pushIfElseToProxy((InternalIfElseOperandType)this.pop());
                        break;
                    }
                    case 35: {
                        this.pushSubexpressionEndToProxy((Integer)this.pop());
                        break;
                    }
                    default: {
                        this.internalProcessUnknownExpressionType(expType);
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                this.markInvalid();
                throw e;
            }
        }
    }

    private void internalProcessUnknownExpressionType(int expressionType) throws IllegalArgumentException {
        if (!this.processUnknownExpressionType(expressionType)) {
            throw new IllegalArgumentException();
        }
    }

    protected boolean processUnknownExpressionType(int expressionType) {
        return false;
    }

    protected Expression(ProxyFactoryRegistry registry) {
        this.registry = registry;
        this.beanProxyFactory = this.registry.getBeanProxyFactory();
    }

    @Override
    public ProxyFactoryRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public final void invokeExpression() throws ThrowableProxy, IllegalStateException, NoExpressionValueException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            List proxies = this.expressionProxies;
            this.expressionProxies = null;
            this.pushInvoke(this.processExpressionProxyCallbacks(proxies), proxies);
        }
        finally {
            this.markInvalid();
            this.close();
        }
    }

    private int processExpressionProxyCallbacks(List proxies) {
        if (proxies != null) {
            int proxiesWithCallbacks = 0;
            ListIterator eps = proxies.listIterator();
            while (eps.hasNext()) {
                ExpressionProxy proxy = (ExpressionProxy)eps.next();
                if (!proxy.hasListeners()) {
                    eps.set(null);
                    continue;
                }
                ++proxiesWithCallbacks;
            }
            return proxiesWithCallbacks;
        }
        return 0;
    }

    private void validateProxy(IProxy proxy) throws IllegalArgumentException {
        if (proxy != null && proxy.isExpressionProxy() && ((ExpressionProxy)proxy).getExpression() != this) {
            throw new IllegalArgumentException(ProxyMessages.Expression_InvalidProxy);
        }
    }

    protected void fireProxyResolved(ExpressionProxy ep, IBeanProxy beanproxy) {
        ep.fireResolved(beanproxy);
    }

    protected void fireProxyNotResolved(ExpressionProxy ep) {
        ep.fireNotResolved();
    }

    protected void fireProxyVoid(ExpressionProxy ep) {
        ep.fireVoidResolved();
    }

    @Override
    public final IBeanProxy getExpressionValue() throws ThrowableProxy, NoExpressionValueException, IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            List proxies = this.expressionProxies;
            this.expressionProxies = null;
            IBeanProxy iBeanProxy = this.pullProxyValue(this.processExpressionProxyCallbacks(proxies), proxies);
            return iBeanProxy;
        }
        finally {
            this.markInvalid();
            this.close();
        }
    }

    protected void markAllProxiesNotResolved(List proxies) {
        if (proxies != null) {
            ListIterator eps = proxies.listIterator();
            while (eps.hasNext()) {
                ExpressionProxy proxy = (ExpressionProxy)eps.next();
                if (proxy == null || !proxy.hasListeners()) continue;
                this.fireProxyNotResolved(proxy);
            }
        }
    }

    @Override
    public final int createBlockBegin() throws IllegalStateException {
        try {
            if (this.peekForExpression(ForExpression.ROOTEXPRESSION)) {
                this.checkForExpression(ForExpression.ROOTEXPRESSION);
            } else if (this.peekForExpression(ForExpression.IF_TRUE)) {
                this.checkForExpression(ForExpression.IF_TRUE);
            } else {
                this.checkForExpression(ForExpression.IF_ELSE);
            }
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(BLOCKEND_EXPRESSION);
            this.pushForExpression(ForExpression.ROOTEXPRESSION);
            this.pushBlockBeginToProxy(++this.blockNumber);
            this.push(new Integer(this.blockNumber));
            this.push(InternalExpressionTypes.BLOCK_END_EXPRESSION);
            this.processExpression();
            return this.blockNumber;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createBlockBreak(int blockNumber) throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.pushBlockBreakToProxy(blockNumber);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createBlockEnd() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(BLOCKEND_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createArrayAccess(ForExpression forExpression, int indexCount) {
        try {
            this.checkForExpression(forExpression);
            this.pushForExpression(PROCESS_EXPRESSION);
            int i = indexCount;
            while (i-- > 0) {
                this.pushForExpression(ForExpression.ARRAYACCESS_INDEX);
            }
            this.pushForExpression(ForExpression.ARRAYACCESS_ARRAY);
            this.push(indexCount == 1 ? ARRAYACCESS_INDEX_1 : new Integer(indexCount));
            this.push(InternalExpressionTypes.ARRAY_ACCESS_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createArrayCreation(ForExpression forExpression, String type, int dimensionExpressionCount) throws IllegalStateException {
        this.pushArrayCreation(forExpression, this.getProxyBeanType(type), dimensionExpressionCount);
    }

    @Override
    public final void createArrayCreation(ForExpression forExpression, IProxyBeanType type, int dimensionExpressionCount) throws IllegalStateException, IllegalArgumentException {
        this.pushArrayCreation(forExpression, type, dimensionExpressionCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushArrayCreation(ForExpression forExpression, IProxyBeanType type, int dimensionExpressionCount) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            this.validateProxy(type);
            switch (dimensionExpressionCount) {
                case 0: {
                    this.push(ARRAY_CREATION_DIMENSION_0);
                    break;
                }
                case 1: {
                    this.push(ARRAY_CREATION_DIMENSION_1);
                    break;
                }
                default: {
                    this.push(new Integer(dimensionExpressionCount));
                }
            }
            this.push(type);
            this.push(InternalExpressionTypes.ARRAY_CREATION_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            if (dimensionExpressionCount == 0) {
                this.pushForExpression(ARRAY_INITIALIZER);
            } else {
                while (dimensionExpressionCount-- > 0) {
                    this.pushForExpression(ForExpression.ARRAYCREATION_DIMENSION);
                }
            }
            this.processExpression();
            return;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createArrayInitializer(int expressionCount) throws IllegalStateException {
        try {
            if (this.peekForExpression(ARRAY_INITIALIZER)) {
                this.checkForExpression(ARRAY_INITIALIZER);
            } else {
                this.checkForExpression(ForExpression.ARRAYINITIALIZER_EXPRESSION);
            }
            Object arrayType = this.peek(2);
            int stripCount = 0;
            if (this.peek(1) == InternalExpressionTypes.ARRAY_INITIALIZER_EXPRESSION) {
                stripCount = (Integer)this.peek(3);
            }
            switch (expressionCount) {
                case 0: {
                    this.push(ARRAYINITIALIZER_COUNT_0);
                    break;
                }
                case 1: {
                    this.push(ARRAYINITIALIZER_COUNT_1);
                    break;
                }
                case 2: {
                    this.push(ARRAYINITIALIZER_COUNT_2);
                    break;
                }
                default: {
                    this.push(new Integer(expressionCount));
                }
            }
            if (arrayType instanceof String) {
                String at = (String)arrayType;
                int i = at.lastIndexOf("[]");
                if (i == -1) {
                    throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.Expression_ArrayTypeNotAnArray_EXC_, arrayType));
                }
                arrayType = this.getProxyBeanType(at);
            } else if (!(arrayType instanceof IProxyBeanType)) {
                throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.Expression_ArrayTypeNotAnArray_EXC_, arrayType));
            }
            this.push(new Integer(++stripCount));
            this.push(arrayType);
            this.push(InternalExpressionTypes.ARRAY_INITIALIZER_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            while (expressionCount-- > 0) {
                this.pushForExpression(ForExpression.ARRAYINITIALIZER_EXPRESSION);
            }
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createCastExpression(ForExpression forExpression, String type) throws IllegalStateException {
        this.pushCast(forExpression, this.getProxyBeanType(type));
    }

    @Override
    public final void createCastExpression(ForExpression forExpression, IProxyBeanType type) throws IllegalStateException, IllegalArgumentException {
        this.pushCast(forExpression, type);
    }

    private void pushCast(ForExpression forExpression, IProxyBeanType type) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            this.validateProxy(type);
            this.push(type);
            this.push(InternalExpressionTypes.CAST_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.CAST_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createClassInstanceCreation(ForExpression forExpression, String type, int argumentCount) throws IllegalStateException {
        this.pushClassInstanceCreation(forExpression, this.getProxyBeanType(type), argumentCount);
    }

    @Override
    public final void createClassInstanceCreation(ForExpression forExpression, IProxyBeanType type, int argumentCount) throws IllegalStateException, IllegalArgumentException {
        this.pushClassInstanceCreation(forExpression, type, argumentCount);
    }

    private void pushClassInstanceCreation(ForExpression forExpression, IProxyBeanType type, int argumentCount) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            this.validateProxy(type);
            switch (argumentCount) {
                case 0: {
                    this.push(CLASS_INSTANCE_CREATION_ARGUMENTS_0);
                    break;
                }
                case 1: {
                    this.push(CLASS_INSTANCE_CREATION_ARGUMENTS_1);
                    break;
                }
                default: {
                    this.push(new Integer(argumentCount));
                }
            }
            this.push(type);
            this.push(InternalExpressionTypes.CLASS_INSTANCE_CREATION_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            while (argumentCount-- > 0) {
                this.pushForExpression(ForExpression.CLASSINSTANCECREATION_ARGUMENT);
            }
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createConditionalExpression(ForExpression forExpression) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.CONDITIONAL_FALSE);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.CONDITIONAL_TRUE);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.CONDITIONAL_CONDITION);
            this.push(InternalConditionalOperandType.CONDITIONAL_FALSE);
            this.push(InternalExpressionTypes.CONDITIONAL_EXPRESSION);
            this.push(InternalConditionalOperandType.CONDITIONAL_TRUE);
            this.push(InternalExpressionTypes.CONDITIONAL_EXPRESSION);
            this.push(InternalConditionalOperandType.CONDITIONAL_TEST);
            this.push(InternalExpressionTypes.CONDITIONAL_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createFieldAccess(ForExpression forExpression, String fieldName, boolean hasReceiver) throws IllegalStateException, IllegalArgumentException {
        try {
            if (!hasReceiver) {
                throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.Expression_CannotHandleNoReceiveOnFieldAccess_EXC_, fieldName));
            }
            this.pushFieldAccess(forExpression, fieldName, hasReceiver);
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createIfElse(boolean hasElseClause) throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            if (hasElseClause) {
                this.pushForExpression(ForExpression.IF_ELSE);
            }
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.IF_TRUE);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.IF_CONDITION);
            this.push(InternalIfElseOperandType.ELSE_CLAUSE);
            this.push(InternalExpressionTypes.IF_ELSE_EXPRESSION);
            this.push(InternalIfElseOperandType.TRUE_CLAUSE);
            this.push(InternalExpressionTypes.IF_ELSE_EXPRESSION);
            this.push(InternalExpressionTypes.IF_TEST_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    private void pushFieldAccess(ForExpression forExpression, Object field, boolean hasReceiver) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.push(hasReceiver ? Boolean.TRUE : Boolean.FALSE);
            this.push(field);
            this.push(InternalExpressionTypes.FIELD_ACCESS_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            if (hasReceiver) {
                this.pushForExpression(ForExpression.FIELD_RECEIVER);
            }
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createInfixExpression(ForExpression forExpression, InfixOperator operator, int extendedOperandCount) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.push(InternalInfixOperandType.INFIX_LAST_OPERAND);
            this.push(operator);
            this.push(InternalExpressionTypes.INFIX_EXPRESSION);
            int i = extendedOperandCount;
            while (i-- > 0) {
                this.push(InternalInfixOperandType.INFIX_OTHER_OPERAND);
                this.push(operator);
                this.push(InternalExpressionTypes.INFIX_EXPRESSION);
            }
            this.push(InternalInfixOperandType.INFIX_LEFT_OPERAND);
            this.push(operator);
            this.push(InternalExpressionTypes.INFIX_EXPRESSION);
            i = extendedOperandCount;
            while (i-- > 0) {
                this.pushForExpression(PROCESS_EXPRESSION);
                this.pushForExpression(ForExpression.INFIX_EXTENDED);
            }
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.INFIX_RIGHT);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.INFIX_LEFT);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createInstanceofExpression(ForExpression forExpression, String type) throws IllegalStateException {
        this.pushInstanceof(forExpression, this.getProxyBeanType(type));
    }

    @Override
    public final void createInstanceofExpression(ForExpression forExpression, IProxyBeanType type) throws IllegalStateException, IllegalArgumentException {
        this.pushInstanceof(forExpression, type);
    }

    private void pushInstanceof(ForExpression forExpression, IProxyBeanType type) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            this.validateProxy(type);
            this.push(type);
            this.push(InternalExpressionTypes.INSTANCEOF_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.INSTANCEOF_VALUE);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createMethodInvocation(ForExpression forExpression, String name, boolean hasReceiver, int argumentCount) throws IllegalStateException, IllegalArgumentException {
        try {
            if (!hasReceiver) {
                throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.Expression_MethodsNeedReceiver_EXC_, name));
            }
            this.pushMethodInvocation(forExpression, name, hasReceiver, argumentCount);
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    private void pushMethodInvocation(ForExpression forExpression, Object method, boolean hasReceiver, int argumentCount) throws IllegalArgumentException, IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            switch (argumentCount) {
                case 0: {
                    this.push(METHOD_ARGUMENTS_0);
                    break;
                }
                case 1: {
                    this.push(METHOD_ARGUMENTS_1);
                    break;
                }
                default: {
                    this.push(new Integer(argumentCount));
                }
            }
            this.push(hasReceiver ? Boolean.TRUE : Boolean.FALSE);
            this.push(method);
            this.push(InternalExpressionTypes.METHOD_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            while (argumentCount-- > 0) {
                this.pushForExpression(ForExpression.METHOD_ARGUMENT);
            }
            if (hasReceiver) {
                this.pushForExpression(ForExpression.METHOD_RECEIVER);
            }
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrefixExpression(ForExpression forExpression, PrefixOperator operator) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.push(operator);
            this.push(InternalExpressionTypes.PREFIX_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.PREFIX_OPERAND);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void createNewInstance(ForExpression forExpression, String initializationString, IProxyBeanType type) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            this.validateProxy(type);
            this.pushNewInstanceToProxy(initializationString, type);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createNull(ForExpression forExpression) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(null);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createTypeLiteral(ForExpression forExpression, String type) throws IllegalStateException {
        this.createProxyExpression(forExpression, this.getProxyBeanType(type));
    }

    @Override
    public final void createTypeReceiver(String type) throws IllegalStateException {
        this.pushTypeReceiver(this.getProxyBeanType(type));
    }

    @Override
    public final void createTypeReceiver(IProxyBeanType type) throws IllegalStateException, IllegalArgumentException {
        this.validateProxy(type);
        this.pushTypeReceiver(type);
    }

    private void pushTypeReceiver(IProxyBeanType type) throws IllegalStateException {
        try {
            if (this.peekForExpression(ForExpression.FIELD_RECEIVER)) {
                this.checkForExpression(ForExpression.FIELD_RECEIVER);
            } else {
                this.checkForExpression(ForExpression.METHOD_RECEIVER);
            }
            this.pushTypeReceiverToProxy(type);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, boolean value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, char value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, byte value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, double value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, float value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, int value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, long value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createPrimitiveLiteral(ForExpression forExpression, short value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createStringLiteral(ForExpression forExpression, String value) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.pushToProxy(this.beanProxyFactory.createBeanProxyWith(value));
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createProxyExpression(ForExpression forExpression, IProxy proxy) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            this.validateProxy(proxy);
            this.pushToProxy(proxy);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createAssignmentExpression(ForExpression forExpression) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            this.push(InternalExpressionTypes.ASSIGNMENT_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.ASSIGNMENT_RIGHT);
            this.pushForExpression(ForExpression.ASSIGNMENT_LEFT);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final ExpressionProxy createProxyAssignmentExpression(ForExpression forExpression) throws IllegalStateException {
        try {
            this.checkForExpression(forExpression);
            ExpressionProxy proxy = this.allocateExpressionProxy(0);
            this.push(proxy);
            this.push(InternalExpressionTypes.ASSIGNMENT_PROXY_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.ASSIGNMENT_RIGHT);
            this.processExpression();
            return proxy;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final IProxyBeanType createBeanTypeExpressionProxy(String typeName) {
        IBeanTypeExpressionProxy proxy = (IBeanTypeExpressionProxy)((Object)this.allocateExpressionProxy(1));
        proxy.setTypeName(typeName);
        this.pushBeanTypeToProxy(proxy);
        return proxy;
    }

    public final IProxyMethod createMethodExpressionProxy(IProxyBeanType declaringType, String methodName, IProxyBeanType[] parameterTypes) throws IllegalArgumentException {
        this.validateProxy(declaringType);
        if (parameterTypes != null && parameterTypes.length > 0) {
            int i = 0;
            while (i < parameterTypes.length) {
                this.validateProxy(parameterTypes[i]);
                ++i;
            }
        }
        ExpressionProxy proxy = this.allocateExpressionProxy(2);
        this.pushMethodToProxy(proxy, declaringType, methodName, parameterTypes);
        return (IProxyMethod)((Object)proxy);
    }

    public final IProxyField createFieldExpressionProxy(IProxyBeanType declaringType, String fieldName) throws IllegalArgumentException {
        this.validateProxy(declaringType);
        ExpressionProxy proxy = this.allocateExpressionProxy(3);
        this.pushFieldToProxy(proxy, declaringType, fieldName);
        return (IProxyField)((Object)proxy);
    }

    @Override
    public final void createProxyReassignmentExpression(ForExpression forExpression, ExpressionProxy proxy) throws IllegalStateException, IllegalArgumentException {
        try {
            this.checkForExpression(forExpression);
            if (!proxy.isValidForReassignment()) {
                throw new IllegalArgumentException(MessageFormat.format(ProxyMessages.Expression_CreateProxyReassignmentExpression_InvalidForReassignment_EXC_, proxy.toString()));
            }
            this.push(proxy);
            this.push(InternalExpressionTypes.ASSIGNMENT_PROXY_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.ASSIGNMENT_RIGHT);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    protected final ExpressionProxy allocateExpressionProxy(int proxyType) {
        if (this.expressionProxies == null) {
            this.expressionProxies = new ArrayList();
        }
        ExpressionProxy proxy = this.createExpressionProxy(proxyType, this.expressionProxies.size());
        this.expressionProxies.add(proxy);
        return proxy;
    }

    @Override
    public final void createFieldAccess(ForExpression forExpression, IProxyField fieldProxy, boolean hasReceiver) throws IllegalStateException, IllegalArgumentException {
        this.validateProxy(fieldProxy);
        this.pushFieldAccess(forExpression, fieldProxy, hasReceiver);
    }

    @Override
    public final void createMethodInvocation(ForExpression forExpression, IProxyMethod methodProxy, boolean hasReceiver, int argumentCount) throws IllegalArgumentException, IllegalStateException {
        this.validateProxy(methodProxy);
        this.pushMethodInvocation(forExpression, methodProxy, hasReceiver, argumentCount);
    }

    @Override
    public final ExpressionProxy createSimpleFieldAccess(IProxyField field, IProxy receiver) throws IllegalStateException, IllegalArgumentException {
        this.validateProxy(field);
        this.validateProxy(receiver);
        ExpressionProxy result = this.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
        this.createFieldAccess(ForExpression.ASSIGNMENT_RIGHT, field, receiver != null);
        if (receiver != null) {
            this.createProxyExpression(ForExpression.FIELD_RECEIVER, receiver);
        }
        return result;
    }

    @Override
    public final ExpressionProxy createSimpleFieldSet(IProxyField field, IProxy receiver, IProxy value, boolean wantResult) throws IllegalStateException, IllegalArgumentException {
        this.validateProxy(field);
        this.validateProxy(receiver);
        ExpressionProxy result = null;
        ForExpression forExpression = ForExpression.ROOTEXPRESSION;
        if (wantResult) {
            result = this.createProxyAssignmentExpression(forExpression);
            forExpression = ForExpression.ASSIGNMENT_RIGHT;
        }
        this.createAssignmentExpression(forExpression);
        this.createFieldAccess(ForExpression.ASSIGNMENT_LEFT, field, receiver != null);
        if (receiver != null) {
            this.createProxyExpression(ForExpression.FIELD_RECEIVER, receiver);
        }
        this.createProxyExpression(ForExpression.ASSIGNMENT_RIGHT, value);
        return result;
    }

    @Override
    public final ExpressionProxy createSimpleMethodInvoke(IProxyMethod method, IProxy receiver, IProxy[] arguments, boolean wantResult) throws IllegalStateException, IllegalArgumentException {
        this.validateProxy(method);
        this.validateProxy(receiver);
        if (arguments != null && arguments.length > 0) {
            int i = 0;
            while (i < arguments.length) {
                this.validateProxy(arguments[i]);
                ++i;
            }
        }
        ForExpression nextExpression = ForExpression.ROOTEXPRESSION;
        ExpressionProxy result = null;
        if (wantResult) {
            result = this.createProxyAssignmentExpression(nextExpression);
            nextExpression = ForExpression.ASSIGNMENT_RIGHT;
        }
        this.createMethodInvocation(nextExpression, method, receiver != null, arguments != null ? arguments.length : 0);
        if (receiver != null) {
            this.createProxyExpression(ForExpression.METHOD_RECEIVER, receiver);
        }
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                this.createProxyExpression(ForExpression.METHOD_ARGUMENT, arguments[i]);
                ++i;
            }
        }
        return result;
    }

    @Override
    public void createSubexpression() throws IllegalStateException {
        try {
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(SUBEXPRESSIONEND_EXPRESSION);
            this.pushForExpression(ForExpression.ROOTEXPRESSION);
            this.pushSubexpressionBeginToProxy(++this.subexpressionNumber);
            this.push(new Integer(this.subexpressionNumber));
            this.push(InternalExpressionTypes.SUBEXPRESSION_END_EXPRESSION);
            this.processExpression();
            return;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public void createSubexpressionEnd() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(SUBEXPRESSIONEND_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createTry() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(TRYEND_EXPRESSION);
            this.pushForExpression(TRYCATCH_EXPRESSION);
            this.pushForExpression(ForExpression.ROOTEXPRESSION);
            this.pushTryBeginToProxy(++this.tryNumber);
            this.push(new Integer(this.tryNumber));
            this.push(InternalExpressionTypes.TRY_END_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final ExpressionProxy createTryCatchClause(IProxyBeanType exceptionType, boolean wantExceptionReturned) throws IllegalStateException, IllegalArgumentException {
        this.validateProxy(exceptionType);
        return this.pushTryCatch(exceptionType, wantExceptionReturned);
    }

    @Override
    public final ExpressionProxy createTryCatchClause(String exceptionType, boolean wantExceptionReturned) throws IllegalStateException {
        return this.pushTryCatch(this.getProxyBeanType(exceptionType), wantExceptionReturned);
    }

    private ExpressionProxy pushTryCatch(IProxyBeanType exceptionType, boolean wantExceptionReturned) throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(TRYCATCH_EXPRESSION);
            this.pushForExpression(TRYCATCH_EXPRESSION);
            this.pushForExpression(ForExpression.ROOTEXPRESSION);
            int tryNumber = (Integer)this.peek(2);
            ExpressionProxy ep = null;
            if (wantExceptionReturned) {
                ep = this.allocateExpressionProxy(0);
            }
            this.pushTryCatchClauseToProxy(tryNumber, exceptionType, ep);
            this.processExpression();
            return ep;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createTryEnd() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            if (this.peekForExpression(TRYCATCH_EXPRESSION)) {
                this.checkForExpression(TRYCATCH_EXPRESSION);
            }
            this.checkForExpression(TRYEND_EXPRESSION);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createTryFinallyClause() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(TRYCATCH_EXPRESSION);
            this.pushForExpression(ForExpression.ROOTEXPRESSION);
            int tryNumber = (Integer)this.peek(2);
            this.pushTryFinallyClauseToProxy(tryNumber);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createRethrow() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.popForExpression();
            this.checkForExpression(TRYCATCH_EXPRESSION);
            this.pushForExpression(TRYCATCH_EXPRESSION);
            this.pushForExpression(ForExpression.ROOTEXPRESSION);
            int tryNumber = (Integer)this.peek(2);
            this.pushRethrowToProxy(tryNumber);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final void createThrow() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            this.push(InternalExpressionTypes.THROW_EXPRESSION);
            this.pushForExpression(PROCESS_EXPRESSION);
            this.pushForExpression(ForExpression.THROW_OPERAND);
            this.processExpression();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public final int mark() throws IllegalStateException {
        try {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            ++this.highestMarkID;
            this.currentMarkEntry = new MarkEntry();
            this.currentMarkEntry.markID = this.highestMarkID;
            this.currentMarkEntry.controlStackPos = this.controlStack.size() - 1;
            this.currentMarkEntry.nextExpressionStackPos = this.nextForExpressionStackPos;
            int n = this.currentMarkEntry.expressionProxiesPos = this.expressionProxies != null ? this.expressionProxies.size() - 1 : -1;
            if (this.markEntries == null) {
                this.markEntries = new ArrayList(5);
            }
            this.markEntries.add(this.currentMarkEntry);
            this.pushMarkToProxy(this.highestMarkID);
            return this.highestMarkID;
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    @Override
    public void endMark(int markNumber) throws IllegalStateException {
        if (this.isValid() && this.peekForExpression(ForExpression.ROOTEXPRESSION)) {
            this.checkForExpression(ForExpression.ROOTEXPRESSION);
            if (this.currentMarkEntry == null || this.currentMarkEntry.markID != markNumber) {
                this.throwInvalidMarkNesting();
            }
            MarkEntry me = (MarkEntry)this.markEntries.remove(this.markEntries.size() - 1);
            this.currentMarkEntry = !this.markEntries.isEmpty() ? (MarkEntry)this.markEntries.get(this.markEntries.size() - 1) : null;
            this.pushEndmarkToProxy(markNumber, false);
            if (me.controlStackPos != this.controlStack.size() - 1 || me.nextExpressionStackPos != this.nextForExpressionStackPos) {
                this.throwInvalidMarkNesting();
            }
            return;
        }
        if (this.markEntries == null) {
            this.throwInvalidMarkNesting();
        }
        int i = this.markEntries.size() - 1;
        while (i >= 0) {
            MarkEntry me = (MarkEntry)this.markEntries.get(i);
            if (me.markID == markNumber) {
                int j = this.controlStack.size() - 1;
                while (j > me.controlStackPos) {
                    this.controlStack.remove(j);
                    --j;
                }
                this.nextForExpressionStackPos = me.nextExpressionStackPos;
                if (this.expressionProxies != null) {
                    j = this.expressionProxies.size() - 1;
                    while (j > me.expressionProxiesPos) {
                        ExpressionProxy proxy = (ExpressionProxy)this.expressionProxies.remove(j);
                        if (proxy != null && proxy.hasListeners()) {
                            this.fireProxyNotResolved(proxy);
                        }
                        --j;
                    }
                }
                j = this.markEntries.size() - 1;
                while (j >= i) {
                    this.markEntries.remove(j);
                    --j;
                }
                this.currentMarkEntry = !this.markEntries.isEmpty() ? (MarkEntry)this.markEntries.get(this.markEntries.size() - 1) : null;
                this.pushEndmarkToProxy(markNumber, true);
                this.expressionValid = true;
                return;
            }
            --i;
        }
        this.throwInvalidMarkNesting();
    }

    public final void beginTransferThread() throws IllegalStateException, ThrowableProxy {
        try {
            this.pushForExpression(THREADTRANSFER_EXPRESSION);
            this.pushBeginTransferThreadToProxy();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    public final void transferThread() throws IllegalStateException {
        try {
            this.checkForExpression(THREADTRANSFER_EXPRESSION);
            this.pushTransferThreadToProxy();
        }
        catch (RuntimeException e) {
            this.markInvalid();
            throw e;
        }
    }

    protected IProxyBeanType getProxyBeanType(String type) {
        return this.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(this, type);
    }

    protected abstract ExpressionProxy createExpressionProxy(int var1, int var2);

    protected abstract void pushToProxy(IProxy var1);

    protected abstract void closeProxy();

    protected abstract void pushInvoke(int var1, List var2) throws ThrowableProxy, NoExpressionValueException;

    protected abstract IBeanProxy pullProxyValue(int var1, List var2) throws ThrowableProxy, NoExpressionValueException;

    protected abstract void pushCastToProxy(IProxyBeanType var1);

    protected abstract void pushInstanceofToProxy(IProxyBeanType var1);

    protected abstract void pushInfixToProxy(InfixOperator var1, InternalInfixOperandType var2);

    protected abstract void pushPrefixToProxy(PrefixOperator var1);

    protected abstract void pushArrayAccessToProxy(int var1);

    protected abstract void pushArrayCreationToProxy(IProxyBeanType var1, int var2);

    protected abstract void pushArrayInitializerToProxy(IProxyBeanType var1, int var2, int var3);

    protected abstract void pushClassInstanceCreationToProxy(IProxyBeanType var1, int var2);

    protected abstract void pushTypeReceiverToProxy(IProxyBeanType var1);

    protected abstract void pushFieldAccessToProxy(Object var1, boolean var2);

    protected abstract void pushMethodInvocationToProxy(Object var1, boolean var2, int var3);

    protected abstract void pushConditionalToProxy(InternalConditionalOperandType var1);

    protected abstract void pushAssignmentToProxy(ExpressionProxy var1);

    protected abstract void pushAssignmentToProxy();

    protected abstract void pushBlockBeginToProxy(int var1);

    protected abstract void pushBlockEndToProxy(int var1);

    protected abstract void pushBlockBreakToProxy(int var1);

    protected abstract void pushTryBeginToProxy(int var1);

    protected abstract void pushTryCatchClauseToProxy(int var1, IProxyBeanType var2, ExpressionProxy var3);

    protected abstract void pushTryFinallyClauseToProxy(int var1);

    protected abstract void pushTryEndToProxy(int var1);

    protected abstract void pushThrowToProxy();

    protected abstract void pushRethrowToProxy(int var1);

    protected abstract void pushBeanTypeToProxy(IBeanTypeExpressionProxy var1);

    protected abstract void pushMethodToProxy(ExpressionProxy var1, IProxyBeanType var2, String var3, IProxyBeanType[] var4);

    protected abstract void pushFieldToProxy(ExpressionProxy var1, IProxyBeanType var2, String var3);

    protected abstract void pushIfTestToProxy();

    protected abstract void pushIfElseToProxy(InternalIfElseOperandType var1);

    protected abstract void pushNewInstanceToProxy(String var1, IProxyBeanType var2);

    protected abstract void pushMarkToProxy(int var1);

    protected abstract void pushEndmarkToProxy(int var1, boolean var2);

    protected abstract void pushBeginTransferThreadToProxy() throws ThrowableProxy;

    protected abstract void pushTransferThreadToProxy();

    protected abstract void pushSubexpressionBeginToProxy(int var1);

    protected abstract void pushSubexpressionEndToProxy(int var1);

    private static class ExpressionEnum
    extends ForExpression {
        public ExpressionEnum(int value, String name) {
            super(value, name);
        }
    }

    private static class MarkEntry {
        public int markID;
        public int controlStackPos;
        public int nextExpressionStackPos;
        public int expressionProxiesPos;

        private MarkEntry() {
        }
    }
}

