/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.slf4j;

import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.slf4j.EquinoxLoggerFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EquinoxLoggerFactoryActivator
implements BundleActivator,
BundleListener {
    public void start(final BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
        ServiceTracker tracker = new ServiceTracker(context, ExtendedLogService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ExtendedLogService, ExtendedLogService>(){

            public ExtendedLogService addingService(ServiceReference<ExtendedLogService> reference) {
                ExtendedLogService service = (ExtendedLogService)context.getService(reference);
                if (service != null && EquinoxLoggerFactory.logService.compareAndSet(null, (LogService)service)) {
                    EquinoxLoggerFactory.LOGGER_MAP.clear();
                }
                return service;
            }

            public void modifiedService(ServiceReference<ExtendedLogService> reference, ExtendedLogService service) {
            }

            public void removedService(ServiceReference<ExtendedLogService> reference, ExtendedLogService service) {
                if (EquinoxLoggerFactory.logService.compareAndSet((LogService)service, null)) {
                    EquinoxLoggerFactory.LOGGER_MAP.clear();
                }
            }
        });
        tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        EquinoxLoggerFactory.logService.set(null);
        EquinoxLoggerFactory.LOGGER_MAP.clear();
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 || event.getType() == 64) {
            EquinoxLoggerFactory.LOGGER_MAP.remove(event.getBundle());
        }
    }
}

