/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.coloring;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.internal.ui.coloring.DefaultPreferenceRequestor;
import org.eclipse.dltk.ui.coloring.IColoringPreferenceProvider;
import org.eclipse.dltk.ui.coloring.IKeywordColorProvider;
import org.eclipse.dltk.ui.coloring.ITextRuleProvider;
import org.eclipse.dltk.utils.NatureExtensionManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.RGB;

public class ColoringPreferences {
    private static final String EXTENSION_POINT = "org.eclipse.dltk.ui.coloring";
    private static NatureExtensionManager<IColoringPreferenceProvider> preferenceProviderManager = null;
    private static NatureExtensionManager<IKeywordColorProvider> keywordColorProviderManager = null;
    private static NatureExtensionManager<ITextRuleProvider> textRuleProviderManager = null;
    public static final RGB BLACK = new RGB(0, 0, 0);

    public static void initializeDefaults(IPreferenceStore store, String natureId) {
        IColoringPreferenceProvider[] providers = ColoringPreferences.getProviders(natureId);
        if (providers != null) {
            DefaultPreferenceRequestor requestor = new DefaultPreferenceRequestor(store, natureId);
            IColoringPreferenceProvider[] iColoringPreferenceProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IColoringPreferenceProvider provider = iColoringPreferenceProviderArray[n2];
                provider.providePreferences(requestor);
                ++n2;
            }
        }
    }

    public static IColoringPreferenceProvider[] getProviders(String natureId) {
        if (preferenceProviderManager == null) {
            preferenceProviderManager = new NatureExtensionManager<IColoringPreferenceProvider>(EXTENSION_POINT, IColoringPreferenceProvider.class){

                protected boolean isValidElement(IConfigurationElement element) {
                    return "coloring".equals(element.getName());
                }
            };
        }
        return (IColoringPreferenceProvider[])preferenceProviderManager.getInstances(natureId);
    }

    public static IKeywordColorProvider[] getKeywordColorProviders(String natureId) {
        if (keywordColorProviderManager == null) {
            keywordColorProviderManager = new NatureExtensionManager<IKeywordColorProvider>(EXTENSION_POINT, IKeywordColorProvider.class){

                protected boolean isValidElement(IConfigurationElement element) {
                    return "keywordColor".equals(element.getName());
                }

                protected IKeywordColorProvider[] createEmptyResult() {
                    return new IKeywordColorProvider[0];
                }
            };
        }
        return (IKeywordColorProvider[])keywordColorProviderManager.getInstances(natureId);
    }

    public static ITextRuleProvider[] getTextRules(String natureId) {
        if (textRuleProviderManager == null) {
            textRuleProviderManager = new NatureExtensionManager<ITextRuleProvider>(EXTENSION_POINT, ITextRuleProvider.class){

                protected boolean isValidElement(IConfigurationElement element) {
                    return "textRules".equals(element.getName());
                }
            };
        }
        return (ITextRuleProvider[])textRuleProviderManager.getInstances(natureId);
    }
}

