/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wst.ws.service.policy.ui.ServicePolicyActivatorUI;
import org.osgi.framework.Bundle;

public class IConManager {
    private Map<String, Image> iconTable = new HashMap<String, Image>();
    public final String favorite = "fav";
    public final String invalid = "inv";
    public final String warning = "war";
    public final String lock = "loc";
    private String folderBaseURL;
    private String leafBaseURL;
    private Image favoriteImage;
    private Image invalidImage;
    private Image warningImage;
    private Image lockImage;
    private DecoratorDescriptor iconCreator;

    public IConManager() {
        this.addOverlayIcons();
        this.iconCreator = new DecoratorDescriptor();
    }

    public String getFolderBaseUrl() {
        return this.folderBaseURL;
    }

    public String getLeafBaseUrl() {
        return this.leafBaseURL;
    }

    private void addOverlayIcons() {
        try {
            Bundle bundle = ServicePolicyActivatorUI.getDefault().getBundle();
            URL folderUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/fldr_obj.gif"), null);
            URL leafUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/obj16/file_obj.gif"), null);
            URL favoriteUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/ovr16/favorite_ovr.gif"), null);
            URL invalidUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/ovr16/invalidtype_ovr.gif"), null);
            URL warningUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/ovr16/warning_ovr.gif"), null);
            URL lockUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/ovr16/unmodifiable_ovr.gif"), null);
            this.getIconImage(folderUrl);
            this.getIconImage(leafUrl);
            this.favoriteImage = this.getIconImage(favoriteUrl);
            this.invalidImage = this.getIconImage(invalidUrl);
            this.warningImage = this.getIconImage(warningUrl);
            this.lockImage = this.getIconImage(lockUrl);
            this.folderBaseURL = folderUrl.toString();
            this.leafBaseURL = leafUrl.toString();
        }
        catch (Throwable exc) {
            ServicePolicyActivatorUI.logError("Error reading icon overlays", exc);
            exc.printStackTrace();
        }
    }

    public boolean hasChanged(String[] string1, String[] string2) {
        if (string1 == null || string2 == null || string1.length != string2.length) {
            return true;
        }
        int index = 0;
        while (index < string1.length) {
            String value1 = string1[index];
            String value2 = string2[index];
            if (value1 != value2) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public Image getIconOverlay(String baseUrl, String[] overlays) {
        String imageUrl = this.getImageURL(baseUrl, overlays);
        Image result = this.iconTable.get(imageUrl);
        if (result == null) {
            Image baseImage = this.iconTable.get(baseUrl);
            if (baseImage == null) {
                try {
                    baseImage = this.getIconImage(new URL(baseUrl));
                }
                catch (Exception exc) {
                    ServicePolicyActivatorUI.logError("Error loading image from:" + baseUrl, exc);
                }
            }
            this.iconCreator.setBaseImage(baseImage, overlays);
            result = this.iconCreator.createImage();
            this.iconTable.put(imageUrl, result);
        }
        return result;
    }

    private boolean hasOverlay(String[] overlays, String value) {
        boolean result = false;
        String[] stringArray = overlays;
        int n = overlays.length;
        int n2 = 0;
        while (n2 < n) {
            String overlay = stringArray[n2];
            if (overlay == value) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private String getImageURL(String baseUrl, String[] overlays) {
        Object url = baseUrl;
        String[] stringArray = overlays;
        int n = overlays.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (value != null) {
                url = (String)url + ":" + value;
            }
            ++n2;
        }
        return url;
    }

    public Image getIconImage(URL url) {
        String urlString = url.toString();
        Image image = this.iconTable.get(urlString);
        if (image == null) {
            ImageDescriptor imageDesc = ImageDescriptor.createFromURL((URL)url);
            image = imageDesc.createImage();
            this.iconTable.put(urlString, image);
        }
        return image;
    }

    public void dispose() {
        for (Image image : this.iconTable.values()) {
            image.dispose();
        }
    }

    private class DecoratorDescriptor
    extends CompositeImageDescriptor {
        private Image baseImage;
        private Point size;
        private String[] overlays;

        private DecoratorDescriptor() {
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.baseImage.getImageData(), 0, 0);
            int index = 0;
            while (index < this.overlays.length) {
                if (IConManager.this.hasOverlay(this.overlays, "fav")) {
                    this.drawImage(IConManager.this.favoriteImage.getImageData(), this.size.x - IConManager.this.favoriteImage.getBounds().width, 0);
                }
                if (IConManager.this.hasOverlay(this.overlays, "war")) {
                    this.drawImage(IConManager.this.warningImage.getImageData(), 0, this.size.y - IConManager.this.warningImage.getBounds().height);
                }
                if (IConManager.this.hasOverlay(this.overlays, "inv")) {
                    this.drawImage(IConManager.this.invalidImage.getImageData(), 0, this.size.y - IConManager.this.invalidImage.getBounds().height);
                }
                if (IConManager.this.hasOverlay(this.overlays, "loc")) {
                    this.drawImage(IConManager.this.lockImage.getImageData(), this.size.x - IConManager.this.lockImage.getBounds().width, this.size.y - IConManager.this.lockImage.getBounds().height);
                }
                ++index;
            }
        }

        public void setBaseImage(Image image, String[] overlays) {
            Rectangle bounds = image.getBounds();
            this.baseImage = image;
            this.size = new Point(bounds.width, bounds.height);
            this.overlays = overlays;
        }

        protected Point getSize() {
            return this.size;
        }
    }
}

