/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.launching.SourceLookup;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.internal.core.model.Script;

public class JavaScriptSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    static final Object[] NO_SOURCE = new Object[0];
    private HashMap sourcemap = new HashMap();

    public String getSourceName(Object object) throws CoreException {
        return SourceLookup.getSourceName(object);
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        IFile file = this.resolveFile(object);
        if (file != null && file.exists()) {
            return new IFile[]{file};
        }
        ISourceContainer[] containers = this.getSourceContainers();
        if (containers != null && containers.length > 0) {
            URI sourceURI;
            String name = this.getSourceName(object);
            if (name != null) {
                Object[] sources = null;
                int i = 0;
                while (i < containers.length) {
                    sources = containers[i].findSourceElements(name);
                    if (sources != null && sources.length > 0) {
                        return sources;
                    }
                    ++i;
                }
            }
            if ((sourceURI = SourceLookup.getSourceURI(object)) != null) {
                file = (IFile)this.sourcemap.get(sourceURI);
                if (file != null && file.exists()) {
                    return new IFile[]{file};
                }
                return this.showExternalSource(sourceURI, object);
            }
        }
        return NO_SOURCE;
    }

    IFile resolveFile(Object object) {
        String uri = null;
        JavaScriptDebugTarget target = null;
        if (object instanceof JavaScriptStackFrame) {
            JavaScriptStackFrame frame = (JavaScriptStackFrame)object;
            uri = frame.getSourcePath();
            target = (JavaScriptDebugTarget)frame.getDebugTarget();
        }
        if (object instanceof Script) {
            Script script = (Script)object;
            uri = script.sourceURI().toString();
            target = (JavaScriptDebugTarget)script.getDebugTarget();
        }
        if (uri != null && target != null) {
            List scripts = target.getVM().allScripts();
            for (ScriptReference ref : scripts) {
                if (!uri.equals(ref.sourceURI().toString())) continue;
                return JavaScriptDebugPlugin.getResolutionManager().getFile(ref);
            }
        }
        return null;
    }

    private Object[] showExternalSource(URI sourceuri, Object sourceobj) {
        try {
            IFile file = SourceLookup.getExternalSource(sourceuri, sourceobj);
            if (file != null) {
                IPath path = file.getProjectRelativePath();
                if (JavaScriptDebugPlugin.getExternalScriptPath(path) == null) {
                    JavaScriptDebugPlugin.addExternalScriptPath(path, sourceuri.toString());
                }
                this.sourcemap.put(sourceuri, file);
                return new Object[]{file};
            }
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
            return NO_SOURCE;
        }
        return NO_SOURCE;
    }

    public boolean isFindDuplicates() {
        return true;
    }
}

