/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.test;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.flyout.FlyoutControlComposite;
import org.eclipse.wb.core.controls.flyout.MemoryFlyoutPreferences;
import org.eclipse.wb.core.controls.palette.DesignerContainer;
import org.eclipse.wb.core.controls.palette.DesignerEntry;
import org.eclipse.wb.core.controls.palette.DesignerRoot;
import org.eclipse.wb.core.controls.palette.ICategory;
import org.eclipse.wb.core.controls.palette.IEntry;
import org.eclipse.wb.core.controls.palette.PaletteComposite;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class PaletteTest
implements ColorConstants {
    protected Shell shell;

    public static void main(String[] args) {
        try {
            PaletteTest window = new PaletteTest();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell();
        this.shell.setBounds(600, 300, 800, 600);
        this.shell.setText("SWT Application");
        this.shell.setLayout((Layout)new FillLayout());
        MemoryFlyoutPreferences preferences = new MemoryFlyoutPreferences(1, 0, 200);
        FlyoutControlComposite flyoutControlComposite = new FlyoutControlComposite((Composite)this.shell, 0, preferences);
        flyoutControlComposite.setTitleText("Palette");
        PaletteComposite paletteComposite = new PaletteComposite(flyoutControlComposite.getFlyoutParent(), 0);
        GridDataFactory.create((Control)paletteComposite).grabV().hintHC(30).fill();
        new Composite(flyoutControlComposite.getClientParent(), 2048);
        PaletteImpl palette = new PaletteImpl();
        CategoryImpl category = new CategoryImpl("First category", true);
        palette.add((PaletteEntry)category);
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(red), "AAAAAAAAAAA"));
        category.add((PaletteEntry)new EntryImpl(false, this.createIcon(green), "BBBBB"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(blue), "CCCCCCCCCCCCCCC"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(yellow), "DDDDDDDDD"));
        category.add((PaletteEntry)new EntryImpl(false, this.createIcon(orange), "EEEEEEEEEEE"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(cyan), "FFFFF"));
        category = new CategoryImpl("Second category", false);
        palette.add((PaletteEntry)category);
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(red), "0123456789"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(green), "012345"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(blue), "0123456789123"));
        category = new CategoryImpl("Third category", true);
        palette.add((PaletteEntry)category);
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(red), "0123456789"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(green), "012345"));
        category.add((PaletteEntry)new EntryImpl(true, this.createIcon(blue), "0123456789123"));
        paletteComposite.setPalette(palette);
    }

    private final ImageDescriptor createIcon(Color color) {
        int size = 16;
        Image image = new Image((Device)this.shell.getDisplay(), size, size);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, size, size);
        gc.dispose();
        return ImageDescriptor.createFromImage((Image)image);
    }

    private static final class CategoryImpl
    extends DesignerContainer {
        private boolean m_open;

        public CategoryImpl(String text, boolean open) {
            super(text, null);
            this.m_open = open;
        }

        @Override
        public boolean isOpen() {
            return this.m_open;
        }

        @Override
        public void setOpen(boolean b) {
            this.m_open = b;
        }
    }

    private static final class EntryImpl
    extends DesignerEntry {
        private final boolean m_enabled;

        public EntryImpl(boolean enabled, ImageDescriptor icon, String text) {
            super(text, null, icon);
            this.m_enabled = enabled;
        }

        @Override
        public boolean isEnabled() {
            return this.m_enabled;
        }

        @Override
        public boolean activate(boolean reload) {
            return true;
        }
    }

    private static final class PaletteImpl
    extends DesignerRoot {
        private PaletteImpl() {
        }

        @Override
        public void addPopupActions(IMenuManager menuManager, Object target, int iconType) {
        }

        @Override
        public void selectDefault() {
        }

        @Override
        public void moveCategory(ICategory category, ICategory nextCategory) {
        }

        @Override
        public void moveEntry(IEntry entry, ICategory targetCategory, IEntry nextEntry) {
        }
    }
}

