/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupportListener;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.ui.NewSourceDialog;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class PropertiesComposite
extends Composite {
    private final IEditableSupport m_support;
    private ListViewer m_sourcesViewer;
    private org.eclipse.swt.widgets.List m_sourcesList;
    private CheckboxTreeViewer m_propertiesViewer;
    private Tree m_propertiesTree;
    private Button m_externalizeButton;
    private Button m_copyToAllLocalesButton;

    public PropertiesComposite(Composite parent, int style, IEditableSupport support) {
        super(parent, style);
        this.m_support = support;
        this.m_support.addListener(new IEditableSupportListener(){

            @Override
            public void sourceAdded(IEditableSource source) {
                PropertiesComposite.this.m_sourcesViewer.refresh();
            }

            @Override
            public void externalizedPropertiesChanged() {
                PropertiesComposite.this.m_propertiesViewer.refresh();
                PropertiesComposite.this.m_propertiesViewer.expandAll();
            }
        });
        this.setLayout((Layout)new GridLayout());
        this.createSourcesGroup();
        this.createPropertyGroup();
    }

    private void createSourcesGroup() {
        Group sourceGroup = new Group((Composite)this, 0);
        GridDataFactory.create((Control)sourceGroup).alignHF().grabH();
        GridLayoutFactory.create((Composite)sourceGroup).columns(2);
        sourceGroup.setText(Messages.PropertiesComposite_sourceGroup);
        Label label = new Label((Composite)sourceGroup, 0);
        GridDataFactory.create((Control)label).fill().grabH().spanH(2);
        label.setText(Messages.PropertiesComposite_existingSourcesLabel);
        this.m_sourcesViewer = new ListViewer((Composite)sourceGroup, 2048);
        this.m_sourcesViewer.setContentProvider((IContentProvider)new SourcesContentProvider());
        this.m_sourcesViewer.setLabelProvider((IBaseLabelProvider)new SourcesLabelProvider());
        this.m_sourcesViewer.setComparator(new ViewerComparator());
        this.m_sourcesList = this.m_sourcesViewer.getList();
        GridDataFactory.create((Control)this.m_sourcesList).fill().grab().hintVC(5);
        this.m_sourcesViewer.setInput((Object)this);
        this.m_sourcesList.select(0);
        this.m_sourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertiesComposite.this.updateExternalizeButton();
            }
        });
        Composite buttonsComposite = new Composite((Composite)sourceGroup, 0);
        GridDataFactory.create((Control)buttonsComposite).alignVF();
        GridLayoutFactory.create((Composite)buttonsComposite).noMargins();
        Button addButton = new Button(buttonsComposite, 0);
        PropertiesComposite.setButtonLayoutData(addButton);
        addButton.setText(Messages.PropertiesComposite_newbutton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesComposite.this.addNewSource();
            }
        });
    }

    private void createPropertyGroup() {
        Group propertyGroup = new Group((Composite)this, 0);
        GridDataFactory.create((Control)propertyGroup).grab().fill();
        GridLayoutFactory.create((Composite)propertyGroup).columns(2);
        propertyGroup.setText(Messages.PropertiesComposite_propertiesGroup);
        Label label = new Label((Composite)propertyGroup, 0);
        GridDataFactory.create((Control)label).fill().grabH().spanH(2);
        label.setText(Messages.PropertiesComposite_propertiesLabel);
        this.m_propertiesViewer = new CheckboxTreeViewer((Composite)propertyGroup, 2048);
        this.m_propertiesViewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.m_propertiesViewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        this.m_propertiesTree = this.m_propertiesViewer.getTree();
        GridDataFactory.create((Control)this.m_propertiesTree).grab().fill();
        this.m_propertiesViewer.setInput((Object)this);
        this.m_propertiesViewer.expandAll();
        this.m_propertiesViewer.setGrayedElements(this.m_support.getComponents().toArray());
        this.m_propertiesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof JavaInfo) {
                    JavaInfo component = (JavaInfo)((Object)element);
                    List<StringPropertyInfo> properties = PropertiesComposite.this.m_support.getProperties(component);
                    for (StringPropertyInfo property : properties) {
                        PropertiesComposite.this.m_propertiesViewer.setChecked((Object)property, event.getChecked());
                    }
                }
                PropertiesComposite.this.updateExternalizeButton();
            }
        });
        this.createPropertyButtons(propertyGroup);
        this.m_copyToAllLocalesButton = new Button((Composite)propertyGroup, 32);
        this.m_copyToAllLocalesButton.setText(Messages.PropertiesComposite_copyButton);
    }

    private void createPropertyButtons(Group propertiesGroup) {
        Composite buttonsComposite = new Composite((Composite)propertiesGroup, 0);
        GridDataFactory.create((Control)buttonsComposite).alignVF();
        GridLayoutFactory.create((Composite)buttonsComposite).noMargins();
        Button enableAllButton = new Button(buttonsComposite, 0);
        PropertiesComposite.setButtonLayoutData(enableAllButton);
        enableAllButton.setText(Messages.PropertiesComposite_enableAllButton);
        enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesComposite.this.m_propertiesViewer.setSubtreeChecked((Object)PropertiesComposite.this.m_support.getRoot(), true);
                PropertiesComposite.this.updateExternalizeButton();
            }
        });
        Button disableAllButton = new Button(buttonsComposite, 0);
        PropertiesComposite.setButtonLayoutData(disableAllButton);
        disableAllButton.setText(Messages.PropertiesComposite_disableAllButton);
        disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesComposite.this.m_propertiesViewer.setSubtreeChecked((Object)PropertiesComposite.this.m_support.getRoot(), false);
                PropertiesComposite.this.updateExternalizeButton();
            }
        });
        Label label = new Label(buttonsComposite, 258);
        GridDataFactory.create((Control)label).alignHF();
        label.setVisible(false);
        this.m_externalizeButton = new Button(buttonsComposite, 0);
        PropertiesComposite.setButtonLayoutData(this.m_externalizeButton);
        this.m_externalizeButton.setText(Messages.PropertiesComposite_externalizeButton);
        this.m_externalizeButton.setEnabled(false);
        this.m_externalizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesComposite.this.externalizeSelectedProperties();
            }
        });
    }

    protected void addNewSource() {
        NewSourceDialog newSourceDialog = new NewSourceDialog(this.getShell(), this.m_support.getRoot());
        if (newSourceDialog.open() == 0) {
            IEditableSource editableSource = newSourceDialog.getNewEditableSource();
            SourceDescription sourceDescription = newSourceDialog.getNewSourceDescription();
            Object parameters = newSourceDialog.getNewSourceParameters();
            this.m_support.addSource(editableSource, sourceDescription, parameters);
            this.m_sourcesViewer.setSelection((ISelection)new StructuredSelection((Object)editableSource));
        }
    }

    private void updateExternalizeButton() {
        boolean hasSource = !this.m_sourcesViewer.getSelection().isEmpty();
        boolean hasProperties = !this.getSelectedProperties().isEmpty();
        this.m_externalizeButton.setEnabled(hasSource && hasProperties);
    }

    private void externalizeSelectedProperties() {
        IEditableSource source = this.getSelectedSource();
        List<StringPropertyInfo> selectedProperties = this.getSelectedProperties();
        boolean copyToAllLocales = this.m_copyToAllLocalesButton.getSelection();
        for (StringPropertyInfo propertyInfo : selectedProperties) {
            this.m_support.externalizeProperty(propertyInfo, source, copyToAllLocales);
        }
        this.updateExternalizeButton();
    }

    private List<StringPropertyInfo> getSelectedProperties() {
        Object[] checkedElements;
        ArrayList<StringPropertyInfo> properties = new ArrayList<StringPropertyInfo>();
        Object[] objectArray = checkedElements = this.m_propertiesViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof StringPropertyInfo) {
                properties.add((StringPropertyInfo)element);
            }
            ++n2;
        }
        return properties;
    }

    private IEditableSource getSelectedSource() {
        IStructuredSelection selection = (IStructuredSelection)this.m_sourcesViewer.getSelection();
        return (IEditableSource)selection.getFirstElement();
    }

    private static void setButtonLayoutData(Button button) {
        GridDataFactory.create((Control)button).hintHU(61);
    }

    static /* synthetic */ IEditableSupport access$0(PropertiesComposite propertiesComposite) {
        return propertiesComposite.m_support;
    }

    private class PropertiesContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private PropertiesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])ExecutionUtils.runObjectLog(() -> {
                JavaInfo root = PropertiesComposite.this.m_support.getRoot();
                if (PropertiesComposite.this.m_support.hasPropertiesInTree(root)) {
                    return new Object[]{root};
                }
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }, (Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof JavaInfo) {
                final JavaInfo component = (JavaInfo)((Object)parentElement);
                final ArrayList<StringPropertyInfo> children = new ArrayList<StringPropertyInfo>();
                children.addAll(PropertiesComposite.this.m_support.getProperties(component));
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        for (JavaInfo child : ((PropertiesContentProvider)PropertiesContentProvider.this).PropertiesComposite.this.m_support.getTreeChildren(component)) {
                            if (!((PropertiesContentProvider)PropertiesContentProvider.this).PropertiesComposite.this.m_support.hasPropertiesInTree(child)) continue;
                            children.add(child);
                        }
                    }
                });
                return children.toArray();
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof ObjectInfo) {
                return ((ObjectInfo)element).getParent();
            }
            Assert.instanceOf(StringPropertyInfo.class, (Object)element);
            return ((StringPropertyInfo)element).getComponent();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class PropertiesLabelProvider
    extends LabelProvider {
        private final ResourceManager m_resourceManager = new LocalResourceManager(JFaceResources.getResources());

        private PropertiesLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            this.m_resourceManager.dispose();
        }

        public String getText(Object element) {
            return (String)ExecutionUtils.runObjectLog(() -> {
                if (element instanceof JavaInfo) {
                    JavaInfo component = (JavaInfo)((Object)((Object)element));
                    return component.getPresentation().getText();
                }
                Assert.instanceOf(StringPropertyInfo.class, (Object)element);
                StringPropertyInfo propertyInfo = (StringPropertyInfo)element;
                return propertyInfo.getTitle();
            }, null);
        }

        public Image getImage(Object element) {
            ImageDescriptor imageDescriptor = (ImageDescriptor)ExecutionUtils.runObjectLog(() -> {
                if (element instanceof JavaInfo) {
                    JavaInfo component = (JavaInfo)((Object)((Object)element));
                    return component.getPresentation().getIcon();
                }
                Assert.instanceOf(StringPropertyInfo.class, (Object)element);
                return DesignerPlugin.getImageDescriptor((String)"nls/property.gif");
            }, null);
            return imageDescriptor == null ? null : this.m_resourceManager.createImage(imageDescriptor);
        }
    }

    private class SourcesContentProvider
    implements IStructuredContentProvider {
        private SourcesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PropertiesComposite.this.m_support.getEditableSources().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class SourcesLabelProvider
    extends LabelProvider {
        private SourcesLabelProvider() {
        }

        public String getText(Object element) {
            IEditableSource source = (IEditableSource)element;
            return source.getLongTitle();
        }
    }
}

