/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignPage;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.ObjectPathHelper;
import org.eclipse.wb.internal.core.editor.structure.components.IComponentsTree;
import org.eclipse.wb.internal.core.utils.ast.IASTEditorCommitListener;

public final class UndoManager {
    private final DesignPage m_designPage;
    private final IBuffer m_buffer;
    private final IFile m_unitFile;
    private final Map<String, int[][]> m_sourceToSelection = new LRUMap(32);
    private final Map<String, int[][]> m_dumpToSelection = new LRUMap(32);
    private final Map<String, int[][]> m_dumpToExpanded = new LRUMap(32);
    private IComponentsTree m_componentsTree;
    private ISelectionProvider m_selectionProvider;
    private ITreeContentProvider m_componentsProvider;
    private ObjectPathHelper m_objectPathHelper;
    private JavaInfo m_root;
    private String m_currentSource;
    private String m_currentDump;
    private boolean m_active;
    private final IASTEditorCommitListener m_editorListener = new IASTEditorCommitListener(){

        @Override
        public void aboutToCommit() {
            UndoManager.this.removeBufferListener();
        }

        @Override
        public boolean canEditBaseFile() {
            if (UndoManager.this.m_unitFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{UndoManager.this.m_unitFile}, (Object)DesignerPlugin.getShell());
                return !UndoManager.this.m_unitFile.isReadOnly();
            }
            return true;
        }

        @Override
        public void commitDone() {
            UndoManager.this.addBufferListener();
        }
    };
    private final ObjectEventListener m_refreshListener = new ObjectEventListener(){

        public void refreshBeforeCreate() throws Exception {
            UndoManager.this.removeSelectionListener();
        }

        public void refreshed2() throws Exception {
            UndoManager.this.addSelectionListener();
            UndoManager.this.rememberSource();
            UndoManager.this.rememberDump();
            UndoManager.this.rememberState();
        }
    };
    private final ISelectionChangedListener m_selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            UndoManager.this.rememberState();
        }
    };
    private int m_bufferChangeCount = 0;
    private final IBufferChangedListener m_bufferListener = new IBufferChangedListener(){

        public void bufferChanged(BufferChangedEvent event) {
            if (!UndoManager.this.m_designPage.isActiveEditor()) {
                return;
            }
            if (event.getText() != null || event.getLength() != 0) {
                UndoManager.this.scheduleRefresh_onBufferChange();
            }
        }
    };

    public UndoManager(DesignPage designPage, ICompilationUnit unit) throws Exception {
        this.m_designPage = designPage;
        this.m_buffer = unit.getBuffer();
        this.m_unitFile = (IFile)unit.getUnderlyingResource();
    }

    public void activate() {
        if (!this.m_active) {
            this.m_active = true;
            if (!StringUtils.equals((CharSequence)this.m_currentSource, (CharSequence)this.m_buffer.getContents())) {
                this.refreshDesignerEditor();
            }
            this.addBufferListener();
        }
    }

    public void deactivate() {
        if (this.m_active) {
            this.m_active = false;
            this.removeBufferListener();
        }
    }

    public void setRoot(JavaInfo root) {
        this.m_root = root;
        this.m_root.getEditor().setCommitListener(this.m_editorListener);
        this.m_root.addBroadcastListener(this.m_refreshListener);
        DesignPageSite site = DesignPageSite.Helper.getSite((ObjectInfo)this.m_root);
        this.m_componentsTree = site.getComponentTree();
        this.m_componentsProvider = this.m_componentsTree.getContentProvider();
        this.m_selectionProvider = this.m_componentsTree.getSelectionProvider();
        this.m_objectPathHelper = new ObjectPathHelper(this.m_componentsProvider);
        this.m_componentsTree.setExpandListener(new Runnable(){

            @Override
            public void run() {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UndoManager.this.rememberState();
                    }
                });
            }
        });
    }

    private void addSelectionListener() {
        this.m_selectionProvider.addSelectionChangedListener(this.m_selectionListener);
    }

    private void removeSelectionListener() {
        if (this.m_selectionProvider != null) {
            this.m_selectionProvider.removeSelectionChangedListener(this.m_selectionListener);
        }
    }

    private void rememberSource() {
        this.m_currentSource = this.m_buffer.getContents();
    }

    private void rememberDump() {
        this.m_currentDump = ObjectPathHelper.getObjectsDump((ObjectInfo)this.m_root, (int)0);
    }

    private void rememberState() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.m_selectionProvider.getSelection();
        Object[] selectedObjects = structuredSelection.toArray();
        int[][] paths = this.m_objectPathHelper.getObjectsPaths(selectedObjects);
        this.m_sourceToSelection.put(this.m_currentSource, paths);
        this.m_dumpToSelection.put(this.m_currentDump, paths);
        Object[] expandedObjects = this.m_componentsTree.getExpandedElements();
        paths = this.m_objectPathHelper.getObjectsPaths(expandedObjects);
        this.m_dumpToExpanded.put(this.m_currentDump, paths);
    }

    private void restoreState() {
        this.restoreSelection();
        this.restoreExpanded();
    }

    private void restoreSelection() {
        int[][] paths = this.m_sourceToSelection.get(this.m_currentSource);
        if (paths == null) {
            paths = this.m_dumpToSelection.get(this.m_currentDump);
        }
        if (paths != null) {
            this.removeSelectionListener();
            try {
                Object[] objects = this.m_objectPathHelper.getObjectsForPaths(paths);
                this.m_selectionProvider.setSelection((ISelection)new StructuredSelection(objects));
            }
            finally {
                this.addSelectionListener();
            }
        }
    }

    private void restoreExpanded() {
        int[][] paths = this.m_dumpToExpanded.get(this.m_currentDump);
        if (paths != null) {
            Object[] objects = this.m_objectPathHelper.getObjectsForPaths(paths);
            this.m_componentsTree.setExpandedElements(objects);
        }
        if (this.m_componentsTree.getExpandedElements().length == 0) {
            ArrayList<JavaInfo> expandedElements = new ArrayList<JavaInfo>();
            Object element = this.m_root;
            while (true) {
                expandedElements.add((JavaInfo)((Object)element));
                Object[] children = this.m_componentsProvider.getChildren(element);
                if (children.length != 1) break;
                element = children[0];
            }
            this.m_componentsTree.setExpandedElements(expandedElements.toArray());
        }
    }

    private void scheduleRefresh_onBufferChange() {
        final int bufferChangeCount = ++this.m_bufferChangeCount;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (this.isStillInSave()) {
                    Display.getDefault().timerExec(1, (Runnable)this);
                    return;
                }
                if (bufferChangeCount == UndoManager.this.m_bufferChangeCount) {
                    UndoManager.this.refreshDesignerEditor();
                }
            }

            private boolean isStillInSave() {
                StackTraceElement[] elements;
                String editorClassName = "org.eclipse.wb.internal.core.editor.multi.DesignerEditor";
                StackTraceElement[] stackTraceElementArray = elements = new Exception().getStackTrace();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    if (element.getClassName().equals(editorClassName) && element.getMethodName().equals("doSave")) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private void addBufferListener() {
        this.m_buffer.addBufferChangedListener(this.m_bufferListener);
    }

    private void removeBufferListener() {
        this.m_buffer.removeBufferChangedListener(this.m_bufferListener);
    }

    void refreshDesignerEditor() {
        this.rememberSource();
        this.removeSelectionListener();
        if (this.m_designPage.internal_refreshGEF()) {
            this.addSelectionListener();
            this.rememberDump();
            this.restoreState();
        }
    }
}

