/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.validators;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.addon.viewers.runtime.notation.HierarchyPolicy;
import org.eclipse.viatra.addon.viewers.runtime.validators.AbstractAnnotationValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IIssueCallback;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;

public class ItemValidator
extends AbstractAnnotationValidator {
    public static final String HIERARCHY_LITERAL_ISSUE = "org.eclipse.viatra.query.viewers.hierarchyliteral";
    private static final PatternAnnotationParameter ITEM_PARAMETER = new PatternAnnotationParameter("item", "variablereference", "The pattern parameter the Item will represent in the viewer.", false, true);
    private static final PatternAnnotationParameter LABEL_PARAMETER = new PatternAnnotationParameter("label", "string", "The label to describe the item. The message may refer the parameter variables between $ symbols, or their EMF features, such as in $Param1.name$.", false, false);
    private static final PatternAnnotationParameter HIERARCHY_PARAMETER = new PatternAnnotationParameter("hierarchy", "string", "Describes whether an item should display only as 'root' (top-level) element, only as 'child' (not root but as a child) or only  as 'port' (hierarchic graph viewers) or 'always'.", false, false);

    public ItemValidator() {
        super("Item", "An element to display in a JFace viewer", ITEM_PARAMETER, LABEL_PARAMETER, HIERARCHY_PARAMETER);
    }

    @Override
    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        super.executeAdditionalValidation(annotation, validator);
        ValueReference hierarchyRef = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)HIERARCHY_PARAMETER.getName());
        if (hierarchyRef instanceof StringValue) {
            String value = ((StringValue)hierarchyRef).getValue();
            List valueList = Arrays.stream(HierarchyPolicy.values()).map(policy -> policy.name().toLowerCase()).collect(Collectors.toList());
            if (!valueList.contains(value.toLowerCase())) {
                validator.error(String.format("Invalid hierarchy literal %s. Possible values are %s.", value, valueList.stream().collect(Collectors.joining(", "))), (EObject)hierarchyRef, (EStructuralFeature)PatternLanguagePackage.Literals.STRING_VALUE__VALUE, HIERARCHY_LITERAL_ISSUE, new String[0]);
            }
        }
    }
}

