/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.local.showin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.terminal.view.ui.help.IContextHelpIds;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ExternalExecutablesDialog
extends TrayDialog {
    private String contextHelpId = null;
    private final boolean edit;
    private Text name;
    Text path;
    private Text args;
    Text icon;
    private Button translate;
    String last_filter_path = null;
    String last_filter_icon = null;
    private Map<String, String> executableData;

    public ExternalExecutablesDialog(Shell shell, boolean edit) {
        super(shell);
        this.edit = edit;
        this.contextHelpId = IContextHelpIds.EXTERNAL_EXECUTABLES_DIALOG;
        this.setHelpAvailable(true);
    }

    protected final Control createDialogArea(Composite parent) {
        Control control;
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        if ((control = super.createDialogArea(parent)) instanceof Composite) {
            ScrolledComposite sc = new ScrolledComposite((Composite)control, 512);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            sc.setLayout((Layout)layout);
            sc.setLayoutData((Object)new GridData(4, 4, true, true));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            Composite composite = new Composite((Composite)sc, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createDialogAreaContent(composite);
            sc.setContent((Control)composite);
            sc.setMinSize(composite.computeSize(-1, -1));
            control = sc;
        }
        return control;
    }

    protected void createDialogAreaContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.setDialogTitle(this.edit ? Messages.ExternalExecutablesDialog_title_edit : Messages.ExternalExecutablesDialog_title_add);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, true);
        layoutData.widthHint = this.convertWidthInCharsToPixels(50);
        panel.setLayoutData((Object)layoutData);
        Label label = new Label(panel, 256);
        label.setText(Messages.ExternalExecutablesDialog_field_name);
        layoutData = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        this.name = new Text(panel, 2308);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(30);
        this.name.setLayoutData((Object)layoutData);
        this.name.addModifyListener(e -> this.validate());
        label = new Label(panel, 256);
        label.setText(Messages.ExternalExecutablesDialog_field_path);
        layoutData = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        Composite panel2 = new Composite(panel, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel2.setLayout((Layout)layout);
        layoutData = new GridData(4, 0x1000000, true, false);
        panel2.setLayoutData((Object)layoutData);
        this.path = new Text(panel2, 2308);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(30);
        this.path.setLayoutData((Object)layoutData);
        this.path.addModifyListener(e -> this.validate());
        Button button = new Button(panel2, 8);
        button.setText(Messages.ExternalExecutablesDialog_button_browse);
        layoutData = new GridData(1, 0x1000000, false, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(10);
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalExecutablesDialog.this.getShell(), 4096);
                String selectedFile = ExternalExecutablesDialog.this.path.getText();
                if (selectedFile != null && selectedFile.trim().length() > 0) {
                    String filterFileName;
                    Path filePath = new Path(selectedFile);
                    Path filterPath = filePath.toFile().isDirectory() ? filePath : filePath.removeLastSegments(1);
                    while (filterPath != null && filterPath.segmentCount() > 1 && !filterPath.toFile().exists()) {
                        filterPath = filterPath.removeLastSegments(1);
                    }
                    String string = filterFileName = filePath.toFile().isDirectory() || !filePath.toFile().exists() ? null : filePath.lastSegment();
                    if (filterPath != null && !filterPath.isEmpty()) {
                        dialog.setFilterPath(filterPath.toString());
                    }
                    if (filterFileName != null) {
                        dialog.setFileName(filterFileName);
                    }
                } else {
                    String workspace = null;
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
                    if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
                        workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                    }
                    String filterPath = ExternalExecutablesDialog.this.last_filter_path != null ? ExternalExecutablesDialog.this.last_filter_path : workspace;
                    dialog.setFilterPath(filterPath);
                }
                if ((selectedFile = dialog.open()) != null) {
                    ExternalExecutablesDialog.this.last_filter_path = dialog.getFilterPath();
                    ExternalExecutablesDialog.this.path.setText(selectedFile);
                }
            }
        });
        label = new Label(panel, 256);
        label.setText(Messages.ExternalExecutablesDialog_field_args);
        layoutData = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        this.args = new Text(panel, 2308);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(30);
        this.args.setLayoutData((Object)layoutData);
        this.args.addModifyListener(e -> this.validate());
        label = new Label(panel, 256);
        label.setText(Messages.ExternalExecutablesDialog_field_icon);
        layoutData = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)layoutData);
        panel2 = new Composite(panel, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel2.setLayout((Layout)layout);
        layoutData = new GridData(4, 0x1000000, true, false);
        panel2.setLayoutData((Object)layoutData);
        this.icon = new Text(panel2, 2308);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(30);
        this.icon.setLayoutData((Object)layoutData);
        this.icon.addModifyListener(e -> this.validate());
        button = new Button(panel2, 8);
        button.setText(Messages.ExternalExecutablesDialog_button_browse);
        layoutData = new GridData(1, 0x1000000, false, false);
        layoutData.widthHint = this.convertWidthInCharsToPixels(10);
        button.setLayoutData((Object)layoutData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExternalExecutablesDialog.this.getShell(), 4096);
                String selectedFile = ExternalExecutablesDialog.this.icon.getText();
                if (selectedFile != null && selectedFile.trim().length() > 0) {
                    String filterFileName;
                    Path filePath = new Path(selectedFile);
                    Path filterPath = filePath.toFile().isDirectory() ? filePath : filePath.removeLastSegments(1);
                    while (filterPath != null && filterPath.segmentCount() > 1 && !filterPath.toFile().exists()) {
                        filterPath = filterPath.removeLastSegments(1);
                    }
                    String string = filterFileName = filePath.toFile().isDirectory() || !filePath.toFile().exists() ? null : filePath.lastSegment();
                    if (filterPath != null && !filterPath.isEmpty()) {
                        dialog.setFilterPath(filterPath.toString());
                    }
                    if (filterFileName != null) {
                        dialog.setFileName(filterFileName);
                    }
                } else {
                    String workspace = null;
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
                    if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
                        workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                    }
                    String filterPath = ExternalExecutablesDialog.this.last_filter_icon != null ? ExternalExecutablesDialog.this.last_filter_icon : workspace;
                    dialog.setFilterPath(filterPath);
                }
                if ((selectedFile = dialog.open()) != null) {
                    ExternalExecutablesDialog.this.last_filter_icon = dialog.getFilterPath();
                    ExternalExecutablesDialog.this.icon.setText(selectedFile);
                }
            }
        });
        this.translate = new Button(panel, 32);
        this.translate.setText(Messages.ExternalExecutablesDialog_field_translate);
        layoutData = new GridData(4, 128, true, false);
        layoutData.horizontalSpan = 2;
        this.translate.setLayoutData((Object)layoutData);
        this.translate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalExecutablesDialog.this.validate();
            }
        });
        if (this.executableData != null) {
            String value = this.executableData.get("Name");
            this.name.setText(value != null && !"".equals(value.trim()) ? value : "");
            value = this.executableData.get("Path");
            this.path.setText(value != null && !"".equals(value.trim()) ? value : "");
            value = this.executableData.get("Args");
            this.args.setText(value != null && !"".equals(value.trim()) ? value : "");
            value = this.executableData.get("Icon");
            this.icon.setText(value != null && !"".equals(value.trim()) ? value : "");
            value = this.executableData.get("Translate");
            this.translate.setSelection(value != null ? Boolean.parseBoolean(value) : false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.validate();
        return control;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0 && !this.edit) {
            label = Messages.ExternalExecutablesDialog_button_add;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void okPressed() {
        if (this.name != null && this.path != null) {
            String value;
            if (this.executableData == null) {
                this.executableData = new HashMap<String, String>();
            }
            if ((value = this.name.getText()) != null && !"".equals(value.trim())) {
                this.executableData.put("Name", value);
            } else {
                this.executableData.remove("Name");
            }
            value = this.path.getText();
            if (value != null && !"".equals(value.trim())) {
                this.executableData.put("Path", value);
            } else {
                this.executableData.remove("Path");
            }
            value = this.args.getText();
            if (value != null && !"".equals(value.trim())) {
                this.executableData.put("Args", value);
            } else {
                this.executableData.remove("Args");
            }
            value = this.icon.getText();
            if (value != null && !"".equals(value.trim())) {
                this.executableData.put("Icon", value);
            } else {
                this.executableData.remove("Icon");
            }
            if (this.translate.getSelection()) {
                this.executableData.put("Translate", Boolean.TRUE.toString());
            } else {
                this.executableData.remove("Translate");
            }
        } else {
            this.executableData = null;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.executableData = null;
        super.cancelPressed();
    }

    public Map<String, String> getExecutableData() {
        return this.executableData;
    }

    public void setExecutableData(Map<String, String> data) {
        this.executableData = data == null ? null : new HashMap<String, String>(data);
    }

    public void validate() {
        Button okButton;
        File f;
        String value;
        boolean valid = true;
        if (this.name != null && !this.name.isDisposed()) {
            boolean bl = valid = !"".equals(this.name.getText());
        }
        if (this.path != null && !this.path.isDisposed()) {
            value = this.path.getText();
            valid = !"".equals(value) ? (valid |= (f = new File(value)).isAbsolute() && f.canRead()) : false;
        }
        if (this.icon != null && !this.icon.isDisposed() && !"".equals(value = this.icon.getText())) {
            f = new File(value);
            valid |= f.isAbsolute() && f.canRead();
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(valid);
        }
    }

    public void setDialogTitle(String title) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setText(title);
        }
    }
}

