/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.core.adapters;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNodeProvider;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistableNameProvider;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistableURIProvider;
import org.osgi.framework.Bundle;

public class ModelNodePersistableURIProvider
implements IPersistableURIProvider {
    private IModelNode getModelNode(Object context) {
        IModelNode node = null;
        if (context instanceof IModelNode) {
            node = (IModelNode)context;
        } else if (context instanceof IModelNodeProvider) {
            node = ((IModelNodeProvider)context).getModelNode();
        }
        return node;
    }

    public URI getURI(Object context) {
        Assert.isNotNull((Object)context);
        URI uri = null;
        IModelNode node = this.getModelNode(context);
        if (node != null) {
            String name;
            IPath path = null;
            IPersistableNameProvider provider = (IPersistableNameProvider)node.getAdapter(IPersistableNameProvider.class);
            if (provider != null && (name = provider.getName((Object)node)) != null && !"".equals(name.trim())) {
                path = this.getRoot().append(name.trim());
            }
            if (path == null) {
                if (node.getStringProperty("id") != null && !"".equals(node.getStringProperty("id").trim())) {
                    path = this.getRoot().append(this.makeValidFileSystemName(node.getStringProperty("id").trim()));
                } else if (node.getName() != null && !"".equals(node.getName().trim())) {
                    path = this.getRoot().append(this.makeValidFileSystemName(node.getName().trim()));
                } else if (node.getProperty("URI.transient") != null) {
                    Object candidate = node.getProperty("URI.transient");
                    if (candidate instanceof URI) {
                        uri = (URI)candidate;
                    } else if (candidate instanceof String && !"".equals(((String)candidate).trim())) {
                        uri = URI.create(((String)candidate).trim());
                    }
                } else if (node.getUUID() != null) {
                    path = this.getRoot().append(this.makeValidFileSystemName(node.getUUID().toString().trim()));
                }
            }
            if (path != null) {
                if (!"json".equals(path.getFileExtension())) {
                    path = path.addFileExtension("json");
                }
                uri = path.toFile().toURI();
            }
        }
        return uri;
    }

    protected String makeValidFileSystemName(String name) {
        Assert.isNotNull((Object)name);
        return name.replaceAll("\\W", "_");
    }

    protected IPath getRoot() {
        IPath location;
        block5: {
            location = null;
            try {
                IPath path = Platform.getStateLocation((Bundle)CoreBundleActivator.getContext().getBundle()).append(".store");
                boolean exists = path.toFile().exists();
                if (!exists) {
                    exists = path.toFile().mkdirs();
                }
                if (exists && path.toFile().canRead() && path.toFile().isDirectory()) {
                    location = path;
                }
            }
            catch (IllegalStateException e) {
                IPath path = new Path(System.getProperty("user.home")).append(".tcf/.store");
                boolean exists = path.toFile().exists();
                if (!exists) {
                    exists = path.toFile().mkdirs();
                }
                if (!exists || !path.toFile().canRead() || !path.toFile().isDirectory()) break block5;
                location = path;
            }
        }
        return location;
    }
}

