/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.ui.internal.action;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.modisco.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.modisco.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.modisco.facet.custom.core.ICustomizationManager;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.modisco.facet.efacet.ui.FacetSetShortcutActionUtils;

public class ShortcutCustomAction
extends Action {
    private final String actionId;
    private final ICustomizationManager customManager;

    public ShortcutCustomAction(String actionId, String label, ImageDescriptor imageDescriptor, ICustomizationManager customManager) {
        super(label, 2);
        this.actionId = actionId;
        this.customManager = customManager;
        FacetSetShortcutActionUtils.setImageDescriptor((Action)this, (ImageDescriptor)imageDescriptor);
    }

    public void run() {
        FacetSetShortcutActionUtils.runAction((Action)this, (String)this.actionId, this.getAvailableFacetSets(), this.getAppliedFacetSets());
    }

    private Set<Customization> getAvailableFacetSets() {
        ResourceSet resourceSet = this.customManager.getResourceSet();
        ICustomizationCatalogManager catalog = ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(resourceSet);
        HashSet<Customization> availableCustoms = new HashSet<Customization>();
        availableCustoms.addAll(catalog.getRegisteredCustomizations());
        availableCustoms.addAll(this.customManager.getManagedCustomizations());
        return availableCustoms;
    }

    private List<Customization> getAppliedFacetSets() {
        return this.customManager.getManagedCustomizations();
    }
}

