/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.AtlResourceVisitor;
import org.eclipse.m2m.atl.adt.Messages;
import org.eclipse.m2m.atl.adt.runner.ATLProperties;
import org.eclipse.m2m.atl.adt.runner.CreateRunnableAtlOperation;
import org.eclipse.m2m.atl.engine.MarkerMaker;
import org.eclipse.m2m.atl.engine.compiler.AtlCompiler;
import org.eclipse.m2m.atl.engine.compiler.CompilerNotFoundException;

public class AtlBuildVisitor
extends AtlResourceVisitor {
    private MarkerMaker markerMaker = new MarkerMaker();
    private IProgressMonitor monitor;

    public AtlBuildVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private boolean hasChanged(IResource resource) {
        return resource.getLocalTimeStamp() > this.getBytecodeFile(resource).getLocalTimeStamp();
    }

    public boolean visit(IResource resource) throws CoreException {
        String extension = resource.getFileExtension();
        if ("atl".equals(extension) && resource instanceof IFile && ((IFile)resource).getLocation().toFile().length() > 0L && (!this.getBytecodeFile(resource).exists() || this.hasChanged(resource))) {
            String inName = resource.getName();
            this.monitor.subTask(Messages.getString("AtlBuildVisitor.COMPILETASK", new Object[]{inName}));
            InputStream is = ((IFile)resource).getContents();
            try {
                try {
                    InputStreamReader r = new InputStreamReader(is, ((IFile)resource).getCharset());
                    EObject[] pbms = AtlCompiler.compile((Reader)r, (IFile)this.getAsmFile(resource));
                    this.markerMaker.resetPbmMarkers(resource, pbms);
                    IFile newBytecodeFile = this.getBytecodeFile(resource);
                    if (newBytecodeFile.exists()) {
                        newBytecodeFile.setDerived(true, this.monitor);
                    }
                    if (pbms.length == 0) {
                        IFile[] iFileArray = this.getRelatedPropertyFiles((IFile)resource);
                        int n = iFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile propertyFile = iFileArray[n2];
                            if (!propertyFile.isDerived()) {
                                IFile javaFile = propertyFile.getParent().getFile(new Path(propertyFile.getName()).removeFileExtension().addFileExtension("java"));
                                CreateRunnableAtlOperation op = new CreateRunnableAtlOperation(propertyFile, javaFile);
                                op.run(this.monitor);
                            }
                            ++n2;
                        }
                    }
                }
                catch (CompilerNotFoundException cnfee) {
                    IMarker marker = resource.createMarker("org.eclipse.m2m.atl.engine.problem");
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("message", (Object)cnfee.getMessage());
                    marker.setAttribute("lineNumber", 1);
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.atl.adt", e.getLocalizedMessage(), (Throwable)e));
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.atl.adt", e.getLocalizedMessage(), (Throwable)e));
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.m2m.atl.adt", e.getLocalizedMessage(), (Throwable)e));
                }
            }
            return false;
        }
        return true;
    }

    private IFile[] getRelatedPropertyFiles(IFile atlFile) throws IOException, CoreException {
        ArrayList<IFile> res = new ArrayList<IFile>();
        for (IFile propertyFile : this.getAllPropertyFiles(atlFile.getParent())) {
            ATLProperties properties = new ATLProperties(propertyFile);
            IFile[] modules = properties.getTransformationFiles();
            if (modules == null || !Arrays.asList(modules).contains(atlFile)) continue;
            res.add(propertyFile);
        }
        return res.toArray(new IFile[res.size()]);
    }

    private List<IFile> getAllPropertyFiles(IContainer container) throws CoreException {
        if (container.getProject().hasNature("org.eclipse.pde.PluginNature")) {
            PropertiesVisitor visitor = new PropertiesVisitor();
            container.accept((IResourceVisitor)visitor);
            return visitor.getPropertyFiles();
        }
        return Collections.emptyList();
    }

    private class PropertiesVisitor
    implements IResourceVisitor {
        private List<IFile> propertyFiles = new ArrayList<IFile>();

        private PropertiesVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile propertyFile;
            if (resource instanceof IContainer) {
                return true;
            }
            if (resource instanceof IFile && "properties".equals((propertyFile = (IFile)resource).getFileExtension())) {
                IResource[] iResourceArray = resource.getParent().members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IFile && "atl".equals(member.getFileExtension()) && propertyFile.getName().equalsIgnoreCase(member.getFullPath().removeFileExtension().addFileExtension("properties").lastSegment())) {
                        this.propertyFiles.add(propertyFile);
                    }
                    ++n2;
                }
            }
            return true;
        }

        public List<IFile> getPropertyFiles() {
            return this.propertyFiles;
        }
    }
}

