/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.hyperlink.TaglibJarHyperlink;
import org.eclipse.jst.jsp.ui.internal.hyperlink.URLFileHyperlink;

class TaglibJarUriHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private ITaglibRecord fTaglibRecord;
    private IHyperlink fHyperlink;

    public TaglibJarUriHyperlink(IRegion region, ITaglibRecord record) {
        this.fRegion = region;
        this.fTaglibRecord = record;
    }

    private IHyperlink getHyperlink() {
        if (this.fHyperlink == null && this.fTaglibRecord != null) {
            switch (this.fTaglibRecord.getRecordType()) {
                case 2: {
                    IJarRecord record = (IJarRecord)this.fTaglibRecord;
                    this.fHyperlink = new TaglibJarHyperlink(this.fRegion, record.getLocation());
                    break;
                }
                case 4: {
                    IURLRecord record = (IURLRecord)this.fTaglibRecord;
                    this.fHyperlink = new URLFileHyperlink(this.fRegion, record.getURL());
                }
            }
        }
        return this.fHyperlink;
    }

    public IRegion getHyperlinkRegion() {
        IRegion region = null;
        IHyperlink link = this.getHyperlink();
        if (link != null) {
            region = link.getHyperlinkRegion();
        }
        return region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return JSPUIMessages.TLDHyperlink_hyperlinkText;
    }

    public void open() {
        IHyperlink link = this.getHyperlink();
        if (link != null) {
            link.open();
        }
    }
}

