/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.refactor.operations.IOptionalRefactorHandler;
import org.eclipse.jst.j2ee.refactor.operations.ProjectRefactorMetadata;

public class OptionalRefactorHandler
implements IOptionalRefactorHandler {
    private static final String EXTENSION_POINT = "optionalRefactorHandler";
    private static final String TAG_OPTIONAL_REFACTOR = "optionalRefactorHandler";
    private static final String ATT_CLASS = "class";
    private static OptionalRefactorHandler instance = new OptionalRefactorHandler();
    private IOptionalRefactorHandler[] handlers = null;

    private OptionalRefactorHandler() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                J2EEPlugin.logError(0, exception.getMessage(), exception);
            }

            public void run() throws Exception {
                OptionalRefactorHandlerRegistryReader reader = new OptionalRefactorHandlerRegistryReader();
                reader.readRegistry();
                OptionalRefactorHandler.this.handlers = reader.getHandlers();
            }
        });
    }

    public static OptionalRefactorHandler getInstance() {
        return instance;
    }

    @Override
    public boolean shouldRefactorDeletedProject(ProjectRefactorMetadata metadata) {
        int i = 0;
        while (i < this.handlers.length) {
            if (!this.handlers[i].shouldRefactorDeletedProject(metadata)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean shouldRefactorRenamedProject(ProjectRefactorMetadata metadata) {
        int i = 0;
        while (i < this.handlers.length) {
            if (!this.handlers[i].shouldRefactorRenamedProject(metadata)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean shouldRefactorDependentProjectOnDelete(ProjectRefactorMetadata deletedMetadata, ProjectRefactorMetadata dependentMetadata) {
        int i = 0;
        while (i < this.handlers.length) {
            if (!this.handlers[i].shouldRefactorDependentProjectOnDelete(deletedMetadata, dependentMetadata)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean shouldRefactorDependentProjectOnRename(ProjectRefactorMetadata renamedMetadata, ProjectRefactorMetadata dependentMetadata) {
        int i = 0;
        while (i < this.handlers.length) {
            if (!this.handlers[i].shouldRefactorDependentProjectOnRename(renamedMetadata, dependentMetadata)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class OptionalRefactorHandlerRegistryReader
    extends RegistryReader {
        private List innerHandlers;

        public OptionalRefactorHandlerRegistryReader() {
            super("org.eclipse.jst.j2ee", "optionalRefactorHandler");
            this.innerHandlers = new ArrayList();
        }

        public boolean readElement(final IConfigurationElement element) {
            if ("optionalRefactorHandler".equals(element.getName())) {
                final IOptionalRefactorHandler[] handlerArray = new IOptionalRefactorHandler[1];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        J2EEPlugin.logError(0, exception.getMessage(), exception);
                    }

                    public void run() throws Exception {
                        handlerArray[0] = (IOptionalRefactorHandler)element.createExecutableExtension(OptionalRefactorHandler.ATT_CLASS);
                    }
                });
                this.innerHandlers.add(handlerArray[0]);
                return true;
            }
            return false;
        }

        public IOptionalRefactorHandler[] getHandlers() {
            IOptionalRefactorHandler[] handlersArray = new IOptionalRefactorHandler[this.innerHandlers.size()];
            int i = 0;
            while (i < handlersArray.length) {
                handlersArray[i] = (IOptionalRefactorHandler)this.innerHandlers.get(i);
                ++i;
            }
            return handlersArray;
        }
    }
}

