/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.PriorityDLTKExtensionManager;
import org.eclipse.dltk.core.SimpleClassNewInstanceDLTKExtensionManager;
import org.eclipse.dltk.core.SimpleDLTKExtensionManager;
import org.eclipse.dltk.tcl.structure.ITclModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuilderDetector;

public class ModelBuilderManager {
    private static final String ID_ATTR = "id";
    private static final String EXTENSION_PROCESSOR = "org.eclipse.dltk.tcl.core.tclModelBuilder";
    private static final String EXTENSION_DETECTOR = "org.eclipse.dltk.tcl.core.tclModelBuilderDetector";
    private static final String CLASS_ATTR = "class";
    private SimpleExtensionManager commands = new SimpleExtensionManager("org.eclipse.dltk.tcl.core.tclModelBuilder");
    private SimpleClassNewInstanceDLTKExtensionManager detectors = new SimpleClassNewInstanceDLTKExtensionManager("org.eclipse.dltk.tcl.core.tclModelBuilderDetector");
    private static ModelBuilderManager sInstance = null;

    public ITclModelBuilder getModelBuilder(String name) {
        return (ITclModelBuilder)this.commands.get(name);
    }

    public ITclModelBuilderDetector[] getDetectors() {
        SimpleDLTKExtensionManager.ElementInfo[] objects = this.detectors.getElementInfos();
        ITclModelBuilderDetector[] results = new ITclModelBuilderDetector[objects.length];
        int i = 0;
        while (i < objects.length) {
            block3: {
                try {
                    results[i] = (ITclModelBuilderDetector)this.detectors.createObject(objects[i]);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return results;
    }

    public static synchronized ModelBuilderManager getInstance() {
        if (sInstance == null) {
            sInstance = new ModelBuilderManager();
        }
        return sInstance;
    }

    private static class SimpleExtensionManager
    extends PriorityDLTKExtensionManager {
        public SimpleExtensionManager(String extensionPoint) {
            super(extensionPoint, ModelBuilderManager.ID_ATTR);
        }

        public Object getInitObject(PriorityDLTKExtensionManager.ElementInfo ext) {
            block4: {
                try {
                    if (ext != null) {
                        if (ext.object == null) {
                            ext.object = this.createObject(ext.config);
                        }
                        return ext.object;
                    }
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            return null;
        }

        protected Object createObject(IConfigurationElement cfg) throws CoreException {
            return cfg.createExecutableExtension(ModelBuilderManager.CLASS_ATTR);
        }

        public Object get(String name) {
            return this.getInitObject(this.getElementInfo(name));
        }
    }
}

