/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;

public class QuickFixAddCaseSwitch
extends AbstractAstRewriteQuickFix {
    public String getLabel() {
        return QuickFixMessages.QuickFixAddCaseSwitch_add_cases_to_switch;
    }

    public void modifyAST(IIndex index, IMarker marker) {
        IASTTranslationUnit ast;
        try {
            ITranslationUnit tu = this.getTranslationUnitViaEditor(marker);
            ast = tu.getAST(index, 2);
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
            return;
        }
        IASTNode astNode = null;
        if (this.isCodanProblem(marker)) {
            astNode = this.getASTNodeFromMarker(marker, ast);
        }
        if (astNode == null || !(astNode instanceof IASTSwitchStatement)) {
            return;
        }
        ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)ast);
        INodeFactory factory = ast.getASTNodeFactory();
        Map<String, Number> missingEnums = this.getMissingCases((IASTSwitchStatement)astNode);
        HashSet existing = new HashSet();
        missingEnums = missingEnums.entrySet().stream().filter(entry -> existing.add((Number)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<IASTCaseStatement> caseStatements = new ArrayList<IASTCaseStatement>();
        for (Map.Entry<String, Number> e : missingEnums.entrySet()) {
            IASTName newName = factory.newName(e.getKey());
            caseStatements.add(factory.newCaseStatement((IASTExpression)factory.newIdExpression(newName)));
        }
        IASTBreakStatement breakStatement = factory.newBreakStatement();
        IASTNode[] children = astNode.getChildren();
        IASTCompoundStatement compound = null;
        IASTNullStatement nullStatement = null;
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IASTCompoundStatement) {
                compound = (IASTCompoundStatement)children[i];
                break;
            }
            if (children[i] instanceof IASTNullStatement) {
                nullStatement = (IASTNullStatement)children[i];
            }
            ++i;
        }
        if (compound == null && nullStatement != null) {
            compound = factory.newCompoundStatement();
            for (IASTCaseStatement caseStatement : caseStatements) {
                compound.addStatement((IASTStatement)caseStatement);
            }
            compound.addStatement((IASTStatement)breakStatement);
            r.replace((IASTNode)nullStatement, (IASTNode)compound, null);
        } else if (compound != null) {
            for (IASTCaseStatement caseStatement : caseStatements) {
                r.insertBefore((IASTNode)compound, null, (IASTNode)caseStatement, null);
            }
            r.insertBefore((IASTNode)compound, null, (IASTNode)breakStatement, null);
        } else {
            return;
        }
        Change c = r.rewriteAST();
        try {
            c.perform((IProgressMonitor)new NullProgressMonitor());
            marker.delete();
        }
        catch (CoreException e) {
            CheckersUiActivator.log(e);
        }
    }

    private Map<String, Number> getMissingCases(IASTSwitchStatement statement) {
        IASTExpression controller = statement.getControllerExpression();
        IASTStatement bodyStmt = statement.getBody();
        IType type = SemanticUtil.getUltimateType((IType)controller.getExpressionType(), (boolean)true);
        HashMap<String, Number> enumValues = new HashMap<String, Number>();
        if (type instanceof IEnumeration) {
            int i;
            IEnumerator[] enums = ((IEnumeration)type).getEnumerators();
            String prefix = "";
            if (type instanceof ICPPEnumeration) {
                String[] qualName = CPPVisitor.getQualifiedName((IBinding)((IEnumeration)type));
                StringBuilder builder = new StringBuilder();
                i = 0;
                while (i < qualName.length - 1) {
                    builder.append(qualName[i]);
                    builder.append("::");
                    ++i;
                }
                prefix = builder.toString();
            }
            IEnumerator[] iEnumeratorArray = enums;
            i = enums.length;
            int builder = 0;
            while (builder < i) {
                IEnumerator e = iEnumeratorArray[builder];
                enumValues.put(prefix + e.getName(), e.getValue().numberValue());
                ++builder;
            }
        } else {
            return enumValues;
        }
        List<IASTStatement> statements = bodyStmt instanceof IASTCompoundStatement ? Arrays.asList(((IASTCompoundStatement)bodyStmt).getStatements()) : Collections.singletonList(bodyStmt);
        for (IASTStatement s : statements) {
            Number value;
            if (s instanceof IASTCaseStatement && ((IASTCaseStatement)s).getExpression() instanceof IASTIdExpression) {
                IASTName name = ((IASTIdExpression)((IASTCaseStatement)s).getExpression()).getName();
                IBinding binding = name.resolveBinding();
                if (!(binding instanceof IEnumerator)) continue;
                enumValues.entrySet().removeIf(entry -> ((Number)entry.getValue()).equals(((IEnumerator)binding).getValue().numberValue()));
                continue;
            }
            if (!(s instanceof IASTCaseStatement) || !(((IASTCaseStatement)s).getExpression() instanceof IASTLiteralExpression) || (value = ValueFactory.getConstantNumericalValue((IASTExpression)((IASTCaseStatement)s).getExpression())) == null) continue;
            enumValues.entrySet().removeIf(entry -> ((Number)entry.getValue()).equals(value));
        }
        return enumValues;
    }
}

